/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.codec.language;

import com.contrastsecurity.thirdparty.oa4j.commons.codec.EncoderException;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.StringEncoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.binary.StringUtils;
import java.util.Locale;

public class DoubleMetaphone
implements StringEncoder {
    private static final String VOWELS = "AEIOUY";
    private static final String[] SILENT_START = new String[]{"GN", "KN", "PN", "WR", "PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
    private int maxCodeLen = 4;

    public String doubleMetaphone(String string) {
        return this.doubleMetaphone(string, false);
    }

    public String doubleMetaphone(String string, boolean bl2) {
        if ((string = this.cleanInput(string)) == null) {
            return null;
        }
        boolean bl3 = this.isSlavoGermanic(string);
        int n2 = this.isSilentStart(string) ? 1 : 0;
        DoubleMetaphoneResult doubleMetaphoneResult = new DoubleMetaphoneResult(this.getMaxCodeLen());
        block25: while (!doubleMetaphoneResult.isComplete() && n2 <= string.length() - 1) {
            switch (string.charAt(n2)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    n2 = this.handleAEIOUY(doubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'B': {
                    doubleMetaphoneResult.append('P');
                    n2 = this.charAt(string, n2 + 1) == 'B' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case '\u00c7': {
                    doubleMetaphoneResult.append('S');
                    ++n2;
                    continue block25;
                }
                case 'C': {
                    n2 = this.handleC(string, doubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'D': {
                    n2 = this.handleD(string, doubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'F': {
                    doubleMetaphoneResult.append('F');
                    n2 = this.charAt(string, n2 + 1) == 'F' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'G': {
                    n2 = this.handleG(string, doubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
                case 'H': {
                    n2 = this.handleH(string, doubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'J': {
                    n2 = this.handleJ(string, doubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
                case 'K': {
                    doubleMetaphoneResult.append('K');
                    n2 = this.charAt(string, n2 + 1) == 'K' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'L': {
                    n2 = this.handleL(string, doubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'M': {
                    doubleMetaphoneResult.append('M');
                    n2 = this.conditionM0(string, n2) ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'N': {
                    doubleMetaphoneResult.append('N');
                    n2 = this.charAt(string, n2 + 1) == 'N' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case '\u00d1': {
                    doubleMetaphoneResult.append('N');
                    ++n2;
                    continue block25;
                }
                case 'P': {
                    n2 = this.handleP(string, doubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'Q': {
                    doubleMetaphoneResult.append('K');
                    n2 = this.charAt(string, n2 + 1) == 'Q' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'R': {
                    n2 = this.handleR(string, doubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
                case 'S': {
                    n2 = this.handleS(string, doubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
                case 'T': {
                    n2 = this.handleT(string, doubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'V': {
                    doubleMetaphoneResult.append('F');
                    n2 = this.charAt(string, n2 + 1) == 'V' ? n2 + 2 : n2 + 1;
                    continue block25;
                }
                case 'W': {
                    n2 = this.handleW(string, doubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'X': {
                    n2 = this.handleX(string, doubleMetaphoneResult, n2);
                    continue block25;
                }
                case 'Z': {
                    n2 = this.handleZ(string, doubleMetaphoneResult, n2, bl3);
                    continue block25;
                }
            }
            ++n2;
        }
        return bl2 ? doubleMetaphoneResult.getAlternate() : doubleMetaphoneResult.getPrimary();
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("DoubleMetaphone encode parameter is not of type String");
        }
        return this.doubleMetaphone((String)object);
    }

    @Override
    public String encode(String string) {
        return this.doubleMetaphone(string);
    }

    public boolean isDoubleMetaphoneEqual(String string, String string2) {
        return this.isDoubleMetaphoneEqual(string, string2, false);
    }

    public boolean isDoubleMetaphoneEqual(String string, String string2, boolean bl2) {
        return StringUtils.equals(this.doubleMetaphone(string, bl2), this.doubleMetaphone(string2, bl2));
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    public void setMaxCodeLen(int n2) {
        this.maxCodeLen = n2;
    }

    private int handleAEIOUY(DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (n2 == 0) {
            doubleMetaphoneResult.append('A');
        }
        return n2 + 1;
    }

    private int handleC(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (this.conditionC0(string, n2)) {
            doubleMetaphoneResult.append('K');
            n2 += 2;
        } else if (n2 == 0 && DoubleMetaphone.contains(string, n2, 6, "CAESAR")) {
            doubleMetaphoneResult.append('S');
            n2 += 2;
        } else if (DoubleMetaphone.contains(string, n2, 2, "CH")) {
            n2 = this.handleCH(string, doubleMetaphoneResult, n2);
        } else if (DoubleMetaphone.contains(string, n2, 2, "CZ") && !DoubleMetaphone.contains(string, n2 - 2, 4, "WICZ")) {
            doubleMetaphoneResult.append('S', 'X');
            n2 += 2;
        } else if (DoubleMetaphone.contains(string, n2 + 1, 3, "CIA")) {
            doubleMetaphoneResult.append('X');
            n2 += 3;
        } else {
            if (DoubleMetaphone.contains(string, n2, 2, "CC") && (n2 != 1 || this.charAt(string, 0) != 'M')) {
                return this.handleCC(string, doubleMetaphoneResult, n2);
            }
            if (DoubleMetaphone.contains(string, n2, 2, "CK", "CG", "CQ")) {
                doubleMetaphoneResult.append('K');
                n2 += 2;
            } else if (DoubleMetaphone.contains(string, n2, 2, "CI", "CE", "CY")) {
                if (DoubleMetaphone.contains(string, n2, 3, "CIO", "CIE", "CIA")) {
                    doubleMetaphoneResult.append('S', 'X');
                } else {
                    doubleMetaphoneResult.append('S');
                }
                n2 += 2;
            } else {
                doubleMetaphoneResult.append('K');
                n2 = DoubleMetaphone.contains(string, n2 + 1, 2, " C", " Q", " G") ? (n2 += 3) : (DoubleMetaphone.contains(string, n2 + 1, 1, "C", "K", "Q") && !DoubleMetaphone.contains(string, n2 + 1, 2, "CE", "CI") ? (n2 += 2) : ++n2);
            }
        }
        return n2;
    }

    private int handleCC(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (DoubleMetaphone.contains(string, n2 + 2, 1, "I", "E", "H") && !DoubleMetaphone.contains(string, n2 + 2, 2, "HU")) {
            if (n2 == 1 && this.charAt(string, n2 - 1) == 'A' || DoubleMetaphone.contains(string, n2 - 1, 5, "UCCEE", "UCCES")) {
                doubleMetaphoneResult.append("KS");
            } else {
                doubleMetaphoneResult.append('X');
            }
            n2 += 3;
        } else {
            doubleMetaphoneResult.append('K');
            n2 += 2;
        }
        return n2;
    }

    private int handleCH(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (n2 > 0 && DoubleMetaphone.contains(string, n2, 4, "CHAE")) {
            doubleMetaphoneResult.append('K', 'X');
            return n2 + 2;
        }
        if (this.conditionCH0(string, n2)) {
            doubleMetaphoneResult.append('K');
            return n2 + 2;
        }
        if (this.conditionCH1(string, n2)) {
            doubleMetaphoneResult.append('K');
            return n2 + 2;
        }
        if (n2 > 0) {
            if (DoubleMetaphone.contains(string, 0, 2, "MC")) {
                doubleMetaphoneResult.append('K');
            } else {
                doubleMetaphoneResult.append('X', 'K');
            }
        } else {
            doubleMetaphoneResult.append('X');
        }
        return n2 + 2;
    }

    private int handleD(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (DoubleMetaphone.contains(string, n2, 2, "DG")) {
            if (DoubleMetaphone.contains(string, n2 + 2, 1, "I", "E", "Y")) {
                doubleMetaphoneResult.append('J');
                n2 += 3;
            } else {
                doubleMetaphoneResult.append("TK");
                n2 += 2;
            }
        } else if (DoubleMetaphone.contains(string, n2, 2, "DT", "DD")) {
            doubleMetaphoneResult.append('T');
            n2 += 2;
        } else {
            doubleMetaphoneResult.append('T');
            ++n2;
        }
        return n2;
    }

    private int handleG(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2, boolean bl2) {
        if (this.charAt(string, n2 + 1) == 'H') {
            n2 = this.handleGH(string, doubleMetaphoneResult, n2);
        } else if (this.charAt(string, n2 + 1) == 'N') {
            if (n2 == 1 && this.isVowel(this.charAt(string, 0)) && !bl2) {
                doubleMetaphoneResult.append("KN", "N");
            } else if (!DoubleMetaphone.contains(string, n2 + 2, 2, "EY") && this.charAt(string, n2 + 1) != 'Y' && !bl2) {
                doubleMetaphoneResult.append("N", "KN");
            } else {
                doubleMetaphoneResult.append("KN");
            }
            n2 += 2;
        } else if (DoubleMetaphone.contains(string, n2 + 1, 2, "LI") && !bl2) {
            doubleMetaphoneResult.append("KL", "L");
            n2 += 2;
        } else if (n2 == 0 && (this.charAt(string, n2 + 1) == 'Y' || DoubleMetaphone.contains(string, n2 + 1, 2, ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
            doubleMetaphoneResult.append('K', 'J');
            n2 += 2;
        } else if (!(!DoubleMetaphone.contains(string, n2 + 1, 2, "ER") && this.charAt(string, n2 + 1) != 'Y' || DoubleMetaphone.contains(string, 0, 6, "DANGER", "RANGER", "MANGER") || DoubleMetaphone.contains(string, n2 - 1, 1, "E", "I") || DoubleMetaphone.contains(string, n2 - 1, 3, "RGY", "OGY"))) {
            doubleMetaphoneResult.append('K', 'J');
            n2 += 2;
        } else if (DoubleMetaphone.contains(string, n2 + 1, 1, "E", "I", "Y") || DoubleMetaphone.contains(string, n2 - 1, 4, "AGGI", "OGGI")) {
            if (DoubleMetaphone.contains(string, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(string, 0, 3, "SCH") || DoubleMetaphone.contains(string, n2 + 1, 2, "ET")) {
                doubleMetaphoneResult.append('K');
            } else if (DoubleMetaphone.contains(string, n2 + 1, 3, "IER")) {
                doubleMetaphoneResult.append('J');
            } else {
                doubleMetaphoneResult.append('J', 'K');
            }
            n2 += 2;
        } else if (this.charAt(string, n2 + 1) == 'G') {
            n2 += 2;
            doubleMetaphoneResult.append('K');
        } else {
            ++n2;
            doubleMetaphoneResult.append('K');
        }
        return n2;
    }

    private int handleGH(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (n2 > 0 && !this.isVowel(this.charAt(string, n2 - 1))) {
            doubleMetaphoneResult.append('K');
            n2 += 2;
        } else if (n2 == 0) {
            if (this.charAt(string, n2 + 2) == 'I') {
                doubleMetaphoneResult.append('J');
            } else {
                doubleMetaphoneResult.append('K');
            }
            n2 += 2;
        } else if (n2 > 1 && DoubleMetaphone.contains(string, n2 - 2, 1, "B", "H", "D") || n2 > 2 && DoubleMetaphone.contains(string, n2 - 3, 1, "B", "H", "D") || n2 > 3 && DoubleMetaphone.contains(string, n2 - 4, 1, "B", "H")) {
            n2 += 2;
        } else {
            if (n2 > 2 && this.charAt(string, n2 - 1) == 'U' && DoubleMetaphone.contains(string, n2 - 3, 1, "C", "G", "L", "R", "T")) {
                doubleMetaphoneResult.append('F');
            } else if (n2 > 0 && this.charAt(string, n2 - 1) != 'I') {
                doubleMetaphoneResult.append('K');
            }
            n2 += 2;
        }
        return n2;
    }

    private int handleH(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if ((n2 == 0 || this.isVowel(this.charAt(string, n2 - 1))) && this.isVowel(this.charAt(string, n2 + 1))) {
            doubleMetaphoneResult.append('H');
            n2 += 2;
        } else {
            ++n2;
        }
        return n2;
    }

    private int handleJ(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2, boolean bl2) {
        if (DoubleMetaphone.contains(string, n2, 4, "JOSE") || DoubleMetaphone.contains(string, 0, 4, "SAN ")) {
            if (n2 == 0 && this.charAt(string, n2 + 4) == ' ' || string.length() == 4 || DoubleMetaphone.contains(string, 0, 4, "SAN ")) {
                doubleMetaphoneResult.append('H');
            } else {
                doubleMetaphoneResult.append('J', 'H');
            }
            ++n2;
        } else {
            if (n2 == 0 && !DoubleMetaphone.contains(string, n2, 4, "JOSE")) {
                doubleMetaphoneResult.append('J', 'A');
            } else if (this.isVowel(this.charAt(string, n2 - 1)) && !bl2 && (this.charAt(string, n2 + 1) == 'A' || this.charAt(string, n2 + 1) == 'O')) {
                doubleMetaphoneResult.append('J', 'H');
            } else if (n2 == string.length() - 1) {
                doubleMetaphoneResult.append('J', ' ');
            } else if (!DoubleMetaphone.contains(string, n2 + 1, 1, L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains(string, n2 - 1, 1, "S", "K", "L")) {
                doubleMetaphoneResult.append('J');
            }
            n2 = this.charAt(string, n2 + 1) == 'J' ? (n2 += 2) : ++n2;
        }
        return n2;
    }

    private int handleL(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (this.charAt(string, n2 + 1) == 'L') {
            if (this.conditionL0(string, n2)) {
                doubleMetaphoneResult.appendPrimary('L');
            } else {
                doubleMetaphoneResult.append('L');
            }
            n2 += 2;
        } else {
            ++n2;
            doubleMetaphoneResult.append('L');
        }
        return n2;
    }

    private int handleP(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (this.charAt(string, n2 + 1) == 'H') {
            doubleMetaphoneResult.append('F');
            n2 += 2;
        } else {
            doubleMetaphoneResult.append('P');
            n2 = DoubleMetaphone.contains(string, n2 + 1, 1, "P", "B") ? n2 + 2 : n2 + 1;
        }
        return n2;
    }

    private int handleR(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2, boolean bl2) {
        if (n2 == string.length() - 1 && !bl2 && DoubleMetaphone.contains(string, n2 - 2, 2, "IE") && !DoubleMetaphone.contains(string, n2 - 4, 2, "ME", "MA")) {
            doubleMetaphoneResult.appendAlternate('R');
        } else {
            doubleMetaphoneResult.append('R');
        }
        return this.charAt(string, n2 + 1) == 'R' ? n2 + 2 : n2 + 1;
    }

    private int handleS(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2, boolean bl2) {
        if (DoubleMetaphone.contains(string, n2 - 1, 3, "ISL", "YSL")) {
            ++n2;
        } else if (n2 == 0 && DoubleMetaphone.contains(string, n2, 5, "SUGAR")) {
            doubleMetaphoneResult.append('X', 'S');
            ++n2;
        } else if (DoubleMetaphone.contains(string, n2, 2, "SH")) {
            if (DoubleMetaphone.contains(string, n2 + 1, 4, "HEIM", "HOEK", "HOLM", "HOLZ")) {
                doubleMetaphoneResult.append('S');
            } else {
                doubleMetaphoneResult.append('X');
            }
            n2 += 2;
        } else if (DoubleMetaphone.contains(string, n2, 3, "SIO", "SIA") || DoubleMetaphone.contains(string, n2, 4, "SIAN")) {
            if (bl2) {
                doubleMetaphoneResult.append('S');
            } else {
                doubleMetaphoneResult.append('S', 'X');
            }
            n2 += 3;
        } else if (n2 == 0 && DoubleMetaphone.contains(string, n2 + 1, 1, "M", "N", "L", "W") || DoubleMetaphone.contains(string, n2 + 1, 1, "Z")) {
            doubleMetaphoneResult.append('S', 'X');
            n2 = DoubleMetaphone.contains(string, n2 + 1, 1, "Z") ? n2 + 2 : n2 + 1;
        } else if (DoubleMetaphone.contains(string, n2, 2, "SC")) {
            n2 = this.handleSC(string, doubleMetaphoneResult, n2);
        } else {
            if (n2 == string.length() - 1 && DoubleMetaphone.contains(string, n2 - 2, 2, "AI", "OI")) {
                doubleMetaphoneResult.appendAlternate('S');
            } else {
                doubleMetaphoneResult.append('S');
            }
            n2 = DoubleMetaphone.contains(string, n2 + 1, 1, "S", "Z") ? n2 + 2 : n2 + 1;
        }
        return n2;
    }

    private int handleSC(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (this.charAt(string, n2 + 2) == 'H') {
            if (DoubleMetaphone.contains(string, n2 + 3, 2, "OO", "ER", "EN", "UY", "ED", "EM")) {
                if (DoubleMetaphone.contains(string, n2 + 3, 2, "ER", "EN")) {
                    doubleMetaphoneResult.append("X", "SK");
                } else {
                    doubleMetaphoneResult.append("SK");
                }
            } else if (n2 == 0 && !this.isVowel(this.charAt(string, 3)) && this.charAt(string, 3) != 'W') {
                doubleMetaphoneResult.append('X', 'S');
            } else {
                doubleMetaphoneResult.append('X');
            }
        } else if (DoubleMetaphone.contains(string, n2 + 2, 1, "I", "E", "Y")) {
            doubleMetaphoneResult.append('S');
        } else {
            doubleMetaphoneResult.append("SK");
        }
        return n2 + 3;
    }

    private int handleT(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (DoubleMetaphone.contains(string, n2, 4, "TION")) {
            doubleMetaphoneResult.append('X');
            n2 += 3;
        } else if (DoubleMetaphone.contains(string, n2, 3, "TIA", "TCH")) {
            doubleMetaphoneResult.append('X');
            n2 += 3;
        } else if (DoubleMetaphone.contains(string, n2, 2, "TH") || DoubleMetaphone.contains(string, n2, 3, "TTH")) {
            if (DoubleMetaphone.contains(string, n2 + 2, 2, "OM", "AM") || DoubleMetaphone.contains(string, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(string, 0, 3, "SCH")) {
                doubleMetaphoneResult.append('T');
            } else {
                doubleMetaphoneResult.append('0', 'T');
            }
            n2 += 2;
        } else {
            doubleMetaphoneResult.append('T');
            n2 = DoubleMetaphone.contains(string, n2 + 1, 1, "T", "D") ? n2 + 2 : n2 + 1;
        }
        return n2;
    }

    private int handleW(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (DoubleMetaphone.contains(string, n2, 2, "WR")) {
            doubleMetaphoneResult.append('R');
            n2 += 2;
        } else if (n2 == 0 && (this.isVowel(this.charAt(string, n2 + 1)) || DoubleMetaphone.contains(string, n2, 2, "WH"))) {
            if (this.isVowel(this.charAt(string, n2 + 1))) {
                doubleMetaphoneResult.append('A', 'F');
            } else {
                doubleMetaphoneResult.append('A');
            }
            ++n2;
        } else if (n2 == string.length() - 1 && this.isVowel(this.charAt(string, n2 - 1)) || DoubleMetaphone.contains(string, n2 - 1, 5, "EWSKI", "EWSKY", "OWSKI", "OWSKY") || DoubleMetaphone.contains(string, 0, 3, "SCH")) {
            doubleMetaphoneResult.appendAlternate('F');
            ++n2;
        } else if (DoubleMetaphone.contains(string, n2, 4, "WICZ", "WITZ")) {
            doubleMetaphoneResult.append("TS", "FX");
            n2 += 4;
        } else {
            ++n2;
        }
        return n2;
    }

    private int handleX(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2) {
        if (n2 == 0) {
            doubleMetaphoneResult.append('S');
            ++n2;
        } else {
            if (n2 != string.length() - 1 || !DoubleMetaphone.contains(string, n2 - 3, 3, "IAU", "EAU") && !DoubleMetaphone.contains(string, n2 - 2, 2, "AU", "OU")) {
                doubleMetaphoneResult.append("KS");
            }
            n2 = DoubleMetaphone.contains(string, n2 + 1, 1, "C", "X") ? n2 + 2 : n2 + 1;
        }
        return n2;
    }

    private int handleZ(String string, DoubleMetaphoneResult doubleMetaphoneResult, int n2, boolean bl2) {
        if (this.charAt(string, n2 + 1) == 'H') {
            doubleMetaphoneResult.append('J');
            n2 += 2;
        } else {
            if (DoubleMetaphone.contains(string, n2 + 1, 2, "ZO", "ZI", "ZA") || bl2 && n2 > 0 && this.charAt(string, n2 - 1) != 'T') {
                doubleMetaphoneResult.append("S", "TS");
            } else {
                doubleMetaphoneResult.append('S');
            }
            n2 = this.charAt(string, n2 + 1) == 'Z' ? n2 + 2 : n2 + 1;
        }
        return n2;
    }

    private boolean conditionC0(String string, int n2) {
        if (DoubleMetaphone.contains(string, n2, 4, "CHIA")) {
            return true;
        }
        if (n2 <= 1) {
            return false;
        }
        if (this.isVowel(this.charAt(string, n2 - 2))) {
            return false;
        }
        if (!DoubleMetaphone.contains(string, n2 - 1, 3, "ACH")) {
            return false;
        }
        char c2 = this.charAt(string, n2 + 2);
        return c2 != 'I' && c2 != 'E' || DoubleMetaphone.contains(string, n2 - 2, 6, "BACHER", "MACHER");
    }

    private boolean conditionCH0(String string, int n2) {
        if (n2 != 0) {
            return false;
        }
        if (!DoubleMetaphone.contains(string, n2 + 1, 5, "HARAC", "HARIS") && !DoubleMetaphone.contains(string, n2 + 1, 3, "HOR", "HYM", "HIA", "HEM")) {
            return false;
        }
        return !DoubleMetaphone.contains(string, 0, 5, "CHORE");
    }

    private boolean conditionCH1(String string, int n2) {
        return DoubleMetaphone.contains(string, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(string, 0, 3, "SCH") || DoubleMetaphone.contains(string, n2 - 2, 6, "ORCHES", "ARCHIT", "ORCHID") || DoubleMetaphone.contains(string, n2 + 2, 1, "T", "S") || (DoubleMetaphone.contains(string, n2 - 1, 1, "A", "O", "U", "E") || n2 == 0) && (DoubleMetaphone.contains(string, n2 + 2, 1, L_R_N_M_B_H_F_V_W_SPACE) || n2 + 1 == string.length() - 1);
    }

    private boolean conditionL0(String string, int n2) {
        if (n2 == string.length() - 3 && DoubleMetaphone.contains(string, n2 - 1, 4, "ILLO", "ILLA", "ALLE")) {
            return true;
        }
        return (DoubleMetaphone.contains(string, string.length() - 2, 2, "AS", "OS") || DoubleMetaphone.contains(string, string.length() - 1, 1, "A", "O")) && DoubleMetaphone.contains(string, n2 - 1, 4, "ALLE");
    }

    private boolean conditionM0(String string, int n2) {
        if (this.charAt(string, n2 + 1) == 'M') {
            return true;
        }
        return DoubleMetaphone.contains(string, n2 - 1, 3, "UMB") && (n2 + 1 == string.length() - 1 || DoubleMetaphone.contains(string, n2 + 2, 2, "ER"));
    }

    private boolean isSlavoGermanic(String string) {
        return string.indexOf(87) > -1 || string.indexOf(75) > -1 || string.indexOf("CZ") > -1 || string.indexOf("WITZ") > -1;
    }

    private boolean isVowel(char c2) {
        return VOWELS.indexOf(c2) != -1;
    }

    private boolean isSilentStart(String string) {
        boolean bl2 = false;
        for (String string2 : SILENT_START) {
            if (!string.startsWith(string2)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    private String cleanInput(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string.toUpperCase(Locale.ENGLISH);
    }

    protected char charAt(String string, int n2) {
        if (n2 < 0 || n2 >= string.length()) {
            return '\u0000';
        }
        return string.charAt(n2);
    }

    protected static boolean contains(String string, int n2, int n3, String ... stringArray) {
        boolean bl2 = false;
        if (n2 >= 0 && n2 + n3 <= string.length()) {
            String string2 = string.substring(n2, n2 + n3);
            for (String string3 : stringArray) {
                if (!string2.equals(string3)) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public class DoubleMetaphoneResult {
        private final StringBuilder primary;
        private final StringBuilder alternate;
        private final int maxLength;

        public DoubleMetaphoneResult(int n2) {
            this.primary = new StringBuilder(DoubleMetaphone.this.getMaxCodeLen());
            this.alternate = new StringBuilder(DoubleMetaphone.this.getMaxCodeLen());
            this.maxLength = n2;
        }

        public void append(char c2) {
            this.appendPrimary(c2);
            this.appendAlternate(c2);
        }

        public void append(char c2, char c3) {
            this.appendPrimary(c2);
            this.appendAlternate(c3);
        }

        public void appendPrimary(char c2) {
            if (this.primary.length() < this.maxLength) {
                this.primary.append(c2);
            }
        }

        public void appendAlternate(char c2) {
            if (this.alternate.length() < this.maxLength) {
                this.alternate.append(c2);
            }
        }

        public void append(String string) {
            this.appendPrimary(string);
            this.appendAlternate(string);
        }

        public void append(String string, String string2) {
            this.appendPrimary(string);
            this.appendAlternate(string2);
        }

        public void appendPrimary(String string) {
            int n2 = this.maxLength - this.primary.length();
            if (string.length() <= n2) {
                this.primary.append(string);
            } else {
                this.primary.append(string.substring(0, n2));
            }
        }

        public void appendAlternate(String string) {
            int n2 = this.maxLength - this.alternate.length();
            if (string.length() <= n2) {
                this.alternate.append(string);
            } else {
                this.alternate.append(string.substring(0, n2));
            }
        }

        public String getPrimary() {
            return this.primary.toString();
        }

        public String getAlternate() {
            return this.alternate.toString();
        }

        public boolean isComplete() {
            return this.primary.length() >= this.maxLength && this.alternate.length() >= this.maxLength;
        }
    }
}

