/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.codec.net;

import com.contrastsecurity.thirdparty.oa4j.commons.codec.CodecPolicy;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.DecoderException;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.EncoderException;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.StringDecoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.StringEncoder;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.binary.Base64;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.binary.BaseNCodec;
import com.contrastsecurity.thirdparty.oa4j.commons.codec.net.RFC1522Codec;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BCodec
extends RFC1522Codec
implements StringDecoder,
StringEncoder {
    private static final CodecPolicy DECODING_POLICY_DEFAULT = CodecPolicy.LENIENT;
    private final Charset charset;
    private final CodecPolicy decodingPolicy;

    public BCodec() {
        this(StandardCharsets.UTF_8);
    }

    public BCodec(Charset charset) {
        this(charset, DECODING_POLICY_DEFAULT);
    }

    public BCodec(Charset charset, CodecPolicy codecPolicy) {
        this.charset = charset;
        this.decodingPolicy = codecPolicy;
    }

    public BCodec(String string) {
        this(Charset.forName(string));
    }

    public boolean isStrictDecoding() {
        return this.decodingPolicy == CodecPolicy.STRICT;
    }

    @Override
    protected String getEncoding() {
        return "B";
    }

    @Override
    protected byte[] doEncoding(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return Base64.encodeBase64(byArray);
    }

    @Override
    protected byte[] doDecoding(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new Base64(0, BaseNCodec.getChunkSeparator(), false, this.decodingPolicy).decode(byArray);
    }

    public String encode(String string, Charset charset) throws EncoderException {
        if (string == null) {
            return null;
        }
        return this.encodeText(string, charset);
    }

    public String encode(String string, String string2) throws EncoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.encodeText(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncoderException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    @Override
    public String encode(String string) throws EncoderException {
        if (string == null) {
            return null;
        }
        return this.encode(string, this.getCharset());
    }

    @Override
    public String decode(String string) throws DecoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.decodeText(string);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException exception) {
            throw new DecoderException(exception.getMessage(), exception);
        }
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.encode((String)object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be encoded using BCodec");
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be decoded using BCodec");
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getDefaultCharset() {
        return this.charset.name();
    }
}

