/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3;

public class BitField {
    private final int mask;
    private final int shiftCount;

    public BitField(int n2) {
        this.mask = n2;
        this.shiftCount = n2 == 0 ? 0 : Integer.numberOfTrailingZeros(n2);
    }

    public int clear(int n2) {
        return n2 & ~this.mask;
    }

    public byte clearByte(byte by2) {
        return (byte)this.clear(by2);
    }

    public short clearShort(short s2) {
        return (short)this.clear(s2);
    }

    public int getRawValue(int n2) {
        return n2 & this.mask;
    }

    public short getShortRawValue(short s2) {
        return (short)this.getRawValue(s2);
    }

    public short getShortValue(short s2) {
        return (short)this.getValue(s2);
    }

    public int getValue(int n2) {
        return this.getRawValue(n2) >> this.shiftCount;
    }

    public boolean isAllSet(int n2) {
        return (n2 & this.mask) == this.mask;
    }

    public boolean isSet(int n2) {
        return (n2 & this.mask) != 0;
    }

    public int set(int n2) {
        return n2 | this.mask;
    }

    public int setBoolean(int n2, boolean bl2) {
        return bl2 ? this.set(n2) : this.clear(n2);
    }

    public byte setByte(byte by2) {
        return (byte)this.set(by2);
    }

    public byte setByteBoolean(byte by2, boolean bl2) {
        return bl2 ? this.setByte(by2) : this.clearByte(by2);
    }

    public short setShort(short s2) {
        return (short)this.set(s2);
    }

    public short setShortBoolean(short s2, boolean bl2) {
        return bl2 ? this.setShort(s2) : this.clearShort(s2);
    }

    public short setShortValue(short s2, short s3) {
        return (short)this.setValue(s2, s3);
    }

    public int setValue(int n2, int n3) {
        return n2 & ~this.mask | n3 << this.shiftCount & this.mask;
    }
}

