/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3.time;

import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class CalendarUtils {
    public static final CalendarUtils INSTANCE = CalendarUtils.getInstance();
    private final Calendar calendar;
    private final Locale locale;

    public static CalendarUtils getInstance() {
        return new CalendarUtils(Calendar.getInstance());
    }

    static CalendarUtils getInstance(Locale locale) {
        return new CalendarUtils(Calendar.getInstance(locale), locale);
    }

    public CalendarUtils(Calendar calendar) {
        this(calendar, Locale.getDefault());
    }

    CalendarUtils(Calendar calendar, Locale locale) {
        this.calendar = Objects.requireNonNull(calendar, "calendar");
        this.locale = Objects.requireNonNull(locale, "locale");
    }

    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    public int getDayOfYear() {
        return this.calendar.get(6);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    String[] getMonthDisplayNames(int n3) {
        Map<String, Integer> map = this.calendar.getDisplayNames(2, n3, this.locale);
        if (map == null) {
            return null;
        }
        String[] stringArray = new String[map.size()];
        map.forEach((string, n2) -> {
            stringArray[n2.intValue()] = string;
        });
        return stringArray;
    }

    String[] getStandaloneLongMonthNames() {
        return this.getMonthDisplayNames(32770);
    }

    String[] getStandaloneShortMonthNames() {
        return this.getMonthDisplayNames(32769);
    }

    public int getYear() {
        return this.calendar.get(1);
    }
}

