/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.commons.lang3.time;

import com.contrastsecurity.thirdparty.oa4j.commons.lang3.ClassUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.LocaleUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.exception.ExceptionUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.time.CalendarUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.time.DatePrinter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FastDatePrinter
implements DatePrinter,
Serializable {
    private static final Rule[] EMPTY_RULE_ARRAY = new Rule[0];
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private static final int MAX_DIGITS = 10;
    private static final ConcurrentMap<TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<TimeZoneDisplayKey, String>(7);
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private transient Rule[] rules;
    private transient int maxLengthEstimate;

    private static void appendDigits(Appendable appendable, int n2) throws IOException {
        appendable.append((char)(n2 / 10 + 48));
        appendable.append((char)(n2 % 10 + 48));
    }

    private static void appendFullDigits(Appendable appendable, int n2, int n3) throws IOException {
        if (n2 < 10000) {
            int n4 = 4;
            if (n2 < 1000) {
                --n4;
                if (n2 < 100) {
                    --n4;
                    if (n2 < 10) {
                        --n4;
                    }
                }
            }
            for (int i2 = n3 - n4; i2 > 0; --i2) {
                appendable.append('0');
            }
            switch (n4) {
                case 4: {
                    appendable.append((char)(n2 / 1000 + 48));
                    n2 %= 1000;
                }
                case 3: {
                    if (n2 >= 100) {
                        appendable.append((char)(n2 / 100 + 48));
                        n2 %= 100;
                    } else {
                        appendable.append('0');
                    }
                }
                case 2: {
                    if (n2 >= 10) {
                        appendable.append((char)(n2 / 10 + 48));
                        n2 %= 10;
                    } else {
                        appendable.append('0');
                    }
                }
                case 1: {
                    appendable.append((char)(n2 + 48));
                }
            }
        } else {
            char[] cArray = new char[10];
            int n5 = 0;
            while (n2 != 0) {
                cArray[n5++] = (char)(n2 % 10 + 48);
                n2 /= 10;
            }
            while (n5 < n3) {
                appendable.append('0');
                --n3;
            }
            while (--n5 >= 0) {
                appendable.append(cArray[n5]);
            }
        }
    }

    static String getTimeZoneDisplay(TimeZone timeZone, boolean bl2, int n2, Locale locale) {
        TimeZoneDisplayKey timeZoneDisplayKey2 = new TimeZoneDisplayKey(timeZone, bl2, n2, locale);
        return cTimeZoneDisplayCache.computeIfAbsent(timeZoneDisplayKey2, timeZoneDisplayKey -> timeZone.getDisplayName(bl2, n2, locale));
    }

    protected FastDatePrinter(String string, TimeZone timeZone, Locale locale) {
        this.pattern = string;
        this.timeZone = timeZone;
        this.locale = LocaleUtils.toLocale(locale);
        this.init();
    }

    private <B extends Appendable> B applyRules(Calendar calendar, B b2) {
        try {
            for (Rule rule : this.rules) {
                rule.appendTo(b2, calendar);
            }
        }
        catch (IOException iOException) {
            ExceptionUtils.asRuntimeException(iOException);
        }
        return b2;
    }

    @Deprecated
    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    private String applyRulesToString(Calendar calendar) {
        return this.applyRules(calendar, new StringBuilder(this.maxLengthEstimate)).toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDatePrinter)) {
            return false;
        }
        FastDatePrinter fastDatePrinter = (FastDatePrinter)object;
        return this.pattern.equals(fastDatePrinter.pattern) && this.timeZone.equals(fastDatePrinter.timeZone) && this.locale.equals(fastDatePrinter.locale);
    }

    @Override
    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuilder(this.maxLengthEstimate)).toString();
    }

    @Override
    public <B extends Appendable> B format(Calendar calendar, B b2) {
        if (!calendar.getTimeZone().equals(this.timeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.timeZone);
        }
        return this.applyRules(calendar, b2);
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.format(calendar.getTime(), stringBuffer);
    }

    @Override
    public String format(Date date) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRulesToString(calendar);
    }

    @Override
    public <B extends Appendable> B format(Date date, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, b2);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    @Override
    public String format(long l2) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRulesToString(calendar);
    }

    @Override
    public <B extends Appendable> B format(long l2, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRules(calendar, b2);
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    String format(Object object) {
        if (object instanceof Date) {
            return this.format((Date)object);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object);
        }
        if (object instanceof Long) {
            return this.format((Long)object);
        }
        throw new IllegalArgumentException("Unknown class: " + ClassUtils.getName(object, "<null>"));
    }

    @Override
    @Deprecated
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((long)((Long)object), stringBuffer);
        }
        throw new IllegalArgumentException("Unknown class: " + ClassUtils.getName(object, "<null>"));
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public int getMaxLengthEstimate() {
        return this.maxLengthEstimate;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    private void init() {
        List<Rule> list = this.parsePattern();
        this.rules = list.toArray(EMPTY_RULE_ARRAY);
        int n2 = 0;
        int n3 = this.rules.length;
        while (--n3 >= 0) {
            n2 += this.rules[n3].estimateLength();
        }
        this.maxLengthEstimate = n2;
    }

    private Calendar newCalendar() {
        return Calendar.getInstance(this.timeZone, this.locale);
    }

    protected List<Rule> parsePattern() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        String[] stringArray = dateFormatSymbols.getEras();
        String[] stringArray2 = dateFormatSymbols.getMonths();
        String[] stringArray3 = dateFormatSymbols.getShortMonths();
        String[] stringArray4 = dateFormatSymbols.getWeekdays();
        String[] stringArray5 = dateFormatSymbols.getShortWeekdays();
        String[] stringArray6 = dateFormatSymbols.getAmPmStrings();
        int n2 = this.pattern.length();
        int[] nArray = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            Rule rule;
            nArray[0] = i2;
            String string = this.parseToken(this.pattern, nArray);
            i2 = nArray[0];
            int n3 = string.length();
            if (n3 == 0) break;
            char c2 = string.charAt(0);
            switch (c2) {
                case 'G': {
                    rule = new TextField(0, stringArray);
                    break;
                }
                case 'Y': 
                case 'y': {
                    rule = n3 == 2 ? TwoDigitYearField.INSTANCE : this.selectNumberRule(1, Math.max(n3, 4));
                    if (c2 != 'Y') break;
                    rule = new WeekYear((NumberRule)rule);
                    break;
                }
                case 'M': {
                    if (n3 >= 4) {
                        rule = new TextField(2, stringArray2);
                        break;
                    }
                    if (n3 == 3) {
                        rule = new TextField(2, stringArray3);
                        break;
                    }
                    if (n3 == 2) {
                        rule = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    rule = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'L': {
                    if (n3 >= 4) {
                        rule = new TextField(2, CalendarUtils.getInstance(this.locale).getStandaloneLongMonthNames());
                        break;
                    }
                    if (n3 == 3) {
                        rule = new TextField(2, CalendarUtils.getInstance(this.locale).getStandaloneShortMonthNames());
                        break;
                    }
                    if (n3 == 2) {
                        rule = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    rule = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    rule = this.selectNumberRule(5, n3);
                    break;
                }
                case 'h': {
                    rule = new TwelveHourField(this.selectNumberRule(10, n3));
                    break;
                }
                case 'H': {
                    rule = this.selectNumberRule(11, n3);
                    break;
                }
                case 'm': {
                    rule = this.selectNumberRule(12, n3);
                    break;
                }
                case 's': {
                    rule = this.selectNumberRule(13, n3);
                    break;
                }
                case 'S': {
                    rule = this.selectNumberRule(14, n3);
                    break;
                }
                case 'E': {
                    rule = new TextField(7, n3 < 4 ? stringArray5 : stringArray4);
                    break;
                }
                case 'u': {
                    rule = new DayInWeekField(this.selectNumberRule(7, n3));
                    break;
                }
                case 'D': {
                    rule = this.selectNumberRule(6, n3);
                    break;
                }
                case 'F': {
                    rule = this.selectNumberRule(8, n3);
                    break;
                }
                case 'w': {
                    rule = this.selectNumberRule(3, n3);
                    break;
                }
                case 'W': {
                    rule = this.selectNumberRule(4, n3);
                    break;
                }
                case 'a': {
                    rule = new TextField(9, stringArray6);
                    break;
                }
                case 'k': {
                    rule = new TwentyFourHourField(this.selectNumberRule(11, n3));
                    break;
                }
                case 'K': {
                    rule = this.selectNumberRule(10, n3);
                    break;
                }
                case 'X': {
                    rule = Iso8601_Rule.getRule(n3);
                    break;
                }
                case 'z': {
                    if (n3 >= 4) {
                        rule = new TimeZoneNameRule(this.timeZone, this.locale, 1);
                        break;
                    }
                    rule = new TimeZoneNameRule(this.timeZone, this.locale, 0);
                    break;
                }
                case 'Z': {
                    if (n3 == 1) {
                        rule = TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (n3 == 2) {
                        rule = Iso8601_Rule.ISO8601_HOURS_COLON_MINUTES;
                        break;
                    }
                    rule = TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String string2 = string.substring(1);
                    if (string2.length() == 1) {
                        rule = new CharacterLiteral(string2.charAt(0));
                        break;
                    }
                    rule = new StringLiteral(string2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string);
                }
            }
            arrayList.add(rule);
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length();
        char c2 = string.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            stringBuilder.append(c2);
            while (n2 + 1 < n3 && (c3 = string.charAt(n2 + 1)) == c2) {
                stringBuilder.append(c2);
                ++n2;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl2 = false;
            for (n2 = nArray[0]; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (c2 == '\'') {
                    if (n2 + 1 < n3 && string.charAt(n2 + 1) == '\'') {
                        ++n2;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl2 = !bl2;
                    continue;
                }
                if (bl2 || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    stringBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n2;
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    protected NumberRule selectNumberRule(int n2, int n3) {
        switch (n3) {
            case 1: {
                return new UnpaddedNumberField(n2);
            }
            case 2: {
                return new TwoDigitNumberField(n2);
            }
        }
        return new PaddedNumberField(n2, n3);
    }

    public String toString() {
        return "FastDatePrinter[" + this.pattern + "," + this.locale + "," + this.timeZone.getID() + "]";
    }

    private static class TimeZoneDisplayKey {
        private final TimeZone timeZone;
        private final int style;
        private final Locale locale;

        TimeZoneDisplayKey(TimeZone timeZone, boolean bl2, int n2, Locale locale) {
            this.timeZone = timeZone;
            this.style = bl2 ? n2 | Integer.MIN_VALUE : n2;
            this.locale = LocaleUtils.toLocale(locale);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof TimeZoneDisplayKey) {
                TimeZoneDisplayKey timeZoneDisplayKey = (TimeZoneDisplayKey)object;
                return this.timeZone.equals(timeZoneDisplayKey.timeZone) && this.style == timeZoneDisplayKey.style && this.locale.equals(timeZoneDisplayKey.locale);
            }
            return false;
        }

        public int hashCode() {
            return (this.style * 31 + this.locale.hashCode()) * 31 + this.timeZone.hashCode();
        }
    }

    private static interface Rule {
        public void appendTo(Appendable var1, Calendar var2) throws IOException;

        public int estimateLength();
    }

    private static class TextField
    implements Rule {
        private final int field;
        private final String[] values;

        TextField(int n2, String[] stringArray) {
            this.field = n2;
            this.values = stringArray;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            appendable.append(this.values[calendar.get(this.field)]);
        }

        @Override
        public int estimateLength() {
            int n2 = 0;
            int n3 = this.values.length;
            while (--n3 >= 0) {
                int n4 = this.values[n3].length();
                if (n4 <= n2) continue;
                n2 = n4;
            }
            return n2;
        }
    }

    private static class TwoDigitYearField
    implements NumberRule {
        static final TwoDigitYearField INSTANCE = new TwoDigitYearField();

        TwoDigitYearField() {
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(1) % 100);
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            FastDatePrinter.appendDigits(appendable, n2 % 100);
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static interface NumberRule
    extends Rule {
        public void appendTo(Appendable var1, int var2) throws IOException;
    }

    private static class WeekYear
    implements NumberRule {
        private final NumberRule rule;

        WeekYear(NumberRule numberRule) {
            this.rule = numberRule;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.rule.appendTo(appendable, calendar.getWeekYear());
        }

        @Override
        public void appendTo(Appendable appendable, int n2) throws IOException {
            this.rule.appendTo(appendable, n2);
        }

        @Override
        public int estimateLength() {
            return this.rule.estimateLength();
        }
    }

    private static class TwoDigitMonthField
    implements NumberRule {
        static final TwoDigitMonthField INSTANCE = new TwoDigitMonthField();

        TwoDigitMonthField() {
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(2) + 1);
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            FastDatePrinter.appendDigits(appendable, n2);
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static class UnpaddedMonthField
    implements NumberRule {
        static final UnpaddedMonthField INSTANCE = new UnpaddedMonthField();

        UnpaddedMonthField() {
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(2) + 1);
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            if (n2 < 10) {
                appendable.append((char)(n2 + 48));
            } else {
                FastDatePrinter.appendDigits(appendable, n2);
            }
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static class TwelveHourField
    implements NumberRule {
        private final NumberRule rule;

        TwelveHourField(NumberRule numberRule) {
            this.rule = numberRule;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(10);
            if (n2 == 0) {
                n2 = calendar.getLeastMaximum(10) + 1;
            }
            this.rule.appendTo(appendable, n2);
        }

        @Override
        public void appendTo(Appendable appendable, int n2) throws IOException {
            this.rule.appendTo(appendable, n2);
        }

        @Override
        public int estimateLength() {
            return this.rule.estimateLength();
        }
    }

    private static class DayInWeekField
    implements NumberRule {
        private final NumberRule rule;

        DayInWeekField(NumberRule numberRule) {
            this.rule = numberRule;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(7);
            this.rule.appendTo(appendable, n2 == 1 ? 7 : n2 - 1);
        }

        @Override
        public void appendTo(Appendable appendable, int n2) throws IOException {
            this.rule.appendTo(appendable, n2);
        }

        @Override
        public int estimateLength() {
            return this.rule.estimateLength();
        }
    }

    private static class TwentyFourHourField
    implements NumberRule {
        private final NumberRule rule;

        TwentyFourHourField(NumberRule numberRule) {
            this.rule = numberRule;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(11);
            if (n2 == 0) {
                n2 = calendar.getMaximum(11) + 1;
            }
            this.rule.appendTo(appendable, n2);
        }

        @Override
        public void appendTo(Appendable appendable, int n2) throws IOException {
            this.rule.appendTo(appendable, n2);
        }

        @Override
        public int estimateLength() {
            return this.rule.estimateLength();
        }
    }

    private static class Iso8601_Rule
    implements Rule {
        static final Iso8601_Rule ISO8601_HOURS = new Iso8601_Rule(3);
        static final Iso8601_Rule ISO8601_HOURS_MINUTES = new Iso8601_Rule(5);
        static final Iso8601_Rule ISO8601_HOURS_COLON_MINUTES = new Iso8601_Rule(6);
        private final int length;

        static Iso8601_Rule getRule(int n2) {
            switch (n2) {
                case 1: {
                    return ISO8601_HOURS;
                }
                case 2: {
                    return ISO8601_HOURS_MINUTES;
                }
                case 3: {
                    return ISO8601_HOURS_COLON_MINUTES;
                }
            }
            throw new IllegalArgumentException("invalid number of X");
        }

        Iso8601_Rule(int n2) {
            this.length = n2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(15) + calendar.get(16);
            if (n2 == 0) {
                appendable.append("Z");
                return;
            }
            if (n2 < 0) {
                appendable.append('-');
                n2 = -n2;
            } else {
                appendable.append('+');
            }
            int n3 = n2 / 3600000;
            FastDatePrinter.appendDigits(appendable, n3);
            if (this.length < 5) {
                return;
            }
            if (this.length == 6) {
                appendable.append(':');
            }
            int n4 = n2 / 60000 - 60 * n3;
            FastDatePrinter.appendDigits(appendable, n4);
        }

        @Override
        public int estimateLength() {
            return this.length;
        }
    }

    private static class TimeZoneNameRule
    implements Rule {
        private final Locale locale;
        private final int style;
        private final String standard;
        private final String daylight;

        TimeZoneNameRule(TimeZone timeZone, Locale locale, int n2) {
            this.locale = LocaleUtils.toLocale(locale);
            this.style = n2;
            this.standard = FastDatePrinter.getTimeZoneDisplay(timeZone, false, n2, locale);
            this.daylight = FastDatePrinter.getTimeZoneDisplay(timeZone, true, n2, locale);
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            TimeZone timeZone = calendar.getTimeZone();
            boolean bl2 = calendar.get(16) != 0;
            appendable.append(FastDatePrinter.getTimeZoneDisplay(timeZone, bl2, this.style, this.locale));
        }

        @Override
        public int estimateLength() {
            return Math.max(this.standard.length(), this.daylight.length());
        }
    }

    private static class TimeZoneNumberRule
    implements Rule {
        static final TimeZoneNumberRule INSTANCE_COLON = new TimeZoneNumberRule(true);
        static final TimeZoneNumberRule INSTANCE_NO_COLON = new TimeZoneNumberRule(false);
        private final boolean colon;

        TimeZoneNumberRule(boolean bl2) {
            this.colon = bl2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(15) + calendar.get(16);
            if (n2 < 0) {
                appendable.append('-');
                n2 = -n2;
            } else {
                appendable.append('+');
            }
            int n3 = n2 / 3600000;
            FastDatePrinter.appendDigits(appendable, n3);
            if (this.colon) {
                appendable.append(':');
            }
            int n4 = n2 / 60000 - 60 * n3;
            FastDatePrinter.appendDigits(appendable, n4);
        }

        @Override
        public int estimateLength() {
            return 5;
        }
    }

    private static class CharacterLiteral
    implements Rule {
        private final char value;

        CharacterLiteral(char c2) {
            this.value = c2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            appendable.append(this.value);
        }

        @Override
        public int estimateLength() {
            return 1;
        }
    }

    private static class StringLiteral
    implements Rule {
        private final String value;

        StringLiteral(String string) {
            this.value = string;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            appendable.append(this.value);
        }

        @Override
        public int estimateLength() {
            return this.value.length();
        }
    }

    private static class UnpaddedNumberField
    implements NumberRule {
        private final int field;

        UnpaddedNumberField(int n2) {
            this.field = n2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(this.field));
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            if (n2 < 10) {
                appendable.append((char)(n2 + 48));
            } else if (n2 < 100) {
                FastDatePrinter.appendDigits(appendable, n2);
            } else {
                FastDatePrinter.appendFullDigits(appendable, n2, 1);
            }
        }

        @Override
        public int estimateLength() {
            return 4;
        }
    }

    private static class TwoDigitNumberField
    implements NumberRule {
        private final int field;

        TwoDigitNumberField(int n2) {
            this.field = n2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(this.field));
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            if (n2 < 100) {
                FastDatePrinter.appendDigits(appendable, n2);
            } else {
                FastDatePrinter.appendFullDigits(appendable, n2, 2);
            }
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static final class PaddedNumberField
    implements NumberRule {
        private final int field;
        private final int size;

        PaddedNumberField(int n2, int n3) {
            if (n3 < 3) {
                throw new IllegalArgumentException();
            }
            this.field = n2;
            this.size = n3;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(this.field));
        }

        @Override
        public void appendTo(Appendable appendable, int n2) throws IOException {
            FastDatePrinter.appendFullDigits(appendable, n2, this.size);
        }

        @Override
        public int estimateLength() {
            return this.size;
        }
    }
}

