/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.client.protocol;

import com.contrastsecurity.thirdparty.oa4j.commons.logging.Log;
import com.contrastsecurity.thirdparty.oa4j.commons.logging.LogFactory;
import com.contrastsecurity.thirdparty.oa4j.http.Header;
import com.contrastsecurity.thirdparty.oa4j.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.http.HttpHost;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequest;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequestInterceptor;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.client.CookieStore;
import com.contrastsecurity.thirdparty.oa4j.http.client.config.RequestConfig;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpUriRequest;
import com.contrastsecurity.thirdparty.oa4j.http.client.protocol.HttpClientContext;
import com.contrastsecurity.thirdparty.oa4j.http.config.Lookup;
import com.contrastsecurity.thirdparty.oa4j.http.conn.routing.RouteInfo;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.Cookie;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieOrigin;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieSpec;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieSpecProvider;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import com.contrastsecurity.thirdparty.oa4j.http.util.TextUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAddCookies
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Header header;
        int n2;
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(httpContext, "HTTP context");
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT")) {
            return;
        }
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        CookieStore cookieStore = httpClientContext.getCookieStore();
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        Lookup<CookieSpecProvider> lookup = httpClientContext.getCookieSpecRegistry();
        if (lookup == null) {
            this.log.debug("CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost httpHost = httpClientContext.getTargetHost();
        if (httpHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        RouteInfo routeInfo = httpClientContext.getHttpRoute();
        if (routeInfo == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        String string2 = requestConfig.getCookieSpec();
        if (string2 == null) {
            string2 = "default";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("CookieSpec selected: " + string2);
        }
        URI uRI = null;
        if (httpRequest instanceof HttpUriRequest) {
            uRI = ((HttpUriRequest)httpRequest).getURI();
        } else {
            try {
                uRI = new URI(httpRequest.getRequestLine().getUri());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String string3 = uRI != null ? uRI.getPath() : null;
        String string4 = httpHost.getHostName();
        int n3 = httpHost.getPort();
        if (n3 < 0) {
            n3 = routeInfo.getTargetHost().getPort();
        }
        CookieOrigin cookieOrigin = new CookieOrigin(string4, n3 >= 0 ? n3 : 0, !TextUtils.isEmpty(string3) ? string3 : "/", routeInfo.isSecure());
        CookieSpecProvider cookieSpecProvider = lookup.lookup(string2);
        if (cookieSpecProvider == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unsupported cookie policy: " + string2);
            }
            return;
        }
        CookieSpec cookieSpec = cookieSpecProvider.create(httpClientContext);
        List<Cookie> list = cookieStore.getCookies();
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        Date date = new Date();
        boolean bl2 = false;
        for (Cookie object2 : list) {
            if (!object2.isExpired(date)) {
                if (!cookieSpec.match(object2, cookieOrigin)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cookie " + object2 + " match " + cookieOrigin);
                }
                arrayList.add(object2);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cookie " + object2 + " expired");
            }
            bl2 = true;
        }
        if (bl2) {
            cookieStore.clearExpired(date);
        }
        if (!arrayList.isEmpty()) {
            List<Header> list2 = cookieSpec.formatCookies(arrayList);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Header header2 = (Header)iterator.next();
                httpRequest.addHeader(header2);
            }
        }
        if ((n2 = cookieSpec.getVersion()) > 0 && (header = cookieSpec.getVersionHeader()) != null) {
            httpRequest.addHeader(header);
        }
        httpContext.setAttribute("http.cookie-spec", cookieSpec);
        httpContext.setAttribute("http.cookie-origin", cookieOrigin);
    }
}

