/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.conn.routing;

import com.contrastsecurity.thirdparty.oa4j.http.HttpHost;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.conn.routing.RouteInfo;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import com.contrastsecurity.thirdparty.oa4j.http.util.LangUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class HttpRoute
implements RouteInfo,
Cloneable {
    private final HttpHost targetHost;
    private final InetAddress localAddress;
    private final List<HttpHost> proxyChain;
    private final RouteInfo.TunnelType tunnelled;
    private final RouteInfo.LayerType layered;
    private final boolean secure;

    private HttpRoute(HttpHost httpHost, InetAddress inetAddress, List<HttpHost> list, boolean bl2, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        Args.notNull(httpHost, "Target host");
        this.targetHost = HttpRoute.normalize(httpHost);
        this.localAddress = inetAddress;
        this.proxyChain = list != null && !list.isEmpty() ? new ArrayList<HttpHost>(list) : null;
        if (tunnelType == RouteInfo.TunnelType.TUNNELLED) {
            Args.check(this.proxyChain != null, "Proxy required if tunnelled");
        }
        this.secure = bl2;
        this.tunnelled = tunnelType != null ? tunnelType : RouteInfo.TunnelType.PLAIN;
        this.layered = layerType != null ? layerType : RouteInfo.LayerType.PLAIN;
    }

    private static int getDefaultPort(String string) {
        if ("http".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return 443;
        }
        return -1;
    }

    private static HttpHost normalize(HttpHost httpHost) {
        if (httpHost.getPort() >= 0) {
            return httpHost;
        }
        InetAddress inetAddress = httpHost.getAddress();
        String string = httpHost.getSchemeName();
        return inetAddress != null ? new HttpHost(inetAddress, HttpRoute.getDefaultPort(string), string) : new HttpHost(httpHost.getHostName(), HttpRoute.getDefaultPort(string), string);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost[] httpHostArray, boolean bl2, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this(httpHost, inetAddress, httpHostArray != null ? Arrays.asList(httpHostArray) : null, bl2, tunnelType, layerType);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl2, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this(httpHost, inetAddress, httpHost2 != null ? Collections.singletonList(httpHost2) : null, bl2, tunnelType, layerType);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, boolean bl2) {
        this(httpHost, inetAddress, Collections.emptyList(), bl2, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost) {
        this(httpHost, null, Collections.emptyList(), false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl2) {
        this(httpHost, inetAddress, Collections.singletonList(Args.notNull(httpHost2, "Proxy host")), bl2, bl2 ? RouteInfo.TunnelType.TUNNELLED : RouteInfo.TunnelType.PLAIN, bl2 ? RouteInfo.LayerType.LAYERED : RouteInfo.LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost, HttpHost httpHost2) {
        this(httpHost, null, httpHost2, false);
    }

    @Override
    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public final InetSocketAddress getLocalSocketAddress() {
        return this.localAddress != null ? new InetSocketAddress(this.localAddress, 0) : null;
    }

    @Override
    public final int getHopCount() {
        return this.proxyChain != null ? this.proxyChain.size() + 1 : 1;
    }

    @Override
    public final HttpHost getHopTarget(int n2) {
        Args.notNegative(n2, "Hop index");
        int n3 = this.getHopCount();
        Args.check(n2 < n3, "Hop index exceeds tracked route length");
        return n2 < n3 - 1 ? this.proxyChain.get(n2) : this.targetHost;
    }

    @Override
    public final HttpHost getProxyHost() {
        return this.proxyChain != null && !this.proxyChain.isEmpty() ? this.proxyChain.get(0) : null;
    }

    @Override
    public final RouteInfo.TunnelType getTunnelType() {
        return this.tunnelled;
    }

    @Override
    public final boolean isTunnelled() {
        return this.tunnelled == RouteInfo.TunnelType.TUNNELLED;
    }

    @Override
    public final RouteInfo.LayerType getLayerType() {
        return this.layered;
    }

    @Override
    public final boolean isLayered() {
        return this.layered == RouteInfo.LayerType.LAYERED;
    }

    @Override
    public final boolean isSecure() {
        return this.secure;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HttpRoute) {
            HttpRoute httpRoute = (HttpRoute)object;
            return this.secure == httpRoute.secure && this.tunnelled == httpRoute.tunnelled && this.layered == httpRoute.layered && LangUtils.equals(this.targetHost, httpRoute.targetHost) && LangUtils.equals(this.localAddress, httpRoute.localAddress) && LangUtils.equals(this.proxyChain, httpRoute.proxyChain);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = 17;
        n2 = LangUtils.hashCode(n2, this.targetHost);
        n2 = LangUtils.hashCode(n2, this.localAddress);
        if (this.proxyChain != null) {
            for (HttpHost httpHost : this.proxyChain) {
                n2 = LangUtils.hashCode(n2, httpHost);
            }
        }
        n2 = LangUtils.hashCode(n2, this.secure);
        n2 = LangUtils.hashCode(n2, (Object)this.tunnelled);
        n2 = LangUtils.hashCode(n2, (Object)this.layered);
        return n2;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(50 + this.getHopCount() * 30);
        if (this.localAddress != null) {
            stringBuilder.append(this.localAddress);
            stringBuilder.append("->");
        }
        stringBuilder.append('{');
        if (this.tunnelled == RouteInfo.TunnelType.TUNNELLED) {
            stringBuilder.append('t');
        }
        if (this.layered == RouteInfo.LayerType.LAYERED) {
            stringBuilder.append('l');
        }
        if (this.secure) {
            stringBuilder.append('s');
        }
        stringBuilder.append("}->");
        if (this.proxyChain != null) {
            for (HttpHost httpHost : this.proxyChain) {
                stringBuilder.append(httpHost);
                stringBuilder.append("->");
            }
        }
        stringBuilder.append(this.targetHost);
        return stringBuilder.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

