/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.cookie;

import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.ClientCookie;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CommonCookieAttributeHandler;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.Cookie;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieOrigin;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.CookieRestrictionViolationException;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.MalformedCookieException;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.SetCookie;
import com.contrastsecurity.thirdparty.oa4j.http.cookie.SetCookie2;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        if (n2 < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        setCookie.setVersion(n2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

