/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.impl.execchain;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.client.BackoffManager;
import com.contrastsecurity.thirdparty.oa4j.http.client.ConnectionBackoffStrategy;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.CloseableHttpResponse;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpExecutionAware;
import com.contrastsecurity.thirdparty.oa4j.http.client.methods.HttpRequestWrapper;
import com.contrastsecurity.thirdparty.oa4j.http.client.protocol.HttpClientContext;
import com.contrastsecurity.thirdparty.oa4j.http.conn.routing.HttpRoute;
import com.contrastsecurity.thirdparty.oa4j.http.impl.execchain.ClientExecChain;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BackoffStrategyExec
implements ClientExecChain {
    private final ClientExecChain requestExecutor;
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ClientExecChain clientExecChain, ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull(clientExecChain, "HTTP client request executor");
        Args.notNull(connectionBackoffStrategy, "Connection backoff strategy");
        Args.notNull(backoffManager, "Backoff manager");
        this.requestExecutor = clientExecChain;
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Args.notNull(httpRoute, "HTTP route");
        Args.notNull(httpRequestWrapper, "HTTP request");
        Args.notNull(httpClientContext, "HTTP context");
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            closeableHttpResponse = this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            if (closeableHttpResponse != null) {
                closeableHttpResponse.close();
            }
            if (this.connectionBackoffStrategy.shouldBackoff(exception2)) {
                this.backoffManager.backOff(httpRoute);
            }
            if (exception2 instanceof RuntimeException) {
                throw (RuntimeException)exception2;
            }
            if (exception2 instanceof HttpException) {
                throw (HttpException)exception2;
            }
            if (exception2 instanceof IOException) {
                throw (IOException)exception2;
            }
            throw new UndeclaredThrowableException(exception2);
        }
        if (this.connectionBackoffStrategy.shouldBackoff(closeableHttpResponse)) {
            this.backoffManager.backOff(httpRoute);
        } else {
            this.backoffManager.probe(httpRoute);
        }
        return closeableHttpResponse;
    }
}

