/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.impl.LocationAware;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.PatternMatch;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.PatternSelector;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PatternFormatter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.PatternParser;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.util.HashMap;
import java.util.Map;

@Plugin(name="LevelPatternSelector", category="Core", elementType="patternSelector", printObject=true)
public class LevelPatternSelector
implements LocationAware,
PatternSelector {
    private final Map<String, PatternFormatter[]> formatterMap = new HashMap<String, PatternFormatter[]>();
    private final Map<String, String> patternMap = new HashMap<String, String>();
    private final PatternFormatter[] defaultFormatters;
    private final String defaultPattern;
    private static Logger LOGGER = StatusLogger.getLogger();
    private final boolean requiresLocation;

    @Deprecated
    public LevelPatternSelector(PatternMatch[] patternMatchArray, String string, boolean bl2, boolean bl3, Configuration configuration) {
        this(patternMatchArray, string, bl2, false, bl3, configuration);
    }

    private LevelPatternSelector(PatternMatch[] patternMatchArray, String string, boolean bl2, boolean bl3, boolean bl4, Configuration configuration) {
        Object object;
        boolean bl5 = false;
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        for (PatternMatch patternMatch : patternMatchArray) {
            Object object2;
            try {
                object2 = patternParser.parse(patternMatch.getPattern(), bl2, bl3, bl4);
                PatternFormatter[] patternFormatterArray = object2.toArray(PatternFormatter.EMPTY_ARRAY);
                this.formatterMap.put(patternMatch.getKey(), patternFormatterArray);
                for (int i2 = 0; !bl5 && i2 < patternFormatterArray.length; ++i2) {
                    bl5 = patternFormatterArray[i2].requiresLocation();
                }
                this.patternMap.put(patternMatch.getKey(), patternMatch.getPattern());
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                object2 = runtimeException;
                throw new IllegalArgumentException("Cannot parse pattern '" + patternMatch.getPattern() + "'", (Throwable)object2);
            }
        }
        try {
            object = patternParser.parse(string, bl2, bl3, bl4);
            this.defaultFormatters = object.toArray(PatternFormatter.EMPTY_ARRAY);
            this.defaultPattern = string;
            for (int i3 = 0; !bl5 && i3 < this.defaultFormatters.length; ++i3) {
                bl5 = this.defaultFormatters[i3].requiresLocation();
            }
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            object = runtimeException;
            throw new IllegalArgumentException("Cannot parse pattern '" + string + "'", (Throwable)object);
        }
        this.requiresLocation = bl5;
    }

    @Override
    public boolean requiresLocation() {
        return this.requiresLocation;
    }

    @Override
    public PatternFormatter[] getFormatters(LogEvent logEvent) {
        Level level = logEvent.getLevel();
        if (level == null) {
            return this.defaultFormatters;
        }
        for (String string : this.formatterMap.keySet()) {
            if (!level.name().equalsIgnoreCase(string)) continue;
            return this.formatterMap.get(string);
        }
        return this.defaultFormatters;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public static LevelPatternSelector createSelector(PatternMatch[] patternMatchArray, String string, boolean bl2, boolean bl3, Configuration configuration) {
        Builder builder = LevelPatternSelector.newBuilder();
        builder.setProperties(patternMatchArray);
        builder.setDefaultPattern(string);
        builder.setAlwaysWriteExceptions(bl2);
        builder.setNoConsoleNoAnsi(bl3);
        builder.setConfiguration(configuration);
        return builder.build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (Map.Entry<String, String> entry : this.patternMap.entrySet()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("key=\"").append(entry.getKey()).append("\", pattern=\"").append(entry.getValue()).append("\"");
            bl2 = false;
        }
        if (!bl2) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("default=\"").append(this.defaultPattern).append("\"");
        return stringBuilder.toString();
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<LevelPatternSelector> {
        @PluginElement(value="PatternMatch")
        private PatternMatch[] properties;
        @PluginBuilderAttribute(value="defaultPattern")
        private String defaultPattern;
        @PluginBuilderAttribute(value="alwaysWriteExceptions")
        private boolean alwaysWriteExceptions = true;
        @PluginBuilderAttribute(value="disableAnsi")
        private boolean disableAnsi;
        @PluginBuilderAttribute(value="noConsoleNoAnsi")
        private boolean noConsoleNoAnsi;
        @PluginConfiguration
        private Configuration configuration;

        @Override
        public LevelPatternSelector build() {
            if (this.defaultPattern == null) {
                this.defaultPattern = "%m%n";
            }
            if (this.properties == null || this.properties.length == 0) {
                LOGGER.warn("No marker patterns were provided with PatternMatch");
                return null;
            }
            return new LevelPatternSelector(this.properties, this.defaultPattern, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi, this.configuration);
        }

        public Builder setProperties(PatternMatch[] patternMatchArray) {
            this.properties = patternMatchArray;
            return this;
        }

        public Builder setDefaultPattern(String string) {
            this.defaultPattern = string;
            return this;
        }

        public Builder setAlwaysWriteExceptions(boolean bl2) {
            this.alwaysWriteExceptions = bl2;
            return this;
        }

        public Builder setDisableAnsi(boolean bl2) {
            this.disableAnsi = bl2;
            return this;
        }

        public Builder setNoConsoleNoAnsi(boolean bl2) {
            this.noConsoleNoAnsi = bl2;
            return this;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }
    }
}

