/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorServices {
    private static final Logger LOGGER = StatusLogger.getLogger();

    public static boolean shutdown(ExecutorService executorService, long l2, TimeUnit timeUnit, String string) {
        if (executorService == null || executorService.isTerminated()) {
            return true;
        }
        executorService.shutdown();
        if (l2 > 0L && timeUnit == null) {
            throw new IllegalArgumentException(String.format("%s can't shutdown %s when timeout = %,d and timeUnit = %s.", new Object[]{string, executorService, l2, timeUnit}));
        }
        if (l2 > 0L) {
            try {
                if (!executorService.awaitTermination(l2, timeUnit)) {
                    executorService.shutdownNow();
                    if (!executorService.awaitTermination(l2, timeUnit)) {
                        LOGGER.error("{} pool {} did not terminate after {} {}", (Object)string, (Object)executorService, (Object)l2, (Object)timeUnit);
                    }
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        } else {
            executorService.shutdown();
        }
        return true;
    }

    public static void ensureInitialized() {
    }
}

