/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.message;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StringBuilders;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class ParameterFormatter {
    static final String RECURSION_PREFIX = "[...";
    static final String RECURSION_SUFFIX = "...]";
    static final String ERROR_PREFIX = "[!!!";
    static final String ERROR_SEPARATOR = "=>";
    static final String ERROR_MSG_SEPARATOR = ":";
    static final String ERROR_SUFFIX = "!!!]";
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_REF = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));

    private ParameterFormatter() {
    }

    static int countArgumentPlaceholders(String string) {
        if (string == null) {
            return 0;
        }
        int n2 = string.length();
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                bl2 = !bl2;
                continue;
            }
            if (c2 == '{') {
                if (!bl2 && string.charAt(i2 + 1) == '}') {
                    ++n3;
                    ++i2;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        return n3;
    }

    static int countArgumentPlaceholders2(String string, int[] nArray) {
        if (string == null) {
            return 0;
        }
        int n2 = string.length();
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                bl2 = !bl2;
                nArray[0] = -1;
                ++n3;
                continue;
            }
            if (c2 == '{') {
                if (!bl2 && string.charAt(i2 + 1) == '}') {
                    nArray[n3] = i2++;
                    ++n3;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        return n3;
    }

    static int countArgumentPlaceholders3(char[] cArray, int n2, int[] nArray) {
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            char c2 = cArray[i2];
            if (c2 == '\\') {
                bl2 = !bl2;
                continue;
            }
            if (c2 == '{') {
                if (!bl2 && cArray[i2 + 1] == '}') {
                    nArray[n3] = i2++;
                    ++n3;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        return n3;
    }

    static String format(String string, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = objectArray == null ? 0 : objectArray.length;
        ParameterFormatter.formatMessage(stringBuilder, string, objectArray, n2);
        return stringBuilder.toString();
    }

    static void formatMessage2(StringBuilder stringBuilder, String string, Object[] objectArray, int n2, int[] nArray) {
        if (string == null || objectArray == null || n2 == 0) {
            stringBuilder.append(string);
            return;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(string, n3, nArray[i2]);
            n3 = nArray[i2] + 2;
            ParameterFormatter.recursiveDeepToString(objectArray[i2], stringBuilder);
        }
        stringBuilder.append(string, n3, string.length());
    }

    static void formatMessage3(StringBuilder stringBuilder, char[] cArray, int n2, Object[] objectArray, int n3, int[] nArray) {
        if (cArray == null) {
            return;
        }
        if (objectArray == null || n3 == 0) {
            stringBuilder.append(cArray);
            return;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(cArray, n4, nArray[i2]);
            n4 = nArray[i2] + 2;
            ParameterFormatter.recursiveDeepToString(objectArray[i2], stringBuilder);
        }
        stringBuilder.append(cArray, n4, n2);
    }

    static void formatMessage(StringBuilder stringBuilder, String string, Object[] objectArray, int n2) {
        int n3;
        if (string == null || objectArray == null || n2 == 0) {
            stringBuilder.append(string);
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        for (n3 = 0; n3 < n6 - 1; ++n3) {
            char c2 = string.charAt(n3);
            if (c2 == '\\') {
                ++n4;
                continue;
            }
            if (ParameterFormatter.isDelimPair(c2, string, n3)) {
                ++n3;
                ParameterFormatter.writeEscapedEscapeChars(n4, stringBuilder);
                if (ParameterFormatter.isOdd(n4)) {
                    ParameterFormatter.writeDelimPair(stringBuilder);
                } else {
                    ParameterFormatter.writeArgOrDelimPair(objectArray, n2, n5, stringBuilder);
                    ++n5;
                }
            } else {
                ParameterFormatter.handleLiteralChar(stringBuilder, n4, c2);
            }
            n4 = 0;
        }
        ParameterFormatter.handleRemainingCharIfAny(string, n6, stringBuilder, n4, n3);
    }

    private static boolean isDelimPair(char c2, String string, int n2) {
        return c2 == '{' && string.charAt(n2 + 1) == '}';
    }

    private static void handleRemainingCharIfAny(String string, int n2, StringBuilder stringBuilder, int n3, int n4) {
        if (n4 == n2 - 1) {
            char c2 = string.charAt(n4);
            ParameterFormatter.handleLastChar(stringBuilder, n3, c2);
        }
    }

    private static void handleLastChar(StringBuilder stringBuilder, int n2, char c2) {
        if (c2 == '\\') {
            ParameterFormatter.writeUnescapedEscapeChars(n2 + 1, stringBuilder);
        } else {
            ParameterFormatter.handleLiteralChar(stringBuilder, n2, c2);
        }
    }

    private static void handleLiteralChar(StringBuilder stringBuilder, int n2, char c2) {
        ParameterFormatter.writeUnescapedEscapeChars(n2, stringBuilder);
        stringBuilder.append(c2);
    }

    private static void writeDelimPair(StringBuilder stringBuilder) {
        stringBuilder.append('{');
        stringBuilder.append('}');
    }

    private static boolean isOdd(int n2) {
        return (n2 & 1) == 1;
    }

    private static void writeEscapedEscapeChars(int n2, StringBuilder stringBuilder) {
        int n3 = n2 >> 1;
        ParameterFormatter.writeUnescapedEscapeChars(n3, stringBuilder);
    }

    private static void writeUnescapedEscapeChars(int n2, StringBuilder stringBuilder) {
        while (n2 > 0) {
            stringBuilder.append('\\');
            --n2;
        }
    }

    private static void writeArgOrDelimPair(Object[] objectArray, int n2, int n3, StringBuilder stringBuilder) {
        if (n3 < n2) {
            ParameterFormatter.recursiveDeepToString(objectArray[n3], stringBuilder);
        } else {
            ParameterFormatter.writeDelimPair(stringBuilder);
        }
    }

    static String deepToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Integer) {
            return Integer.toString((Integer)object);
        }
        if (object instanceof Long) {
            return Long.toString((Long)object);
        }
        if (object instanceof Double) {
            return Double.toString((Double)object);
        }
        if (object instanceof Boolean) {
            return Boolean.toString((Boolean)object);
        }
        if (object instanceof Character) {
            return Character.toString(((Character)object).charValue());
        }
        if (object instanceof Short) {
            return Short.toString((Short)object);
        }
        if (object instanceof Float) {
            return Float.toString(((Float)object).floatValue());
        }
        if (object instanceof Byte) {
            return Byte.toString((Byte)object);
        }
        StringBuilder stringBuilder = new StringBuilder();
        ParameterFormatter.recursiveDeepToString(object, stringBuilder);
        return stringBuilder.toString();
    }

    static void recursiveDeepToString(Object object, StringBuilder stringBuilder) {
        ParameterFormatter.recursiveDeepToString(object, stringBuilder, null);
    }

    private static void recursiveDeepToString(Object object, StringBuilder stringBuilder, Set<Object> set) {
        if (ParameterFormatter.appendSpecialTypes(object, stringBuilder)) {
            return;
        }
        if (ParameterFormatter.isMaybeRecursive(object)) {
            ParameterFormatter.appendPotentiallyRecursiveValue(object, stringBuilder, set);
        } else {
            ParameterFormatter.tryObjectToString(object, stringBuilder);
        }
    }

    private static boolean appendSpecialTypes(Object object, StringBuilder stringBuilder) {
        return StringBuilders.appendSpecificTypes(stringBuilder, object) || ParameterFormatter.appendDate(object, stringBuilder);
    }

    private static boolean appendDate(Object object, StringBuilder stringBuilder) {
        if (!(object instanceof Date)) {
            return false;
        }
        Date date = (Date)object;
        SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMAT_REF.get();
        stringBuilder.append(simpleDateFormat.format(date));
        return true;
    }

    private static boolean isMaybeRecursive(Object object) {
        return object.getClass().isArray() || object instanceof Map || object instanceof Collection;
    }

    private static void appendPotentiallyRecursiveValue(Object object, StringBuilder stringBuilder, Set<Object> set) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            ParameterFormatter.appendArray(object, stringBuilder, set, clazz);
        } else if (object instanceof Map) {
            ParameterFormatter.appendMap(object, stringBuilder, set);
        } else if (object instanceof Collection) {
            ParameterFormatter.appendCollection(object, stringBuilder, set);
        } else {
            throw new IllegalArgumentException("was expecting a container, found " + clazz);
        }
    }

    private static void appendArray(Object object, StringBuilder stringBuilder, Set<Object> set, Class<?> clazz) {
        if (clazz == byte[].class) {
            stringBuilder.append(Arrays.toString((byte[])object));
        } else if (clazz == short[].class) {
            stringBuilder.append(Arrays.toString((short[])object));
        } else if (clazz == int[].class) {
            stringBuilder.append(Arrays.toString((int[])object));
        } else if (clazz == long[].class) {
            stringBuilder.append(Arrays.toString((long[])object));
        } else if (clazz == float[].class) {
            stringBuilder.append(Arrays.toString((float[])object));
        } else if (clazz == double[].class) {
            stringBuilder.append(Arrays.toString((double[])object));
        } else if (clazz == boolean[].class) {
            stringBuilder.append(Arrays.toString((boolean[])object));
        } else if (clazz == char[].class) {
            stringBuilder.append(Arrays.toString((char[])object));
        } else {
            boolean bl2;
            Set<Object> set2 = ParameterFormatter.getOrCreateDejaVu(set);
            boolean bl3 = bl2 = !set2.add(object);
            if (bl2) {
                String string = ParameterFormatter.identityToString(object);
                stringBuilder.append(RECURSION_PREFIX).append(string).append(RECURSION_SUFFIX);
            } else {
                Object[] objectArray = (Object[])object;
                stringBuilder.append('[');
                boolean bl4 = true;
                for (Object object2 : objectArray) {
                    if (bl4) {
                        bl4 = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    ParameterFormatter.recursiveDeepToString(object2, stringBuilder, ParameterFormatter.cloneDejaVu(set2));
                }
                stringBuilder.append(']');
            }
        }
    }

    private static void appendMap(Object object, StringBuilder stringBuilder, Set<Object> set) {
        boolean bl2;
        Set<Object> set2 = ParameterFormatter.getOrCreateDejaVu(set);
        boolean bl3 = bl2 = !set2.add(object);
        if (bl2) {
            String string = ParameterFormatter.identityToString(object);
            stringBuilder.append(RECURSION_PREFIX).append(string).append(RECURSION_SUFFIX);
        } else {
            Map map = (Map)object;
            stringBuilder.append('{');
            boolean bl4 = true;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                if (bl4) {
                    bl4 = false;
                } else {
                    stringBuilder.append(", ");
                }
                Object k2 = entry2.getKey();
                Object v2 = entry2.getValue();
                ParameterFormatter.recursiveDeepToString(k2, stringBuilder, ParameterFormatter.cloneDejaVu(set2));
                stringBuilder.append('=');
                ParameterFormatter.recursiveDeepToString(v2, stringBuilder, ParameterFormatter.cloneDejaVu(set2));
            }
            stringBuilder.append('}');
        }
    }

    private static void appendCollection(Object object, StringBuilder stringBuilder, Set<Object> set) {
        boolean bl2;
        Set<Object> set2 = ParameterFormatter.getOrCreateDejaVu(set);
        boolean bl3 = bl2 = !set2.add(object);
        if (bl2) {
            String string = ParameterFormatter.identityToString(object);
            stringBuilder.append(RECURSION_PREFIX).append(string).append(RECURSION_SUFFIX);
        } else {
            Collection collection = (Collection)object;
            stringBuilder.append('[');
            boolean bl4 = true;
            for (Object e2 : collection) {
                if (bl4) {
                    bl4 = false;
                } else {
                    stringBuilder.append(", ");
                }
                ParameterFormatter.recursiveDeepToString(e2, stringBuilder, ParameterFormatter.cloneDejaVu(set2));
            }
            stringBuilder.append(']');
        }
    }

    private static Set<Object> getOrCreateDejaVu(Set<Object> set) {
        return set == null ? ParameterFormatter.createDejaVu() : set;
    }

    private static Set<Object> createDejaVu() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    private static Set<Object> cloneDejaVu(Set<Object> set) {
        Set<Object> set2 = ParameterFormatter.createDejaVu();
        set2.addAll(set);
        return set2;
    }

    private static void tryObjectToString(Object object, StringBuilder stringBuilder) {
        try {
            stringBuilder.append(object.toString());
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            ParameterFormatter.handleErrorInObjectToString(object, stringBuilder, throwable2);
        }
    }

    private static void handleErrorInObjectToString(Object object, StringBuilder stringBuilder, Throwable throwable) {
        stringBuilder.append(ERROR_PREFIX);
        stringBuilder.append(ParameterFormatter.identityToString(object));
        stringBuilder.append(ERROR_SEPARATOR);
        String string = throwable.getMessage();
        String string2 = throwable.getClass().getName();
        stringBuilder.append(string2);
        if (!string2.equals(string)) {
            stringBuilder.append(ERROR_MSG_SEPARATOR);
            stringBuilder.append(string);
        }
        stringBuilder.append(ERROR_SUFFIX);
    }

    static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }
}

