/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.util;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StringBuilderFormattable;
import java.io.Serializable;
import java.text.DecimalFormat;

public class Timer
implements StringBuilderFormattable,
Serializable {
    private static final long serialVersionUID = 9175191792439630013L;
    private final String name;
    private Status status;
    private long elapsedTime;
    private final int iterations;
    private static long NANO_PER_SECOND = 1000000000L;
    private static long NANO_PER_MINUTE = NANO_PER_SECOND * 60L;
    private static long NANO_PER_HOUR = NANO_PER_MINUTE * 60L;
    private ThreadLocal<Long> startTime = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 0L;
        }
    };

    public Timer(String string) {
        this(string, 0);
    }

    public Timer(String string, int n2) {
        this.name = string;
        this.status = Status.Stopped;
        this.iterations = n2 > 0 ? n2 : 0;
    }

    public synchronized void start() {
        this.startTime.set(System.nanoTime());
        this.elapsedTime = 0L;
        this.status = Status.Started;
    }

    public synchronized void startOrResume() {
        if (this.status == Status.Stopped) {
            this.start();
        } else {
            this.resume();
        }
    }

    public synchronized String stop() {
        this.elapsedTime += System.nanoTime() - this.startTime.get();
        this.startTime.set(0L);
        this.status = Status.Stopped;
        return this.toString();
    }

    public synchronized void pause() {
        this.elapsedTime += System.nanoTime() - this.startTime.get();
        this.startTime.set(0L);
        this.status = Status.Paused;
    }

    public synchronized void resume() {
        this.startTime.set(System.nanoTime());
        this.status = Status.Started;
    }

    public String getName() {
        return this.name;
    }

    public long getElapsedTime() {
        return this.elapsedTime / 1000000L;
    }

    public long getElapsedNanoTime() {
        return this.elapsedTime;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.formatTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        stringBuilder.append("Timer ").append(this.name);
        switch (this.status) {
            case Started: {
                stringBuilder.append(" started");
                break;
            }
            case Paused: {
                stringBuilder.append(" paused");
                break;
            }
            case Stopped: {
                long l2 = this.elapsedTime;
                long l3 = l2 / NANO_PER_HOUR;
                long l4 = (l2 %= NANO_PER_HOUR) / NANO_PER_MINUTE;
                long l5 = (l2 %= NANO_PER_MINUTE) / NANO_PER_SECOND;
                l2 %= NANO_PER_SECOND;
                String string = "";
                if (l3 > 0L) {
                    string = string + l3 + " hours ";
                }
                if (l4 > 0L || l3 > 0L) {
                    string = string + l4 + " minutes ";
                }
                DecimalFormat decimalFormat = new DecimalFormat("#0");
                string = string + decimalFormat.format(l5) + '.';
                decimalFormat = new DecimalFormat("000000000");
                string = string + decimalFormat.format(l2) + " seconds";
                stringBuilder.append(" stopped. Elapsed time: ").append(string);
                if (this.iterations <= 0) break;
                l2 = this.elapsedTime / (long)this.iterations;
                l3 = l2 / NANO_PER_HOUR;
                l4 = (l2 %= NANO_PER_HOUR) / NANO_PER_MINUTE;
                l5 = (l2 %= NANO_PER_MINUTE) / NANO_PER_SECOND;
                l2 %= NANO_PER_SECOND;
                string = "";
                if (l3 > 0L) {
                    string = string + l3 + " hours ";
                }
                if (l4 > 0L || l3 > 0L) {
                    string = string + l4 + " minutes ";
                }
                decimalFormat = new DecimalFormat("#0");
                string = string + decimalFormat.format(l5) + '.';
                decimalFormat = new DecimalFormat("000000000");
                string = string + decimalFormat.format(l2) + " seconds";
                stringBuilder.append(" Average per iteration: ").append(string);
                break;
            }
            default: {
                stringBuilder.append(' ').append((Object)this.status);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Timer)) {
            return false;
        }
        Timer timer = (Timer)object;
        if (this.elapsedTime != timer.elapsedTime) {
            return false;
        }
        if (this.startTime != timer.startTime) {
            return false;
        }
        if (this.name != null ? !this.name.equals(timer.name) : timer.name != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals((Object)timer.status) : timer.status != null);
    }

    public int hashCode() {
        int n2 = this.name != null ? this.name.hashCode() : 0;
        n2 = 29 * n2 + (this.status != null ? this.status.hashCode() : 0);
        long l2 = this.startTime.get();
        n2 = 29 * n2 + (int)(l2 ^ l2 >>> 32);
        n2 = 29 * n2 + (int)(this.elapsedTime ^ this.elapsedTime >>> 32);
        return n2;
    }

    public static enum Status {
        Started,
        Stopped,
        Paused;

    }
}

