/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.asm.commons;

import com.contrastsecurity.thirdparty.omv2.asm.Label;
import com.contrastsecurity.thirdparty.omv2.asm.MethodVisitor;
import com.contrastsecurity.thirdparty.omv2.asm.Opcodes;
import com.contrastsecurity.thirdparty.omv2.asm.tree.AbstractInsnNode;
import com.contrastsecurity.thirdparty.omv2.asm.tree.InsnList;
import com.contrastsecurity.thirdparty.omv2.asm.tree.InsnNode;
import com.contrastsecurity.thirdparty.omv2.asm.tree.JumpInsnNode;
import com.contrastsecurity.thirdparty.omv2.asm.tree.LabelNode;
import com.contrastsecurity.thirdparty.omv2.asm.tree.LocalVariableNode;
import com.contrastsecurity.thirdparty.omv2.asm.tree.LookupSwitchInsnNode;
import com.contrastsecurity.thirdparty.omv2.asm.tree.MethodNode;
import com.contrastsecurity.thirdparty.omv2.asm.tree.TableSwitchInsnNode;
import com.contrastsecurity.thirdparty.omv2.asm.tree.TryCatchBlockNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSRInlinerAdapter
extends MethodNode
implements Opcodes {
    private static final boolean LOGGING = false;
    private final Map<LabelNode, BitSet> subroutineHeads = new HashMap<LabelNode, BitSet>();
    private final BitSet mainSubroutine = new BitSet();
    final BitSet dualCitizens = new BitSet();

    public JSRInlinerAdapter(MethodVisitor methodVisitor, int n2, String string, String string2, String string3, String[] stringArray) {
        this(327680, methodVisitor, n2, string, string2, string3, stringArray);
        if (this.getClass() != JSRInlinerAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected JSRInlinerAdapter(int n2, MethodVisitor methodVisitor, int n3, String string, String string2, String string3, String[] stringArray) {
        super(n2, n3, string, string2, string3, stringArray);
        this.mv = methodVisitor;
    }

    @Override
    public void visitJumpInsn(int n2, Label label) {
        super.visitJumpInsn(n2, label);
        LabelNode labelNode = ((JumpInsnNode)this.instructions.getLast()).label;
        if (n2 == 168 && !this.subroutineHeads.containsKey(labelNode)) {
            this.subroutineHeads.put(labelNode, new BitSet());
        }
    }

    @Override
    public void visitEnd() {
        if (!this.subroutineHeads.isEmpty()) {
            this.markSubroutines();
            this.emitCode();
        }
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }

    private void markSubroutines() {
        BitSet bitSet = new BitSet();
        this.markSubroutineWalk(this.mainSubroutine, 0, bitSet);
        for (Map.Entry<LabelNode, BitSet> entry : this.subroutineHeads.entrySet()) {
            LabelNode labelNode = entry.getKey();
            BitSet bitSet2 = entry.getValue();
            int n2 = this.instructions.indexOf(labelNode);
            this.markSubroutineWalk(bitSet2, n2, bitSet);
        }
    }

    private void markSubroutineWalk(BitSet bitSet, int n2, BitSet bitSet2) {
        this.markSubroutineWalkDFS(bitSet, n2, bitSet2);
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            for (TryCatchBlockNode tryCatchBlockNode : this.tryCatchBlocks) {
                int n3 = this.instructions.indexOf(tryCatchBlockNode.handler);
                if (bitSet.get(n3)) continue;
                int n4 = this.instructions.indexOf(tryCatchBlockNode.start);
                int n5 = this.instructions.indexOf(tryCatchBlockNode.end);
                int n6 = bitSet.nextSetBit(n4);
                if (n6 == -1 || n6 >= n5) continue;
                this.markSubroutineWalkDFS(bitSet, n3, bitSet2);
                bl2 = true;
            }
        }
    }

    private void markSubroutineWalkDFS(BitSet bitSet, int n2, BitSet bitSet2) {
        do {
            LabelNode labelNode;
            int n3;
            int n4;
            AbstractInsnNode abstractInsnNode;
            AbstractInsnNode abstractInsnNode2 = this.instructions.get(n2);
            if (bitSet.get(n2)) {
                return;
            }
            bitSet.set(n2);
            if (bitSet2.get(n2)) {
                this.dualCitizens.set(n2);
            }
            bitSet2.set(n2);
            if (abstractInsnNode2.getType() == 7 && abstractInsnNode2.getOpcode() != 168) {
                abstractInsnNode = (JumpInsnNode)abstractInsnNode2;
                n4 = this.instructions.indexOf(abstractInsnNode.label);
                this.markSubroutineWalkDFS(bitSet, n4, bitSet2);
            }
            if (abstractInsnNode2.getType() == 11) {
                abstractInsnNode = (TableSwitchInsnNode)abstractInsnNode2;
                n4 = this.instructions.indexOf(((TableSwitchInsnNode)abstractInsnNode).dflt);
                this.markSubroutineWalkDFS(bitSet, n4, bitSet2);
                for (n3 = ((TableSwitchInsnNode)abstractInsnNode).labels.size() - 1; n3 >= 0; --n3) {
                    labelNode = ((TableSwitchInsnNode)abstractInsnNode).labels.get(n3);
                    n4 = this.instructions.indexOf(labelNode);
                    this.markSubroutineWalkDFS(bitSet, n4, bitSet2);
                }
            }
            if (abstractInsnNode2.getType() == 12) {
                abstractInsnNode = (LookupSwitchInsnNode)abstractInsnNode2;
                n4 = this.instructions.indexOf(((LookupSwitchInsnNode)abstractInsnNode).dflt);
                this.markSubroutineWalkDFS(bitSet, n4, bitSet2);
                for (n3 = ((LookupSwitchInsnNode)abstractInsnNode).labels.size() - 1; n3 >= 0; --n3) {
                    labelNode = ((LookupSwitchInsnNode)abstractInsnNode).labels.get(n3);
                    n4 = this.instructions.indexOf(labelNode);
                    this.markSubroutineWalkDFS(bitSet, n4, bitSet2);
                }
            }
            switch (this.instructions.get(n2).getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
        } while (++n2 < this.instructions.size());
    }

    private void emitCode() {
        LinkedList<Instantiation> linkedList = new LinkedList<Instantiation>();
        linkedList.add(new Instantiation(null, this.mainSubroutine));
        InsnList insnList = new InsnList();
        ArrayList<TryCatchBlockNode> arrayList = new ArrayList<TryCatchBlockNode>();
        ArrayList<LocalVariableNode> arrayList2 = new ArrayList<LocalVariableNode>();
        while (!linkedList.isEmpty()) {
            Instantiation instantiation = (Instantiation)linkedList.removeFirst();
            this.emitSubroutine(instantiation, linkedList, insnList, arrayList, arrayList2);
        }
        this.instructions = insnList;
        this.tryCatchBlocks = arrayList;
        this.localVariables = arrayList2;
    }

    private void emitSubroutine(Instantiation instantiation, List<Instantiation> list, InsnList insnList, List<TryCatchBlockNode> list2, List<LocalVariableNode> list3) {
        LabelNode labelNode;
        Object object;
        AbstractInsnNode abstractInsnNode;
        Object object2 = null;
        int n2 = this.instructions.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object3;
            abstractInsnNode = this.instructions.get(i2);
            object = instantiation.findOwner(i2);
            if (abstractInsnNode.getType() == 8) {
                labelNode = (LabelNode)abstractInsnNode;
                object3 = instantiation.rangeLabel(labelNode);
                if (object3 == object2) continue;
                insnList.add((AbstractInsnNode)object3);
                object2 = object3;
                continue;
            }
            if (object != instantiation) continue;
            if (abstractInsnNode.getOpcode() == 169) {
                labelNode = null;
                object3 = instantiation;
                while (object3 != null) {
                    if (((Instantiation)object3).subroutine.get(i2)) {
                        labelNode = ((Instantiation)object3).returnLabel;
                    }
                    object3 = ((Instantiation)object3).previous;
                }
                if (labelNode == null) {
                    throw new RuntimeException("Instruction #" + i2 + " is a RET not owned by any subroutine");
                }
                insnList.add(new JumpInsnNode(167, labelNode));
                continue;
            }
            if (abstractInsnNode.getOpcode() == 168) {
                labelNode = ((JumpInsnNode)abstractInsnNode).label;
                object3 = this.subroutineHeads.get(labelNode);
                Instantiation instantiation2 = new Instantiation(instantiation, (BitSet)object3);
                LabelNode labelNode2 = instantiation2.gotoLabel(labelNode);
                insnList.add(new InsnNode(1));
                insnList.add(new JumpInsnNode(167, labelNode2));
                insnList.add(instantiation2.returnLabel);
                list.add(instantiation2);
                continue;
            }
            insnList.add(abstractInsnNode.clone(instantiation));
        }
        for (TryCatchBlockNode tryCatchBlockNode : this.tryCatchBlocks) {
            abstractInsnNode = instantiation.rangeLabel(tryCatchBlockNode.start);
            if (abstractInsnNode == (object = instantiation.rangeLabel(tryCatchBlockNode.end))) continue;
            labelNode = instantiation.gotoLabel(tryCatchBlockNode.handler);
            if (abstractInsnNode == null || object == null || labelNode == null) {
                throw new RuntimeException("Internal error!");
            }
            list2.add(new TryCatchBlockNode((LabelNode)abstractInsnNode, (LabelNode)object, labelNode, tryCatchBlockNode.type));
        }
        for (LocalVariableNode localVariableNode : this.localVariables) {
            abstractInsnNode = instantiation.rangeLabel(localVariableNode.start);
            if (abstractInsnNode == (object = instantiation.rangeLabel(localVariableNode.end))) continue;
            list3.add(new LocalVariableNode(localVariableNode.name, localVariableNode.desc, localVariableNode.signature, (LabelNode)abstractInsnNode, (LabelNode)object, localVariableNode.index));
        }
    }

    private static void log(String string) {
        System.err.println(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Instantiation
    extends AbstractMap<LabelNode, LabelNode> {
        final Instantiation previous;
        public final BitSet subroutine;
        public final Map<LabelNode, LabelNode> rangeTable = new HashMap<LabelNode, LabelNode>();
        public final LabelNode returnLabel;

        Instantiation(Instantiation instantiation, BitSet bitSet) {
            this.previous = instantiation;
            this.subroutine = bitSet;
            Object object = instantiation;
            while (object != null) {
                if (((Instantiation)object).subroutine == bitSet) {
                    throw new RuntimeException("Recursive invocation of " + bitSet);
                }
                object = ((Instantiation)object).previous;
            }
            this.returnLabel = instantiation != null ? new LabelNode() : null;
            object = null;
            int n2 = JSRInlinerAdapter.this.instructions.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                AbstractInsnNode abstractInsnNode = JSRInlinerAdapter.this.instructions.get(i2);
                if (abstractInsnNode.getType() == 8) {
                    LabelNode labelNode = (LabelNode)abstractInsnNode;
                    if (object == null) {
                        object = new LabelNode();
                    }
                    this.rangeTable.put(labelNode, (LabelNode)object);
                    continue;
                }
                if (this.findOwner(i2) != this) continue;
                object = null;
            }
        }

        public Instantiation findOwner(int n2) {
            if (!this.subroutine.get(n2)) {
                return null;
            }
            if (!JSRInlinerAdapter.this.dualCitizens.get(n2)) {
                return this;
            }
            Instantiation instantiation = this;
            Instantiation instantiation2 = this.previous;
            while (instantiation2 != null) {
                if (instantiation2.subroutine.get(n2)) {
                    instantiation = instantiation2;
                }
                instantiation2 = instantiation2.previous;
            }
            return instantiation;
        }

        public LabelNode gotoLabel(LabelNode labelNode) {
            Instantiation instantiation = this.findOwner(JSRInlinerAdapter.this.instructions.indexOf(labelNode));
            return instantiation.rangeTable.get(labelNode);
        }

        public LabelNode rangeLabel(LabelNode labelNode) {
            return this.rangeTable.get(labelNode);
        }

        @Override
        public Set<Map.Entry<LabelNode, LabelNode>> entrySet() {
            return null;
        }

        @Override
        public LabelNode get(Object object) {
            return this.gotoLabel((LabelNode)object);
        }
    }
}

