/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.conversion;

import com.contrastsecurity.thirdparty.omv2.ConversionException;
import com.contrastsecurity.thirdparty.omv2.ConversionHandler;
import com.contrastsecurity.thirdparty.omv2.conversion.Converter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class CharCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static final Converter stringConverter = new Converter(){

        public Object convert(Object object) {
            if (((String)object).length() > 1) {
                throw new ConversionException("cannot convert a string with a length greater than 1 to java.lang.Character");
            }
            return Character.valueOf(((String)object).charAt(0));
        }
    };

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object object) {
                return stringConverter.convert(String.valueOf(object));
            }
        });
        CNV.put(Character.class, new Converter(){

            public Object convert(Object object) {
                return new Character(((Character)object).charValue());
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Object convert(Object object) {
                return Character.valueOf((char)((BigDecimal)object).intValue());
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Object convert(Object object) {
                return Character.valueOf((char)((Integer)object).intValue());
            }
        });
    }
}

