/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.conversion;

import com.contrastsecurity.thirdparty.omv2.ConversionException;
import com.contrastsecurity.thirdparty.omv2.ConversionHandler;
import com.contrastsecurity.thirdparty.omv2.conversion.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class DoubleCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static Converter stringConverter = new Converter(){

        public Object convert(Object object) {
            if (((String)object).length() == 0) {
                return 0.0;
            }
            return Double.parseDouble((String)object);
        }
    };

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object object) {
                return stringConverter.convert(String.valueOf(object));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Double convert(Object object) {
                return ((BigDecimal)object).doubleValue();
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public Double convert(Object object) {
                return ((BigInteger)object).doubleValue();
            }
        });
        CNV.put(Double.class, new Converter(){

            public Object convert(Object object) {
                return object;
            }
        });
        CNV.put(Float.class, new Converter(){

            public Double convert(Object object) {
                if ((double)((Float)object).floatValue() > Double.MAX_VALUE) {
                    throw new ConversionException("cannot coerce Float to Double since the value (" + String.valueOf(object) + ") exceeds that maximum precision of Double.");
                }
                return ((Float)object).doubleValue();
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Double convert(Object object) {
                return ((Integer)object).doubleValue();
            }
        });
        CNV.put(Short.class, new Converter(){

            public Double convert(Object object) {
                return ((Short)object).doubleValue();
            }
        });
        CNV.put(Long.class, new Converter(){

            public Double convert(Object object) {
                return ((Long)object).doubleValue();
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Double convert(Object object) {
                if (((Boolean)object).booleanValue()) {
                    return 1.0;
                }
                return 0.0;
            }
        });
    }
}

