/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.optimizers.impl.refl.nodes;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.omv2.DataConversion;
import com.contrastsecurity.thirdparty.omv2.compiler.AccessorNode;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.util.PropertyTools;
import java.lang.reflect.Field;

public class FieldAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private Field field;
    private boolean coercionRequired = false;
    private boolean primitive;

    public FieldAccessor() {
    }

    public FieldAccessor(Field field) {
        this.field = field;
        this.primitive = this.field.getType().isPrimitive();
    }

    public Object getValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.field.get(object), object2, variableResolverFactory);
            }
            return this.field.get(object);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new RuntimeException("unable to access field: " + this.field.getName(), exception2);
        }
    }

    public Object setValue(Object object, Object object2, VariableResolverFactory variableResolverFactory, Object object3) {
        if (this.nextNode != null) {
            try {
                return this.nextNode.setValue(this.field.get(object), object2, variableResolverFactory, object3 == null && this.primitive ? PropertyTools.getPrimitiveInitialValue(this.field.getType()) : object3);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                throw new RuntimeException("unable to access field", exception2);
            }
        }
        try {
            if (this.coercionRequired) {
                object3 = DataConversion.convert(object, this.field.getClass());
                this.field.set(object, object3);
                return object3;
            }
            this.field.set(object, object3);
            return object3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!this.coercionRequired) {
                this.coercionRequired = true;
                return this.setValue(object, object2, variableResolverFactory, object3);
            }
            throw new RuntimeException("unable to bind property", illegalArgumentException);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception3 = exception;
            throw new RuntimeException("unable to access field", exception3);
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode accessorNode) {
        this.nextNode = accessorNode;
        return this.nextNode;
    }

    public Class getKnownEgressType() {
        return this.field.getClass();
    }
}

