/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.util;

import com.contrastsecurity.thirdparty.omv2.Operator;
import com.contrastsecurity.thirdparty.omv2.ast.ASTNode;
import com.contrastsecurity.thirdparty.omv2.ast.EndOfStatement;
import com.contrastsecurity.thirdparty.omv2.ast.OperatorNode;
import com.contrastsecurity.thirdparty.omv2.util.ASTIterator;
import com.contrastsecurity.thirdparty.omv2.util.ASTLinkedList;
import com.contrastsecurity.thirdparty.omv2.util.CompatibilityStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTBinaryTree {
    private ASTNode root;
    private ASTBinaryTree left;
    private ASTBinaryTree right;

    public ASTBinaryTree(ASTNode aSTNode) {
        this.root = aSTNode;
    }

    public ASTBinaryTree append(ASTNode aSTNode) {
        if (this.comparePrecedence(this.root, aSTNode) >= 0) {
            ASTBinaryTree aSTBinaryTree = new ASTBinaryTree(aSTNode);
            aSTBinaryTree.left = this;
            return aSTBinaryTree;
        }
        if (this.left == null) {
            throw new RuntimeException("Missing left node");
        }
        this.right = this.right == null ? new ASTBinaryTree(aSTNode) : this.right.append(aSTNode);
        return this;
    }

    public Class<?> getReturnType(boolean bl2) {
        if (!(this.root instanceof OperatorNode)) {
            return this.root.getEgressType();
        }
        if (this.left == null || this.right == null) {
            throw new RuntimeException("Malformed expression");
        }
        Class<?> clazz = this.left.getReturnType(bl2);
        Class<?> clazz2 = this.right.getReturnType(bl2);
        switch (((OperatorNode)this.root).getOperator()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return Boolean.class;
            }
            case 0: {
                if (clazz.equals(String.class) || clazz2.equals(String.class)) {
                    return String.class;
                }
            }
            case 1: 
            case 2: 
            case 3: {
                if (bl2 && !CompatibilityStrategy.areEqualityCompatible(clazz, clazz2)) {
                    throw new RuntimeException("Associative operation requires compatible types. Found " + clazz + " and " + clazz2);
                }
                return Double.class;
            }
            case 30: {
                if (bl2 && !CompatibilityStrategy.areEqualityCompatible(clazz, clazz2)) {
                    throw new RuntimeException("Associative operation requires compatible types. Found " + clazz + " and " + clazz2);
                }
                return clazz;
            }
            case 18: 
            case 19: {
                if (bl2 && !CompatibilityStrategy.areEqualityCompatible(clazz, clazz2)) {
                    throw new RuntimeException("Comparison operation requires compatible types. Found " + clazz + " and " + clazz2);
                }
                return Boolean.class;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                if (bl2 && !CompatibilityStrategy.areComparisonCompatible(clazz, clazz2)) {
                    throw new RuntimeException("Comparison operation requires compatible types. Found " + clazz + " and " + clazz2);
                }
                return Boolean.class;
            }
            case 21: 
            case 22: {
                if (bl2) {
                    if (clazz != Boolean.class && clazz != Boolean.TYPE) {
                        throw new RuntimeException("Left side of logical operation is not of type boolean. Found " + clazz);
                    }
                    if (clazz2 != Boolean.class && clazz2 != Boolean.TYPE) {
                        throw new RuntimeException("Right side of logical operation is not of type boolean. Found " + clazz2);
                    }
                }
                return Boolean.class;
            }
            case 29: {
                if (bl2 && clazz != Boolean.class && clazz != Boolean.TYPE) {
                    throw new RuntimeException("Condition of ternary operator is not of type boolean. Found " + clazz);
                }
                return clazz2;
            }
        }
        return this.root.getEgressType();
    }

    private int comparePrecedence(ASTNode aSTNode, ASTNode aSTNode2) {
        if (!(aSTNode instanceof OperatorNode) && !(aSTNode2 instanceof OperatorNode)) {
            return 0;
        }
        if (aSTNode instanceof OperatorNode && aSTNode2 instanceof OperatorNode) {
            return Operator.PTABLE[((OperatorNode)aSTNode).getOperator()] - Operator.PTABLE[((OperatorNode)aSTNode2).getOperator()];
        }
        return aSTNode instanceof OperatorNode ? -1 : 1;
    }

    public static ASTBinaryTree buildTree(ASTIterator aSTIterator) {
        ASTLinkedList aSTLinkedList = new ASTLinkedList(aSTIterator.firstNode());
        ASTBinaryTree aSTBinaryTree = new ASTBinaryTree(aSTLinkedList.nextNode());
        while (aSTLinkedList.hasMoreNodes()) {
            ASTNode aSTNode = aSTLinkedList.nextNode();
            if (aSTNode instanceof EndOfStatement) {
                if (!aSTLinkedList.hasMoreNodes()) continue;
                aSTBinaryTree = new ASTBinaryTree(aSTLinkedList.nextNode());
                continue;
            }
            aSTBinaryTree = aSTBinaryTree.append(aSTNode);
        }
        return aSTBinaryTree;
    }
}

