/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oobjw.asm.util;

import com.contrastsecurity.thirdparty.oobjw.asm.AnnotationVisitor;
import com.contrastsecurity.thirdparty.oobjw.asm.Attribute;
import com.contrastsecurity.thirdparty.oobjw.asm.ClassWriter;
import com.contrastsecurity.thirdparty.oobjw.asm.ConstantDynamic;
import com.contrastsecurity.thirdparty.oobjw.asm.Handle;
import com.contrastsecurity.thirdparty.oobjw.asm.Label;
import com.contrastsecurity.thirdparty.oobjw.asm.MethodVisitor;
import com.contrastsecurity.thirdparty.oobjw.asm.Opcodes;
import com.contrastsecurity.thirdparty.oobjw.asm.Type;
import com.contrastsecurity.thirdparty.oobjw.asm.TypePath;
import com.contrastsecurity.thirdparty.oobjw.asm.TypeReference;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.MethodNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.Analyzer;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.AnalyzerException;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.BasicValue;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.analysis.BasicVerifier;
import com.contrastsecurity.thirdparty.oobjw.asm.util.CheckAnnotationAdapter;
import com.contrastsecurity.thirdparty.oobjw.asm.util.CheckClassAdapter;
import com.contrastsecurity.thirdparty.oobjw.asm.util.CheckFrameAnalyzer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMethodAdapter
extends MethodVisitor {
    private static final Method[] OPCODE_METHODS = new Method[]{Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INT_INSN, Method.VISIT_INT_INSN, null, null, null, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, Method.VISIT_VAR_INSN, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN, Method.VISIT_VAR_INSN, null, null, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_FIELD_INSN, Method.VISIT_METHOD_INSN, Method.VISIT_METHOD_INSN, Method.VISIT_METHOD_INSN, Method.VISIT_METHOD_INSN, null, Method.VISIT_TYPE_INSN, Method.VISIT_INT_INSN, Method.VISIT_TYPE_INSN, Method.VISIT_INSN, Method.VISIT_INSN, Method.VISIT_TYPE_INSN, Method.VISIT_TYPE_INSN, Method.VISIT_INSN, Method.VISIT_INSN, null, null, Method.VISIT_JUMP_INSN, Method.VISIT_JUMP_INSN};
    private static final String INVALID = "Invalid ";
    private static final String INVALID_DESCRIPTOR = "Invalid descriptor: ";
    private static final String INVALID_TYPE_REFERENCE = "Invalid type reference sort 0x";
    private static final String INVALID_LOCAL_VARIABLE_INDEX = "Invalid local variable index";
    private static final String MUST_NOT_BE_NULL_OR_EMPTY = " (must not be null or empty)";
    private static final String START_LABEL = "start label";
    private static final String END_LABEL = "end label";
    public int version;
    private int access;
    private int visibleAnnotableParameterCount;
    private int invisibleAnnotableParameterCount;
    private boolean visitCodeCalled;
    private boolean visitMaxCalled;
    private boolean visitEndCalled;
    private int insnCount;
    private final Map<Label, Integer> labelInsnIndices;
    private Set<Label> referencedLabels;
    private int lastFrameInsnIndex = -1;
    private int numExpandedFrames;
    private int numCompressedFrames;
    private List<Label> handlers;

    public CheckMethodAdapter(MethodVisitor methodVisitor) {
        this(methodVisitor, new HashMap<Label, Integer>());
    }

    public CheckMethodAdapter(MethodVisitor methodVisitor, Map<Label, Integer> map) {
        this(589824, methodVisitor, map);
        if (this.getClass() != CheckMethodAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckMethodAdapter(int n2, MethodVisitor methodVisitor, Map<Label, Integer> map) {
        super(n2, methodVisitor);
        this.labelInsnIndices = map;
        this.referencedLabels = new HashSet<Label>();
        this.handlers = new ArrayList<Label>();
    }

    public CheckMethodAdapter(int n2, String string, String string2, MethodVisitor methodVisitor, Map<Label, Integer> map) {
        this(589824, n2, string, string2, methodVisitor, map);
        if (this.getClass() != CheckMethodAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckMethodAdapter(int n2, int n3, String string, String string2, final MethodVisitor methodVisitor, Map<Label, Integer> map) {
        this(n2, new MethodNode(n2, n3, string, string2, null, null){

            @Override
            public void visitEnd() {
                Object object;
                int n2 = this.maxLocals;
                int n3 = this.maxStack;
                boolean bl2 = false;
                boolean bl3 = false;
                if (methodVisitor instanceof MethodWriterWrapper) {
                    object = (MethodWriterWrapper)methodVisitor;
                    bl2 = !((MethodWriterWrapper)object).computesMaxs();
                    bl3 = ((MethodWriterWrapper)object).requiresFrames() && !((MethodWriterWrapper)object).computesFrames();
                }
                object = bl3 ? new CheckFrameAnalyzer<BasicValue>(new BasicVerifier()) : new Analyzer<BasicValue>(new BasicVerifier());
                try {
                    if (bl2) {
                        ((Analyzer)object).analyze("dummy", this);
                    } else {
                        ((Analyzer)object).analyzeAndComputeMaxs("dummy", this);
                    }
                }
                catch (AnalyzerException | IndexOutOfBoundsException exception) {
                    this.throwError((Analyzer<BasicValue>)object, exception);
                }
                if (methodVisitor != null) {
                    this.maxLocals = n2;
                    this.maxStack = n3;
                    this.accept(methodVisitor);
                }
            }

            private void throwError(Analyzer<BasicValue> analyzer, Exception exception) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
                CheckClassAdapter.printAnalyzerResult(this, analyzer, printWriter);
                printWriter.close();
                throw new IllegalArgumentException(1.stringConcat$0(exception.getMessage(), stringWriter.toString()), exception);
            }

            private static /* synthetic */ String stringConcat$0(String string, String string2) {
                return string + " " + string2;
            }
        }, map);
        this.access = n3;
    }

    @Override
    public void visitParameter(String string, int n2) {
        if (string != null) {
            CheckMethodAdapter.checkUnqualifiedName(this.version, string, "name");
        }
        CheckClassAdapter.checkAccess(n2, 36880);
        super.visitParameter(string, n2);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(string, bl2));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        this.checkVisitEndNotCalled();
        int n3 = new TypeReference(n2).getSort();
        if (n3 != 1 && n3 != 18 && n3 != 20 && n3 != 21 && n3 != 22 && n3 != 23) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$0(Integer.toHexString(n3)));
        }
        CheckClassAdapter.checkTypeRef(n2);
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(n2, typePath, string, bl2));
    }

    private static /* synthetic */ String stringConcat$0(String string) {
        return INVALID_TYPE_REFERENCE + string;
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.checkVisitEndNotCalled();
        return new CheckAnnotationAdapter(super.visitAnnotationDefault(), false);
    }

    @Override
    public void visitAnnotableParameterCount(int n2, boolean bl2) {
        this.checkVisitEndNotCalled();
        if (bl2) {
            this.visibleAnnotableParameterCount = n2;
        } else {
            this.invisibleAnnotableParameterCount = n2;
        }
        super.visitAnnotableParameterCount(n2, bl2);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int n2, String string, boolean bl2) {
        this.checkVisitEndNotCalled();
        if (bl2 && this.visibleAnnotableParameterCount > 0 && n2 >= this.visibleAnnotableParameterCount || !bl2 && this.invisibleAnnotableParameterCount > 0 && n2 >= this.invisibleAnnotableParameterCount) {
            throw new IllegalArgumentException("Invalid parameter index");
        }
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitParameterAnnotation(n2, string, bl2));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkVisitEndNotCalled();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitCode() {
        if ((this.access & 0x400) != 0) {
            throw new UnsupportedOperationException("Abstract methods cannot have code");
        }
        this.visitCodeCalled = true;
        super.visitCode();
    }

    @Override
    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        int n5;
        int n6;
        int n7;
        if (this.insnCount == this.lastFrameInsnIndex) {
            throw new IllegalStateException("At most one frame can be visited at a given code location.");
        }
        this.lastFrameInsnIndex = this.insnCount;
        switch (n2) {
            case -1: 
            case 0: {
                n7 = Integer.MAX_VALUE;
                n6 = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                n7 = 0;
                n6 = 0;
                break;
            }
            case 4: {
                n7 = 0;
                n6 = 1;
                break;
            }
            case 1: 
            case 2: {
                n7 = 3;
                n6 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$1(n2));
            }
        }
        if (n3 > n7) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$2(n3, n2));
        }
        if (n4 > n6) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$3(n4, n2));
        }
        if (n2 != 2) {
            if (n3 > 0 && (objectArray == null || objectArray.length < n3)) {
                throw new IllegalArgumentException("Array local[] is shorter than numLocal");
            }
            for (n5 = 0; n5 < n3; ++n5) {
                this.checkFrameValue(objectArray[n5]);
            }
        }
        if (n4 > 0 && (objectArray2 == null || objectArray2.length < n4)) {
            throw new IllegalArgumentException("Array stack[] is shorter than numStack");
        }
        for (n5 = 0; n5 < n4; ++n5) {
            this.checkFrameValue(objectArray2[n5]);
        }
        if (n2 == -1) {
            ++this.numExpandedFrames;
        } else {
            ++this.numCompressedFrames;
        }
        if (this.numExpandedFrames > 0 && this.numCompressedFrames > 0) {
            throw new IllegalArgumentException("Expanded and compressed frames must not be mixed.");
        }
        super.visitFrame(n2, n3, objectArray, n4, objectArray2);
    }

    private static /* synthetic */ String stringConcat$1(int n2) {
        return "Invalid frame type " + n2;
    }

    private static /* synthetic */ String stringConcat$2(int n2, int n3) {
        return "Invalid numLocal=" + n2 + " for frame type " + n3;
    }

    private static /* synthetic */ String stringConcat$3(int n2, int n3) {
        return "Invalid numStack=" + n2 + " for frame type " + n3;
    }

    @Override
    public void visitInsn(int n2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n2, Method.VISIT_INSN);
        super.visitInsn(n2);
        ++this.insnCount;
    }

    @Override
    public void visitIntInsn(int n2, int n3) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n2, Method.VISIT_INT_INSN);
        switch (n2) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(n3, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(n3, "Invalid operand");
                break;
            }
            case 188: {
                if (n3 >= 4 && n3 <= 11) break;
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$4(n3));
            }
            default: {
                throw new AssertionError();
            }
        }
        super.visitIntInsn(n2, n3);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$4(int n2) {
        return "Invalid operand (must be an array type code T_...): " + n2;
    }

    @Override
    public void visitVarInsn(int n2, int n3) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n2, Method.VISIT_VAR_INSN);
        CheckMethodAdapter.checkUnsignedShort(n3, INVALID_LOCAL_VARIABLE_INDEX);
        super.visitVarInsn(n2, n3);
        ++this.insnCount;
    }

    @Override
    public void visitTypeInsn(int n2, String string) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n2, Method.VISIT_TYPE_INSN);
        CheckMethodAdapter.checkInternalName(this.version, string, "type");
        if (n2 == 187 && string.charAt(0) == '[') {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$5(string));
        }
        super.visitTypeInsn(n2, string);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$5(String string) {
        return "NEW cannot be used to create arrays: " + string;
    }

    @Override
    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n2, Method.VISIT_FIELD_INSN);
        CheckMethodAdapter.checkInternalName(this.version, string, "owner");
        CheckMethodAdapter.checkUnqualifiedName(this.version, string2, "name");
        CheckMethodAdapter.checkDescriptor(this.version, string3, false);
        super.visitFieldInsn(n2, string, string2, string3);
        ++this.insnCount;
    }

    @Override
    public void visitMethodInsn(int n2, String string, String string2, String string3, boolean bl2) {
        if (this.api < 327680 && (n2 & 0x100) == 0) {
            super.visitMethodInsn(n2, string, string2, string3, bl2);
            return;
        }
        int n3 = n2 & 0xFFFFFEFF;
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n3, Method.VISIT_METHOD_INSN);
        if (n3 != 183 || !"<init>".equals(string2)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, string2, "name");
        }
        CheckMethodAdapter.checkInternalName(this.version, string, "owner");
        CheckMethodAdapter.checkMethodDescriptor(this.version, string3);
        if (n3 == 182 && bl2) {
            throw new IllegalArgumentException("INVOKEVIRTUAL can't be used with interfaces");
        }
        if (n3 == 185 && !bl2) {
            throw new IllegalArgumentException("INVOKEINTERFACE can't be used with classes");
        }
        if (n3 == 183 && bl2 && (this.version & 0xFFFF) < 52) {
            throw new IllegalArgumentException("INVOKESPECIAL can't be used with interfaces prior to Java 8");
        }
        super.visitMethodInsn(n2, string, string2, string3, bl2);
        ++this.insnCount;
    }

    @Override
    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkMethodIdentifier(this.version, string, "name");
        CheckMethodAdapter.checkMethodDescriptor(this.version, string2);
        if (handle.getTag() != 6 && handle.getTag() != 8) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$6(handle.getTag()));
        }
        for (Object object : objectArray) {
            this.checkLdcConstant(object);
        }
        super.visitInvokeDynamicInsn(string, string2, handle, objectArray);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$6(int n2) {
        return "invalid handle tag " + n2;
    }

    @Override
    public void visitJumpInsn(int n2, Label label) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkOpcodeMethod(n2, Method.VISIT_JUMP_INSN);
        this.checkLabel(label, false, "label");
        super.visitJumpInsn(n2, label);
        ++this.insnCount;
    }

    @Override
    public void visitLabel(Label label) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.checkLabel(label, false, "label");
        if (this.labelInsnIndices.get(label) != null) {
            throw new IllegalStateException("Already visited label");
        }
        this.labelInsnIndices.put(label, this.insnCount);
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.checkLdcConstant(object);
        super.visitLdcInsn(object);
        ++this.insnCount;
    }

    @Override
    public void visitIincInsn(int n2, int n3) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkUnsignedShort(n2, INVALID_LOCAL_VARIABLE_INDEX);
        CheckMethodAdapter.checkSignedShort(n3, "Invalid increment");
        super.visitIincInsn(n2, n3);
        ++this.insnCount;
    }

    @Override
    public void visitTableSwitchInsn(int n2, int n3, Label label, Label ... labelArray) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        if (n3 < n2) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$7(n3, n2));
        }
        this.checkLabel(label, false, "default label");
        if (labelArray == null || labelArray.length != n3 - n2 + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.checkLabel(labelArray[i2], false, CheckMethodAdapter.stringConcat$8(i2));
        }
        super.visitTableSwitchInsn(n2, n3, label, labelArray);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$7(int n2, int n3) {
        return "Max = " + n2 + " must be greater than or equal to min = " + n3;
    }

    private static /* synthetic */ String stringConcat$8(int n2) {
        return "label at index " + n2;
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n2;
        this.checkVisitMaxsNotCalled();
        this.checkVisitCodeCalled();
        this.checkLabel(label, false, "default label");
        if (nArray == null || labelArray == null || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (n2 = 1; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= nArray[n2 - 1]) continue;
            throw new IllegalArgumentException("The keys must be sorted in increasing order");
        }
        for (n2 = 0; n2 < labelArray.length; ++n2) {
            this.checkLabel(labelArray[n2], false, CheckMethodAdapter.stringConcat$9(n2));
        }
        super.visitLookupSwitchInsn(label, nArray, labelArray);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$9(int n2) {
        return "label at index " + n2;
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int n2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        if (string.charAt(0) != '[') {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$10(string));
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$11(n2));
        }
        if (n2 > string.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$12(n2));
        }
        super.visitMultiANewArrayInsn(string, n2);
        ++this.insnCount;
    }

    private static /* synthetic */ String stringConcat$10(String string) {
        return "Invalid descriptor (must be an array type descriptor): " + string;
    }

    private static /* synthetic */ String stringConcat$11(int n2) {
        return "Invalid dimensions (must be greater than 0): " + n2;
    }

    private static /* synthetic */ String stringConcat$12(int n2) {
        return "Invalid dimensions (must not be greater than numDimensions(descriptor)): " + n2;
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        int n3 = new TypeReference(n2).getSort();
        if (n3 != 67 && n3 != 68 && n3 != 69 && n3 != 70 && n3 != 71 && n3 != 72 && n3 != 73 && n3 != 74 && n3 != 75) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$13(Integer.toHexString(n3)));
        }
        CheckClassAdapter.checkTypeRef(n2);
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitInsnAnnotation(n2, typePath, string, bl2));
    }

    private static /* synthetic */ String stringConcat$13(String string) {
        return INVALID_TYPE_REFERENCE + string;
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.checkLabel(label, false, START_LABEL);
        this.checkLabel(label2, false, END_LABEL);
        this.checkLabel(label3, false, "handler label");
        if (this.labelInsnIndices.get(label) != null || this.labelInsnIndices.get(label2) != null || this.labelInsnIndices.get(label3) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (string != null) {
            CheckMethodAdapter.checkInternalName(this.version, string, "type");
        }
        super.visitTryCatchBlock(label, label2, label3, string);
        this.handlers.add(label);
        this.handlers.add(label2);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        int n3 = new TypeReference(n2).getSort();
        if (n3 != 66) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$14(Integer.toHexString(n3)));
        }
        CheckClassAdapter.checkTypeRef(n2);
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        return new CheckAnnotationAdapter(super.visitTryCatchAnnotation(n2, typePath, string, bl2));
    }

    private static /* synthetic */ String stringConcat$14(String string) {
        return INVALID_TYPE_REFERENCE + string;
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkUnqualifiedName(this.version, string, "name");
        CheckMethodAdapter.checkDescriptor(this.version, string2, false);
        if (string3 != null) {
            CheckClassAdapter.checkFieldSignature(string3);
        }
        this.checkLabel(label, true, START_LABEL);
        this.checkLabel(label2, true, END_LABEL);
        CheckMethodAdapter.checkUnsignedShort(n2, INVALID_LOCAL_VARIABLE_INDEX);
        int n3 = this.labelInsnIndices.get(label);
        int n4 = this.labelInsnIndices.get(label2);
        if (n4 < n3) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        super.visitLocalVariable(string, string2, string3, label, label2, n2);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int n2, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl2) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        int n3 = new TypeReference(n2).getSort();
        if (n3 != 64 && n3 != 65) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$15(Integer.toHexString(n3)));
        }
        CheckClassAdapter.checkTypeRef(n2);
        CheckMethodAdapter.checkDescriptor(this.version, string, false);
        if (labelArray == null || labelArray2 == null || nArray == null || labelArray2.length != labelArray.length || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("Invalid start, end and index arrays (must be non null and of identical length");
        }
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.checkLabel(labelArray[i2], true, START_LABEL);
            this.checkLabel(labelArray2[i2], true, END_LABEL);
            CheckMethodAdapter.checkUnsignedShort(nArray[i2], INVALID_LOCAL_VARIABLE_INDEX);
            int n4 = this.labelInsnIndices.get(labelArray[i2]);
            int n5 = this.labelInsnIndices.get(labelArray2[i2]);
            if (n5 >= n4) continue;
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        return super.visitLocalVariableAnnotation(n2, typePath, labelArray, labelArray2, nArray, string, bl2);
    }

    private static /* synthetic */ String stringConcat$15(String string) {
        return INVALID_TYPE_REFERENCE + string;
    }

    @Override
    public void visitLineNumber(int n2, Label label) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid line number");
        this.checkLabel(label, true, START_LABEL);
        super.visitLineNumber(n2, label);
    }

    @Override
    public void visitMaxs(int n2, int n3) {
        this.checkVisitCodeCalled();
        this.checkVisitMaxsNotCalled();
        this.visitMaxCalled = true;
        for (Label object : this.referencedLabels) {
            if (this.labelInsnIndices.get(object) != null) continue;
            throw new IllegalStateException("Undefined label used");
        }
        for (int i2 = 0; i2 < this.handlers.size(); i2 += 2) {
            Integer n4 = this.labelInsnIndices.get(this.handlers.get(i2));
            Integer n5 = this.labelInsnIndices.get(this.handlers.get(i2 + 1));
            if (n5 > n4) continue;
            throw new IllegalStateException("Empty try catch block handler range");
        }
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(n3, "Invalid max locals");
        super.visitMaxs(n2, n3);
    }

    @Override
    public void visitEnd() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkVisitCodeCalled() {
        if (!this.visitCodeCalled) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    private void checkVisitMaxsNotCalled() {
        if (this.visitMaxCalled) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    private void checkFrameValue(Object object) {
        if (object == Opcodes.TOP || object == Opcodes.INTEGER || object == Opcodes.FLOAT || object == Opcodes.LONG || object == Opcodes.DOUBLE || object == Opcodes.NULL || object == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (object instanceof String) {
            CheckMethodAdapter.checkInternalName(this.version, (String)object, "Invalid stack frame value");
        } else if (object instanceof Label) {
            this.checkLabel((Label)object, false, "label");
        } else {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$16(String.valueOf(object)));
        }
    }

    private static /* synthetic */ String stringConcat$16(String string) {
        return "Invalid stack frame value: " + string;
    }

    private static void checkOpcodeMethod(int n2, Method method) {
        if (n2 < 0 || n2 > 199) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$17(n2));
        }
        if (OPCODE_METHODS[n2] != method) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$18(n2, String.valueOf((Object)method)));
        }
    }

    private static /* synthetic */ String stringConcat$17(int n2) {
        return "Invalid opcode: " + n2;
    }

    private static /* synthetic */ String stringConcat$18(int n2, String string) {
        return "Invalid combination of opcode and method: " + n2 + ", " + string;
    }

    private static void checkSignedByte(int n2, String string) {
        if (n2 < -128 || n2 > 127) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$19(string, n2));
        }
    }

    private static /* synthetic */ String stringConcat$19(String string, int n2) {
        return string + " (must be a signed byte): " + n2;
    }

    private static void checkSignedShort(int n2, String string) {
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$20(string, n2));
        }
    }

    private static /* synthetic */ String stringConcat$20(String string, int n2) {
        return string + " (must be a signed short): " + n2;
    }

    private static void checkUnsignedShort(int n2, String string) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$21(string, n2));
        }
    }

    private static /* synthetic */ String stringConcat$21(String string, int n2) {
        return string + " (must be an unsigned short): " + n2;
    }

    static void checkConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Float || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$22(String.valueOf(object)));
        }
    }

    private static /* synthetic */ String stringConcat$22(String string) {
        return "Invalid constant: " + string;
    }

    private void checkLdcConstant(Object object) {
        if (object instanceof Type) {
            int n2 = ((Type)object).getSort();
            if (n2 != 10 && n2 != 9 && n2 != 11) {
                throw new IllegalArgumentException("Illegal LDC constant value");
            }
            if (n2 != 11 && (this.version & 0xFFFF) < 49) {
                throw new IllegalArgumentException("ldc of a constant class requires at least version 1.5");
            }
            if (n2 == 11 && (this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a method type requires at least version 1.7");
            }
        } else if (object instanceof Handle) {
            if ((this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a Handle requires at least version 1.7");
            }
            Handle handle = (Handle)object;
            int n3 = handle.getTag();
            if (n3 < 1 || n3 > 9) {
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$23(n3));
            }
            CheckMethodAdapter.checkInternalName(this.version, handle.getOwner(), "handle owner");
            if (n3 <= 4) {
                CheckMethodAdapter.checkDescriptor(this.version, handle.getDesc(), false);
            } else {
                CheckMethodAdapter.checkMethodDescriptor(this.version, handle.getDesc());
            }
            String string = handle.getName();
            if (!"<init>".equals(string) || n3 != 8) {
                CheckMethodAdapter.checkMethodIdentifier(this.version, string, "handle name");
            }
        } else if (object instanceof ConstantDynamic) {
            if ((this.version & 0xFFFF) < 55) {
                throw new IllegalArgumentException("ldc of a ConstantDynamic requires at least version 11");
            }
            ConstantDynamic constantDynamic = (ConstantDynamic)object;
            CheckMethodAdapter.checkMethodIdentifier(this.version, constantDynamic.getName(), "constant dynamic name");
            CheckMethodAdapter.checkDescriptor(this.version, constantDynamic.getDescriptor(), false);
            this.checkLdcConstant(constantDynamic.getBootstrapMethod());
            int n4 = constantDynamic.getBootstrapMethodArgumentCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                this.checkLdcConstant(constantDynamic.getBootstrapMethodArgument(i2));
            }
        } else {
            CheckMethodAdapter.checkConstant(object);
        }
    }

    private static /* synthetic */ String stringConcat$23(int n2) {
        return "invalid handle tag " + n2;
    }

    static void checkUnqualifiedName(int n2, String string, String string2) {
        CheckMethodAdapter.checkIdentifier(n2, string, 0, -1, string2);
    }

    static void checkIdentifier(int n2, String string, int n3, int n4, String string2) {
        int n5;
        if (string == null || (n4 == -1 ? string.length() <= n3 : n4 <= n3)) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$24(string2));
        }
        int n6 = n5 = n4 == -1 ? string.length() : n4;
        if ((n2 & 0xFFFF) >= 49) {
            int n7 = n3;
            while (n7 < n5) {
                if (".;[/".indexOf(string.codePointAt(n7)) != -1) {
                    throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$25(string2, string));
                }
                n7 = string.offsetByCodePoints(n7, 1);
            }
            return;
        }
        int n8 = n3;
        while (n8 < n5) {
            if (n8 == n3 ? !Character.isJavaIdentifierStart(string.codePointAt(n8)) : !Character.isJavaIdentifierPart(string.codePointAt(n8))) {
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$26(string2, string));
            }
            n8 = string.offsetByCodePoints(n8, 1);
        }
    }

    private static /* synthetic */ String stringConcat$24(String string) {
        return INVALID + string + MUST_NOT_BE_NULL_OR_EMPTY;
    }

    private static /* synthetic */ String stringConcat$25(String string, String string2) {
        return INVALID + string + " (must not contain . ; [ or /): " + string2;
    }

    private static /* synthetic */ String stringConcat$26(String string, String string2) {
        return INVALID + string + " (must be a valid Java identifier): " + string2;
    }

    static void checkMethodIdentifier(int n2, String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$27(string2));
        }
        if ((n2 & 0xFFFF) >= 49) {
            int n3 = 0;
            while (n3 < string.length()) {
                if (".;[/<>".indexOf(string.codePointAt(n3)) != -1) {
                    throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$28(string2, string));
                }
                n3 = string.offsetByCodePoints(n3, 1);
            }
            return;
        }
        int n4 = 0;
        while (n4 < string.length()) {
            if (n4 == 0 ? !Character.isJavaIdentifierStart(string.codePointAt(n4)) : !Character.isJavaIdentifierPart(string.codePointAt(n4))) {
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$29(string2, string));
            }
            n4 = string.offsetByCodePoints(n4, 1);
        }
    }

    private static /* synthetic */ String stringConcat$27(String string) {
        return INVALID + string + MUST_NOT_BE_NULL_OR_EMPTY;
    }

    private static /* synthetic */ String stringConcat$28(String string, String string2) {
        return INVALID + string + " (must be a valid unqualified name): " + string2;
    }

    private static /* synthetic */ String stringConcat$29(String string, String string2) {
        return INVALID + string + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + string2;
    }

    static void checkInternalName(int n2, String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$30(string2));
        }
        if (string.charAt(0) == '[') {
            CheckMethodAdapter.checkDescriptor(n2, string, false);
        } else {
            CheckMethodAdapter.checkInternalClassName(n2, string, string2);
        }
    }

    private static /* synthetic */ String stringConcat$30(String string) {
        return INVALID + string + MUST_NOT_BE_NULL_OR_EMPTY;
    }

    private static void checkInternalClassName(int n2, String string, String string2) {
        try {
            int n3;
            int n4 = 0;
            while ((n3 = string.indexOf(47, n4 + 1)) != -1) {
                CheckMethodAdapter.checkIdentifier(n2, string, n4, n3, null);
                n4 = n3 + 1;
            }
            CheckMethodAdapter.checkIdentifier(n2, string, n4, string.length(), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$31(string2, string), illegalArgumentException);
        }
    }

    private static /* synthetic */ String stringConcat$31(String string, String string2) {
        return INVALID + string + " (must be an internal class name): " + string2;
    }

    static void checkDescriptor(int n2, String string, boolean bl2) {
        int n3 = CheckMethodAdapter.checkDescriptor(n2, string, 0, bl2);
        if (n3 != string.length()) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$32(string));
        }
    }

    private static /* synthetic */ String stringConcat$32(String string) {
        return INVALID_DESCRIPTOR + string;
    }

    private static int checkDescriptor(int n2, String string, int n3, boolean bl2) {
        if (string == null || n3 >= string.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (string.charAt(n3)) {
            case 'V': {
                if (bl2) {
                    return n3 + 1;
                }
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$33(string));
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n3 + 1;
            }
            case '[': {
                int n4;
                for (n4 = n3 + 1; n4 < string.length() && string.charAt(n4) == '['; ++n4) {
                }
                if (n4 < string.length()) {
                    return CheckMethodAdapter.checkDescriptor(n2, string, n4, false);
                }
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$34(string));
            }
            case 'L': {
                int n5 = string.indexOf(59, n3);
                if (n3 == -1 || n5 - n3 < 2) {
                    throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$35(string));
                }
                try {
                    CheckMethodAdapter.checkInternalClassName(n2, string.substring(n3 + 1, n5), null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$36(string), illegalArgumentException);
                }
                return n5 + 1;
            }
        }
        throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$37(string));
    }

    private static /* synthetic */ String stringConcat$33(String string) {
        return INVALID_DESCRIPTOR + string;
    }

    private static /* synthetic */ String stringConcat$34(String string) {
        return INVALID_DESCRIPTOR + string;
    }

    private static /* synthetic */ String stringConcat$35(String string) {
        return INVALID_DESCRIPTOR + string;
    }

    private static /* synthetic */ String stringConcat$36(String string) {
        return INVALID_DESCRIPTOR + string;
    }

    private static /* synthetic */ String stringConcat$37(String string) {
        return INVALID_DESCRIPTOR + string;
    }

    static void checkMethodDescriptor(int n2, String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (string.charAt(0) != '(' || string.length() < 3) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$38(string));
        }
        int n3 = 1;
        if (string.charAt(n3) != ')') {
            do {
                if (string.charAt(n3) != 'V') continue;
                throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$39(string));
            } while ((n3 = CheckMethodAdapter.checkDescriptor(n2, string, n3, false)) < string.length() && string.charAt(n3) != ')');
        }
        if ((n3 = CheckMethodAdapter.checkDescriptor(n2, string, n3 + 1, true)) != string.length()) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$40(string));
        }
    }

    private static /* synthetic */ String stringConcat$38(String string) {
        return INVALID_DESCRIPTOR + string;
    }

    private static /* synthetic */ String stringConcat$39(String string) {
        return INVALID_DESCRIPTOR + string;
    }

    private static /* synthetic */ String stringConcat$40(String string) {
        return INVALID_DESCRIPTOR + string;
    }

    private void checkLabel(Label label, boolean bl2, String string) {
        if (label == null) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$41(string));
        }
        if (bl2 && this.labelInsnIndices.get(label) == null) {
            throw new IllegalArgumentException(CheckMethodAdapter.stringConcat$42(string));
        }
        this.referencedLabels.add(label);
    }

    private static /* synthetic */ String stringConcat$41(String string) {
        return INVALID + string + " (must not be null)";
    }

    private static /* synthetic */ String stringConcat$42(String string) {
        return INVALID + string + " (must be visited first)";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Method {
        VISIT_INSN,
        VISIT_INT_INSN,
        VISIT_VAR_INSN,
        VISIT_TYPE_INSN,
        VISIT_FIELD_INSN,
        VISIT_METHOD_INSN,
        VISIT_JUMP_INSN;

    }

    static class MethodWriterWrapper
    extends MethodVisitor {
        private final int version;
        private final ClassWriter owner;

        MethodWriterWrapper(int n2, int n3, ClassWriter classWriter, MethodVisitor methodVisitor) {
            super(n2, methodVisitor);
            this.version = n3;
            this.owner = classWriter;
        }

        boolean computesMaxs() {
            return this.owner.hasFlags(1) || this.owner.hasFlags(2);
        }

        boolean computesFrames() {
            return this.owner.hasFlags(2);
        }

        boolean requiresFrames() {
            return (this.version & 0xFFFF) >= 51;
        }
    }
}

