/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.c.a;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.SystemClock;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.core.ContrastVersion;
import com.contrastsecurity.agent.core.b;
import com.contrastsecurity.agent.core.u;
import com.contrastsecurity.agent.core.v;
import com.contrastsecurity.agent.e;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.j;
import com.contrastsecurity.agent.k;
import com.contrastsecurity.agent.logging.c;
import com.contrastsecurity.agent.o.l;
import com.contrastsecurity.agent.r;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeModule;
import com.contrastsecurity.agent.services.d;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.P;
import com.contrastsecurity.agent.startup.h;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.c.g;
import com.contrastsecurity.agent.telemetry.o;
import com.contrastsecurity.agent.u.B;
import com.contrastsecurity.agent.util.I;
import com.contrastsecurity.agent.util.J;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public class ContrastAgent {
    private static final String DELAYED_BOOT_STRATEGY = "boot";
    private static final String DELAYED_ACTIVATION_STRATEGY = "activation";
    private static final String ERROR_PROBABILISTIC_VALUE = "Unable to process probabilistic startup value";
    private static ContrastVersion version = ContrastVersion.fromDefaults();

    @ScopedSensor
    public static void setup(String string, Instrumentation instrumentation, File file, StartupTiming startupTiming) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            com.contrastsecurity.agent.config.o o2;
            Objects.requireNonNull(instrumentation);
            version = ContrastVersion.fromJarFile(file);
            I i2 = J.b();
            ContrastAgent.patchLiferayLocaleErrors();
            h h2 = new h();
            try {
                o2 = h2.a(string);
            }
            catch (com.contrastsecurity.agent.config.c.c c2) {
                PreConfigUtil.err("Couldn't initialize Contrast. Invalid configuration: " + c2.getMessage());
                c2.printStackTrace(System.err);
                ContrastAgent.logStartingWithoutContrast();
                scopeAggregator.leaveScope();
                return;
            }
            com.contrastsecurity.agent.config.h.a(o2);
            i2.b();
            startupTiming.configLoadTimeNs(i2.e());
            boolean bl2 = o2.c(ConfigProperty.SUPPRESS_STDOUT);
            if (bl2) {
                PreConfigUtil.quiet();
            }
            if (ContrastAgent.isAgentStartupDisabled(o2)) {
                scopeAggregator.leaveScope();
                return;
            }
            int n2 = ContrastAgent.getStartupDelay(o2);
            if (n2 > 0) {
                ContrastAgent.delayedStartup(instrumentation, o2, n2, startupTiming);
            } else {
                ContrastEngine contrastEngine = ContrastAgent.startup(instrumentation, o2, startupTiming);
                if (contrastEngine != null) {
                    contrastEngine.activatePlugins();
                }
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @t
    static boolean isAgentStartupDisabled(com.contrastsecurity.agent.config.e e2) {
        if (!e2.c(ConfigProperty.ENABLED)) {
            return true;
        }
        try {
            a a2 = ContrastAgent.probabilisticStartupCheck(e2);
            return a2 != null && !a2.a();
        }
        catch (FatalStartupException fatalStartupException) {
            return true;
        }
    }

    private static a probabilisticStartupCheck(com.contrastsecurity.agent.config.e e2) throws FatalStartupException {
        int n2;
        try {
            n2 = e2.d(ConfigProperty.PROBABILISTIC_STARTUP);
        }
        catch (com.contrastsecurity.agent.config.c.c c2) {
            ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with non-numeric value");
            throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
        }
        if (n2 != -1) {
            try {
                return new a(n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with an invalid value: " + n2);
                throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
            }
        }
        return null;
    }

    private static void logProbabilisticStartupConfigError(String string) {
        PreConfigUtil.err(string);
        PreConfigUtil.err("Please specify a number between 1 and 99 (percentage)");
        ContrastAgent.logStartingWithoutContrast();
    }

    private static void logStartingWithoutContrast() {
        PreConfigUtil.err("Continuing without Contrast...");
    }

    private static void delayedStartup(Instrumentation instrumentation, com.contrastsecurity.agent.config.o o2, int n2, StartupTiming startupTiming) {
        String string = o2.b(ConfigProperty.DELAYED_STARTUP_STRATEGY);
        if (string == null || DELAYED_ACTIVATION_STRATEGY.equalsIgnoreCase(string)) {
            ContrastEngine contrastEngine = ContrastAgent.startup(instrumentation, o2, startupTiming);
            j j2 = new j(contrastEngine, n2, contrastEngine.getErrorEmitter());
            j2.setDaemon(true);
            j2.start();
        } else if (DELAYED_BOOT_STRATEGY.equalsIgnoreCase(string)) {
            k k2 = new k(n2, instrumentation, o2, startupTiming);
            k2.setDaemon(true);
            k2.start();
        } else {
            PreConfigUtil.err("Invalid delayed startup strategy (" + string + ")");
        }
    }

    static int getStartupDelay(com.contrastsecurity.agent.config.e e2) {
        int n2 = 0;
        try {
            n2 = e2.d(ConfigProperty.DELAYED_STARTUP);
        }
        catch (com.contrastsecurity.agent.config.c.c c2) {
            // empty catch block
        }
        return Math.max(n2, 0);
    }

    public static ContrastEngine startup(Instrumentation instrumentation, com.contrastsecurity.agent.config.o o2, StartupTiming startupTiming) {
        I i2 = J.b();
        PreConfigUtil.out("Starting Contrast (build " + ContrastAgent.getBuildVersion() + ") Pat. 8,458,789 B2");
        d d2 = new d();
        B b2 = B.a(o2);
        c c2 = com.contrastsecurity.agent.logging.log4j2.g.a(o2, b2, d2);
        Logger logger = LoggerFactory.getLogger(ContrastAgent.class);
        try {
            com.contrastsecurity.agent.f.l l2 = new com.contrastsecurity.agent.f.l();
            ObjectShare.initGson(o2, l2);
            SystemClock systemClock = new SystemClock();
            o o3 = o.a((com.contrastsecurity.agent.config.e)o2, b2, systemClock);
            TelemetryMetrics telemetryMetrics = o3.d();
            c2.a(d2, telemetryMetrics);
            g.a(telemetryMetrics, systemClock);
            com.contrastsecurity.agent.telemetry.h h2 = new com.contrastsecurity.agent.telemetry.h(telemetryMetrics.isEnabled());
            com.contrastsecurity.agent.p.b b3 = com.contrastsecurity.agent.p.b.a();
            ContrastEngine contrastEngine = ContrastAgent.createContrastEngine(instrumentation, o2, new com.contrastsecurity.agent.plugins.apps.k(), c2, startupTiming, b2, d2, systemClock, o3, h2, b3, l2);
            i2.b();
            String string = "JVM uptime time before agent: " + startupTiming.getJvmUptimeAtPremainMs() + "ms";
            PerfUtil.printStartupTimingMessage(string);
            long l3 = TimeUnit.NANOSECONDS.toMillis(startupTiming.getTimeForJarTmpInjectionNs());
            PerfUtil.printStartupTimingMessage(PerfUtil.a.a, "jar-injection", l3);
            h2.a(PerfUtil.a.a, "load-config", startupTiming.configLoadMs());
            h2.a(PerfUtil.a.a, "primordial", i2);
            contrastEngine.start(startupTiming);
            return contrastEngine;
        }
        catch (FatalStartupException fatalStartupException) {
            PreConfigUtil.err("Couldn't initialize Contrast. See log for details.");
            logger.error("Unexpected error starting up. Continuing without Contrast", fatalStartupException);
            return null;
        }
    }

    @t
    static void patchLiferayLocaleErrors() {
        String string = r.b("java.locale.providers");
        if (string == null || string.isEmpty()) {
            return;
        }
        String string2 = string.toUpperCase(Locale.ROOT);
        if (!string2.contains("COMPAT")) {
            return;
        }
        String[] stringArray = string2.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (string3.trim().equals("COMPAT")) {
                stringBuilder.append("JRE");
                continue;
            }
            stringBuilder.append(string3.trim());
        }
        r.a("java.locale.providers", stringBuilder.toString());
    }

    @t
    static ContrastEngine createContrastEngine(Instrumentation instrumentation, com.contrastsecurity.agent.config.o o2, com.contrastsecurity.agent.plugins.apps.k k2, c c2, StartupTiming startupTiming, B b2, d d2, com.contrastsecurity.agent.commons.b b3, o o3, com.contrastsecurity.agent.telemetry.h h2, com.contrastsecurity.agent.p.b b4, com.contrastsecurity.agent.f.l l2) throws FatalStartupException {
        WorkingDirectories workingDirectories;
        try {
            workingDirectories = WorkingDirectories.fromConfig(o2);
        }
        catch (IOException iOException) {
            throw new e("Unable to create references to working directories", iOException);
        }
        b.a a2 = o2.c(ConfigProperty.ENABLE_INTEGRATION_TEST_SERVICES) ? v.a() : u.a();
        b b5 = a2.a(k2).a(b4).a(b3).a(o2).a(b2).a(workingDirectories).a(d2).b(d2).a(instrumentation).a(c2).a(o3).a(startupTiming).a(h2).a(l2).a();
        l l3 = b5.e();
        com.contrastsecurity.agent.m.a a3 = b5.k();
        HttpManager httpManager = b5.i();
        com.contrastsecurity.agent.plugins.j j2 = b5.f();
        com.contrastsecurity.agent.telemetry.errors.o o4 = o3.g();
        if (l3 instanceof com.contrastsecurity.agent.o.o) {
            ((com.contrastsecurity.agent.o.o)l3).a(httpManager);
        }
        k2.addListener(o2);
        List<com.contrastsecurity.agent.services.a> list = b5.n();
        com.contrastsecurity.agent.services.ngreporting.h h3 = b5.m();
        List<P> list2 = b5.o();
        return new ContrastEngine(instrumentation, b2, o2, list2, b3, list, j2, h3, ScopeModule.scopeProvider(), workingDirectories, o3.d(), o4, a3.d(), c2, d2, h2, b5.l(), b5.p());
    }

    public static String getJarName() {
        return version.getJarName();
    }

    static void setVersion(ContrastVersion contrastVersion) {
        version = contrastVersion;
    }

    public static String getBuildVersion() {
        return version.getVersion();
    }

    public static String getBuildTime() {
        return version.getBuildTime();
    }
}

