/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.msgpack.core.annotations.VisibleForTesting;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@DontObfuscate
public final class ContrastVersion {
    private final String jarName;
    private final String buildTime;
    private final String version;
    static final String BUILD_TIME = "Build-Time";
    static final String BUILD_IMPL_VERSION = "Implementation-Build";
    static final String DEFAULT_JAR_NAME = "contrast.jar";

    ContrastVersion(String string) {
        this(string, "20240520.2020", ContrastVersion.parseVersion());
    }

    @VisibleForTesting
    ContrastVersion(String string, String string2, String string3) {
        this.jarName = Objects.requireNonNull(string);
        this.buildTime = Objects.requireNonNull(string2);
        this.version = Objects.requireNonNull(string3);
    }

    static ContrastVersion fromDefaults() {
        return new ContrastVersion(DEFAULT_JAR_NAME);
    }

    static ContrastVersion fromJarFile(File file) {
        String string;
        Objects.requireNonNull(file, "file parameter cannot be null");
        try {
            File file2 = new File(URLDecoder.decode(file.getAbsolutePath(), StandardCharsets.UTF_8.name()));
            if (!file2.exists()) {
                return ContrastVersion.fromDefaults();
            }
            string = file2.getName();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return ContrastVersion.fromDefaults();
        }
        return new ContrastVersion(string);
    }

    private static String parseVersion() {
        String string = System.getProperty(ConfigProperty.AGENT_VERSION_OVERRIDE.commonConfigSystemPropertyName());
        return StringUtils.isBlank(string) ? "6.5.1" : string;
    }

    String getJarName() {
        return this.jarName;
    }

    String getBuildTime() {
        return this.buildTime;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ContrastVersion contrastVersion = (ContrastVersion)object;
        return this.jarName.equals(contrastVersion.jarName) && this.buildTime.equals(contrastVersion.buildTime) && this.version.equals(contrastVersion.version);
    }

    public int hashCode() {
        int n2 = this.jarName.hashCode();
        n2 = 31 * n2 + this.buildTime.hashCode();
        n2 = 31 * n2 + this.version.hashCode();
        return n2;
    }
}

