/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpRequestFactory;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.a;
import com.contrastsecurity.agent.http.b;
import com.contrastsecurity.agent.http.h;
import com.contrastsecurity.agent.http.k;
import com.contrastsecurity.agent.http.p;
import com.contrastsecurity.agent.o.e;
import com.contrastsecurity.agent.plugins.j;
import com.contrastsecurity.agent.plugins.protect.d.m;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.util.D;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.io.FileUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@Singleton
@DontObfuscate
public class HttpManager
implements a {
    private final j pluginManager;
    private final AtomicBoolean isFirstRequest;
    private final h firstRequestEndListener;
    private final e eventBus;
    private final boolean featureSamplingEnabled;
    private final int featureSamplingFrequency;
    private static final ThreadLocal<HttpRequest> HTTP_REQUEST = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<HttpResponse> HTTP_RESPONSE = ThreadLocal.withInitial(() -> null);
    private final int maxRetainedBufferSize;
    private static final Logger logger = LoggerFactory.getLogger(HttpManager.class);

    @Inject
    public HttpManager(com.contrastsecurity.agent.config.e e2, j j2, h h2, e e3) {
        this.pluginManager = j2;
        this.firstRequestEndListener = h2;
        this.isFirstRequest = new AtomicBoolean(true);
        this.eventBus = e3;
        this.maxRetainedBufferSize = e2.d(ConfigProperty.MAX_RETAINED_BUFFER_SIZE);
        this.featureSamplingEnabled = e2.c(ConfigProperty.FEATURE_REQUEST_SAMPLING_ENABLED);
        this.featureSamplingFrequency = e2.d(ConfigProperty.FEATURE_REQUEST_SAMPLING_FREQUENCY);
    }

    public HttpRequest getCurrentRequest() {
        return HTTP_REQUEST.get();
    }

    public void setCurrentResponse(HttpResponse httpResponse) {
        try {
            HttpManager.updateResponseBreadCrumbs(httpResponse);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem updating HTTP response crumbs", exception2);
        }
        if (httpResponse == null) {
            HTTP_RESPONSE.remove();
        } else {
            HTTP_RESPONSE.set(httpResponse);
        }
    }

    public HttpResponse getCurrentResponse() {
        return HTTP_RESPONSE.get();
    }

    public HttpRequest onRequestStart(Application application, HttpRequestFactory httpRequestFactory) {
        if (application == null) {
            logger.debug("Application is null, cannot continue");
            return null;
        }
        if (httpRequestFactory == null) {
            logger.debug("HttpRequestFactory is null, cannot continue");
            return null;
        }
        HttpRequest httpRequest = httpRequestFactory.newInstance();
        if (httpRequest == null) {
            logger.debug("HttpRequest was null, cannot continue");
            return null;
        }
        HttpManager.setCurrentRequest(httpRequest);
        httpRequest.reset(this.maxRetainedBufferSize);
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<p> list = contrastPlugin.getRequestLifecycleListeners();
            for (p p2 : list) {
                p2.a(httpRequest);
            }
        });
        this.pluginManager.forEachDisabled(application, httpRequest, contrastPlugin -> {
            List<p> list = contrastPlugin.getRequestLifecycleListeners();
            for (p p2 : list) {
                p2.a();
            }
        });
        return httpRequest;
    }

    public void onResponseStart(Application application, HttpResponse httpResponse) {
        httpResponse.getMemoryBuffer().a(this.maxRetainedBufferSize);
        HttpRequest httpRequest = this.getCurrentRequest();
        if (httpRequest == null) {
            logger.debug("Current HTTPRequest was null");
            return;
        }
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<p> list = contrastPlugin.getRequestLifecycleListeners();
            for (p p2 : list) {
                p2.a(httpRequest, httpResponse);
            }
        });
    }

    public void onRequestEnd(ApplicationManager applicationManager) {
        Object object;
        HttpRequest httpRequest = this.getCurrentRequest();
        if (httpRequest == null || !httpRequest.endRequest()) {
            return;
        }
        HttpResponse httpResponse = this.getCurrentResponse();
        if (httpResponse != null) {
            this.eventBus.a(httpRequest, httpResponse);
        }
        if (logger.isDebugEnabled()) {
            object = httpResponse != null ? httpResponse.getOutputMechanism() : null;
            logger.debug("Request ending for {} - response is {} and output mechanism is {}", httpRequest.getUri(), JVMUtils.getSafeToString(httpResponse, true), httpResponse != null ? JVMUtils.getSafeToString(object, true) : "response-null");
            if (httpResponse != null && httpResponse.getOutputMechanism() != null) {
                Object object2 = httpResponse.getOutputMechanism();
                logger.debug("De-assigning output mechanism {}", (Object)JVMUtils.getSafeToString(object2, true));
            }
        }
        if (httpResponse != null && httpResponse.isCapturingInFile()) {
            logger.debug("Closing response file");
            try {
                httpResponse.closeFileBuffer();
            }
            catch (IOException iOException) {
                logger.error("Problem closing response file buffer", iOException);
            }
        }
        if (httpResponse != null && httpResponse.isCapturing()) {
            this.analyzeResponseContents(applicationManager, httpRequest, httpResponse);
        }
        if (logger.isDebugEnabled() && httpResponse == null) {
            this.logCrumbData(httpRequest);
        }
        object = applicationManager.current();
        this.pluginManager.forEachEnabled((Application)object, httpRequest, contrastPlugin -> {
            List<p> list = contrastPlugin.getRequestLifecycleListeners();
            for (p p2 : list) {
                try {
                    p2.onRequestEnd(httpRequest, httpResponse);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("Problem ending request watching with {}", (Object)p2, (Object)throwable2);
                }
            }
        });
        this.pluginManager.forEachDisabled((Application)object, httpRequest, contrastPlugin -> {
            List<p> list = contrastPlugin.getRequestLifecycleListeners();
            for (p p2 : list) {
                try {
                    p2.b();
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("Problem ending request watching with {}", (Object)p2, (Object)throwable2);
                }
            }
        });
        httpRequest.reset(this.maxRetainedBufferSize);
        if (httpResponse != null) {
            httpResponse.getMemoryBuffer().a(this.maxRetainedBufferSize);
        }
        HTTP_REQUEST.set(null);
        this.setCurrentResponse(null);
        applicationManager.current(null);
        long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - httpRequest.startTimeNs());
        httpRequest.getJfrEvent().a(httpRequest, httpResponse);
        if (logger.isDebugEnabled()) {
            logger.debug("{}{}|RequestEnded|uri={}&elapsed={}", "!LM!", "RequestTime", httpRequest.getNormalizedUri(), l2);
        }
        if (this.isFirstRequest.get() && this.isFirstRequest.getAndSet(false)) {
            this.firstRequestEndListener.onFirstRequestEnd(l2);
        }
    }

    @t
    void analyzeResponseContents(ApplicationManager applicationManager, HttpRequest httpRequest, HttpResponse httpResponse) {
        byte[] byArray;
        if (httpRequest == null || httpResponse == null || !httpResponse.isCapturing()) {
            return;
        }
        String string = httpRequest.getUri();
        if (httpResponse.isEmpty()) {
            logger.debug("Response was empty for URI {}", (Object)string);
            return;
        }
        logger.debug("Scanning response for {}", (Object)string);
        D d2 = httpResponse.getMemoryBuffer().a(Charset.defaultCharset());
        if (httpResponse.isCapturingInMemory()) {
            byArray = d2.b();
        } else if (httpResponse.isCapturingInFile()) {
            byArray = this.readFile(httpResponse.getFileBufferPath());
        } else {
            throw new IllegalStateException("\"Problem scanning response to {}: nothing captured in memory or file!\": " + string);
        }
        String string2 = httpResponse.getCharacterEncoding();
        try {
            if (string2 == null || !Charset.isSupported(string2)) {
                string2 = Charset.defaultCharset().name();
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            String string3 = Charset.defaultCharset().name();
            logger.error("Encountered a strange charset encoding of '{}', falling back to '{}'", (Object)string2, (Object)string3);
            string2 = string3;
        }
        try {
            String string4 = httpResponse.isCapturingInMemory() ? new String(byArray, 0, d2.a(), string2) : new String(byArray, string2);
            logger.debug("Scanning {} response text with length {}/charset {}", string, string4.length(), string2);
            this.pluginManager.forEachEnabled(applicationManager.current(), httpRequest, contrastPlugin -> {
                List<p> list = contrastPlugin.getRequestLifecycleListeners();
                for (p p2 : list) {
                    try {
                        p2.a(httpRequest, httpResponse, string4);
                    }
                    catch (Throwable throwable) {
                        Throwables.throwIfCritical(throwable);
                        Throwable throwable2 = throwable;
                        logger.warn("Problem ending request watching with {}", (Object)p2, (Object)throwable2);
                    }
                }
            });
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("Couldn't parse response body because of weird encoding", unsupportedEncodingException);
        }
    }

    private void logCrumbData(HttpRequest httpRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < Math.min(10, stackTraceElementArray.length); ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder.append("\t\t").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")\n");
        }
        logger.debug("Unexpected null response for request=[{}], CRUMB:\n{}", (Object)httpRequest, (Object)stringBuilder);
    }

    public void clearContext() {
        HTTP_REQUEST.remove();
        HTTP_RESPONSE.remove();
    }

    public void currentContext(HttpRequest httpRequest, HttpResponse httpResponse) {
        HttpManager.setCurrentRequest(httpRequest);
        this.setCurrentResponse(httpResponse);
    }

    public void onMultipartHeaderRead(Application application, HttpRequest httpRequest, MultipartItem multipartItem) {
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<p> list = contrastPlugin.getRequestLifecycleListeners();
            for (p p2 : list) {
                p2.a(httpRequest, multipartItem);
            }
        });
    }

    public void onParametersResolved(Application application, HttpRequest httpRequest) {
        if (httpRequest == null) {
            return;
        }
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<p> list = contrastPlugin.getRequestLifecycleListeners();
            for (p p2 : list) {
                p2.b(httpRequest);
            }
        });
    }

    public void onMoreParametersResolved(Application application, HttpRequest httpRequest, Map<String, String[]> map) {
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<p> list = contrastPlugin.getRequestLifecycleListeners();
            for (p p2 : list) {
                p2.a(httpRequest, map);
            }
        });
    }

    @Override
    public void onBodyInputReceived(Application application, m m2, String string, String string2) {
        this.pluginManager.forEachEnabled(application, this.getCurrentRequest(), contrastPlugin -> {
            List<p> list = contrastPlugin.getRequestLifecycleListeners();
            for (p p2 : list) {
                p2.a(string, string2, m2);
            }
        });
    }

    public boolean isSamplingCurrentRequest(k k2) {
        if (!this.featureSamplingEnabled) {
            return false;
        }
        HttpRequest httpRequest = this.getCurrentRequest();
        return httpRequest != null && httpRequest.isSampling(k2, this::initialIsSamplingValue);
    }

    private boolean initialIsSamplingValue(k k2) {
        return ThreadLocalRandom.current().nextInt(1, this.featureSamplingFrequency + 1) == 1;
    }

    private byte[] readFile(String string) {
        try {
            return FileUtils.readFileToByteArray(new File(string));
        }
        catch (IOException iOException) {
            logger.error("Problem reading response file", iOException);
            return Empty.BYTE_ARRAY;
        }
    }

    private static void updateRequestCrumbs(HttpRequest httpRequest) {
        if (httpRequest == null) {
            HttpRequest httpRequest2 = HTTP_REQUEST.get();
            if (httpRequest2 != null) {
                httpRequest2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpRequest.updateBreadCrumbs(b.b.b);
        }
    }

    private static void updateResponseBreadCrumbs(HttpResponse httpResponse) {
        if (httpResponse == null) {
            HttpResponse httpResponse2 = HTTP_RESPONSE.get();
            if (httpResponse2 != null) {
                httpResponse2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpResponse.updateBreadCrumbs(b.b.b);
        }
    }

    private static void setCurrentRequest(HttpRequest httpRequest) {
        try {
            HttpManager.updateRequestCrumbs(httpRequest);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem updating HTTP request crumbs", exception2);
        }
        if (httpRequest == null) {
            HTTP_REQUEST.remove();
        } else {
            HTTP_REQUEST.set(httpRequest);
        }
    }
}

