/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.http.ReplacedResponseChunk;
import com.contrastsecurity.agent.http.c;
import com.contrastsecurity.agent.http.d;
import com.contrastsecurity.agent.http.g;
import com.contrastsecurity.agent.http.m;
import com.contrastsecurity.agent.http.r;
import com.contrastsecurity.agent.messages.mq.HttpResponseDTM;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@DontObfuscate
public abstract class HttpResponse
extends c {
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Map<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>();
    private volatile d contentTypeHeader;
    private int scope;
    public static final int ENCODING_UTF8 = 0;
    public static final int ENCODING_UTF16 = 1;
    public static final int ENCODING_UTF32 = 2;
    public static final int ENCODING_ASCII = 3;
    public static final int ENCODING_ISO88591 = 4;
    public static final int ENCODING_SYSTEM_DEFAULT = 5;
    private static final m BUFFER = new r();
    private static final g FILE_BUFFER = new g("response");
    private static final String[] ALLOWED_CONTENT_TYPES = new String[]{"text/html", "text/plain", "application/xhtml", "application/xml"};
    private static final int TARGET_SCOPE = 1;
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final Logger logger = LoggerFactory.getLogger(HttpResponse.class);
    private static final int MAX_CAPTURED_SIZE = 65536;
    public static Map<Integer, String> CHARSET_MAP = Maps.builder().add(3, "ASCII").add(0, "UTF-8").add(1, "UTF-16").add(2, "UTF-32").add(4, "ISO-8859-1").add(5, Charset.defaultCharset().name()).build();

    public HttpResponse() {
        super("response");
    }

    public abstract int getStatus();

    protected abstract String frameworkContentType();

    protected abstract String frameworkCharacterEncoding();

    public final String getContentType() {
        return this.contentTypeHeader == null ? this.frameworkContentType() : this.contentTypeHeader.a();
    }

    public final String getCharacterEncoding() {
        return this.contentTypeHeader == null ? this.frameworkCharacterEncoding() : this.contentTypeHeader.b().toString();
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public HttpResponseDTM toHttpResponseDTM() {
        return HttpResponseDTM.builder().characterEncoding(this.getCharacterEncoding()).contentType(this.getContentType()).status(this.getStatus()).headers(this.getHeaders()).build();
    }

    public Object getOutputMechanism() {
        return null;
    }

    public boolean isEmpty() {
        return this.getMemoryBuffer().a().size() <= 0;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void enterWritingScope(Object object) {
        ++this.scope;
    }

    public void leaveWritingScope(Object object) {
        --this.scope;
    }

    public final ReplacedResponseChunk write(byte[] byArray, String string) {
        return this.write(string);
    }

    public final ReplacedResponseChunk write(String string, int n2, int n3) {
        if (string != null && this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(string, n2, n3);
        }
        return null;
    }

    public final ReplacedResponseChunk write(String string) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            if (string == null) {
                string = "null";
            }
            this.doWrite(string);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(char[] cArray) {
        if (cArray != null) {
            this.write(cArray, 0, cArray.length);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(byte[] byArray) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(byArray);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(char[] cArray, int n2, int n3) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(cArray, n2, n3);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(byte[] byArray, int n2, int n3) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(byArray, n2, n3);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(byte by2) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(by2);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(int n2) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(n2);
        }
        return null;
    }

    @ScopedSensor
    private void doWrite(String string, int n2, int n3) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            try {
                string = string.substring(n2, n2 + n3);
                byte[] byArray = this.toEncodedBytes(string);
                if (this.capturingInMemory || this.capturingInFile) {
                    OutputStream outputStream;
                    if (this.capturingInMemory) {
                        outputStream = this.getMemoryBuffer().a();
                        int n4 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                        int n5 = Math.min(n4, byArray.length);
                        ((ByteArrayOutputStream)outputStream).write(byArray, 0, n5);
                    }
                    if (this.capturingInFile && (outputStream = this.openFile()) != null) {
                        ((FileOutputStream)outputStream).write(byArray);
                    }
                }
            }
            catch (IOException iOException) {
                logger.error("Couldn't write response chunk to stream", iOException);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Unknown problem capturing response", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    private void doWrite(String string) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            try {
                if (this.capturingInFile || this.capturingInMemory) {
                    OutputStream outputStream;
                    byte[] byArray = this.toEncodedBytes(string);
                    if (this.capturingInMemory) {
                        outputStream = this.getMemoryBuffer().a();
                        int n2 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                        ((ByteArrayOutputStream)outputStream).write(byArray, 0, Math.min(byArray.length, n2));
                    }
                    if (this.capturingInFile && (outputStream = this.openFile()) != null) {
                        ((FileOutputStream)outputStream).write(byArray);
                    }
                }
            }
            catch (IOException iOException) {
                logger.error("Couldn't write response chunk to stream", iOException);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Unknown problem capturing response", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    private void doWrite(byte[] byArray) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            try {
                OutputStream outputStream;
                if (this.capturingInMemory) {
                    outputStream = this.getMemoryBuffer().a();
                    int n2 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                    ((ByteArrayOutputStream)outputStream).write(byArray, 0, Math.min(byArray.length, n2));
                }
                if (this.capturingInFile && (outputStream = this.openFile()) != null) {
                    ((FileOutputStream)outputStream).write(byArray);
                }
            }
            catch (IOException iOException) {
                logger.error("Couldn't write response chunk to stream", iOException);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Unknown problem capturing response", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    private void doWrite(char[] cArray, int n2, int n3) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            try {
                if (this.capturingInFile) {
                    FileOutputStream fileOutputStream = this.openFile();
                    for (int i2 = n2; i2 < n2 + n3; ++i2) {
                        fileOutputStream.write(cArray[i2]);
                    }
                }
                if (this.capturingInMemory) {
                    ByteArrayOutputStream byteArrayOutputStream = this.getMemoryBuffer().a();
                    for (int i3 = n2; i3 < n2 + n3; ++i3) {
                        if (byteArrayOutputStream.size() >= 65536) continue;
                        byteArrayOutputStream.write(cArray[i3]);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.error("Response write with bad indices", indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Unknown problem capturing response", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    private void doWrite(byte[] byArray, int n2, int n3) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            try {
                OutputStream outputStream;
                if (this.capturingInFile) {
                    outputStream = this.openFile();
                    ((FileOutputStream)outputStream).write(byArray, n2, n3);
                }
                if (this.capturingInMemory) {
                    outputStream = this.getMemoryBuffer().a();
                    int n4 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                    ((ByteArrayOutputStream)outputStream).write(byArray, n2, Math.min(n3, n4));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.error("Response write with bad indices", indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Unknown problem capturing response", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    private void doWrite(byte by2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            try {
                OutputStream outputStream;
                if (this.capturingInMemory && ((ByteArrayOutputStream)(outputStream = this.getMemoryBuffer().a())).size() < 65536) {
                    ((ByteArrayOutputStream)outputStream).write(by2);
                }
                if (this.capturingInFile) {
                    outputStream = this.openFile();
                    ((FileOutputStream)outputStream).write(by2);
                }
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Unknown problem capturing response", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    private void doWrite(int n2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            try {
                OutputStream outputStream;
                if (this.capturingInMemory && ((ByteArrayOutputStream)(outputStream = this.getMemoryBuffer().a())).size() < 65536) {
                    ((ByteArrayOutputStream)outputStream).write(n2);
                }
                if (this.capturingInFile && (outputStream = this.openFile()) != null) {
                    ((FileOutputStream)outputStream).write(n2);
                }
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Unknown problem capturing response", throwable2);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    public final ContrastReplacedResponseChunkModel print(String string, int n2, int n3) {
        return this.write(string, n2, n3);
    }

    public ContrastReplacedResponseChunkModel print(String string) {
        return this.write(string);
    }

    public final ContrastReplacedResponseChunkModel print(char[] cArray, int n2, int n3) {
        return this.write(cArray, n2, n3);
    }

    public final ContrastReplacedResponseChunkModel print(byte[] byArray, int n2, int n3) {
        return this.write(byArray, n2, n3);
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(char c2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            String string = String.valueOf(c2);
            this.write(string);
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(short s2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            String string = String.valueOf(s2);
            this.write(string);
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(int n2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            String string = String.valueOf(n2);
            this.write(string);
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(long l2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            String string = String.valueOf(l2);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(double d2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            String string = String.valueOf(d2);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(float f2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            String string = String.valueOf(f2);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(boolean bl2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            String string = String.valueOf(bl2);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(Object object) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            String string = String.valueOf(object);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(char[] cArray) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            String string = String.valueOf(cArray);
            ReplacedResponseChunk replacedResponseChunk = this.write(string);
            scopeAggregator.leaveScope();
            return replacedResponseChunk;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    public final ContrastReplacedResponseChunkModel println(String string) {
        ReplacedResponseChunk replacedResponseChunk = this.write(string);
        this.write(ObjectShare.LINE_SEPARATOR);
        return replacedResponseChunk;
    }

    public ContrastReplacedResponseChunkModel println() {
        this.write(ObjectShare.LINE_SEPARATOR);
        return null;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(char c2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            this.print(c2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(short s2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            this.print(s2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(int n2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            this.print(n2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(long l2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            this.print(l2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(double d2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            this.print(d2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(float f2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            this.print(f2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(boolean bl2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            this.print(bl2);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(Object object) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            this.print(object);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(char[] cArray) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            this.print(cArray);
            this.println();
            scopeAggregator.leaveScope();
            return null;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    private byte[] toEncodedBytes(String string) throws IOException {
        String string2 = this.getCharacterEncoding();
        if (string2 == null || !this.isKnownEncoding(string2)) {
            string2 = DEFAULT_ENCODING;
        }
        return string.getBytes(string2);
    }

    private boolean isKnownEncoding(String string) {
        return Charset.isSupported(string);
    }

    public void onHeaderSet(String string2, String string3, String string4) {
        if (string2 == null || string3 == null) {
            return;
        }
        if ("Content-Disposition".equals(string2) && string3.contains("attachment")) {
            this.capturingInMemory = false;
            logger.debug("Detecting file download {} at path {}: not buffering response in memory", (Object)string3, (Object)(string4 != null ? string4 : "(unknown)"));
            return;
        }
        if ("Content-Type".equals(string2)) {
            this.contentTypeHeader = d.a(string3);
            if (this.isUntrackableContentType(string3)) {
                this.capturingInMemory = false;
                logger.debug("Detected Content-Type {} at path {}: not buffering response in memory", (Object)string3, (Object)(string4 != null ? string4 : "(unknown)"));
            }
        }
        List list = this.headers.computeIfAbsent(string2, string -> new CopyOnWriteArrayList());
        list.add(string3);
    }

    private boolean isUntrackableContentType(String string) {
        return !K.d(ALLOWED_CONTENT_TYPES, string);
    }

    @Override
    public File getFile() throws IOException {
        return FILE_BUFFER.b();
    }

    @Override
    public m getMemoryBuffer() {
        return BUFFER;
    }

    @Override
    public g getFileBuffer() {
        return FILE_BUFFER;
    }
}

