/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.instr;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.t;
import java.security.CodeSource;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

@DontObfuscate
public class InstrumentationContext {
    private String className;
    private String internalClassName;
    private Class<?> classBeingRedefined;
    private Set<String> ancestors;
    private String superClassName;
    private String[] interfaces;
    private byte[] bytecode;
    private int flags;
    private boolean lambda;
    private Class<?> lambdaTargetClass;
    private String lambdaImplMethodName;
    private boolean requiresTransforming;
    private boolean changed;
    private final Collection<String> adapters = new LinkedHashSet<String>();
    private CodeSource codeSource;
    private ClassLoader loader;

    @t
    public static InstrumentationContext newTestInstance(Class<?> clazz) {
        InstrumentationContext instrumentationContext = new InstrumentationContext();
        instrumentationContext.className = clazz.getName();
        instrumentationContext.internalClassName = instrumentationContext.className.replace('.', '/');
        instrumentationContext.superClassName = clazz.getSuperclass().getName();
        instrumentationContext.flags = clazz.getModifiers();
        instrumentationContext.ancestors = new HashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Class<?> clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Class<?>[] classArray;
            instrumentationContext.ancestors.add(clazz2.getSuperclass().getName().replace('.', '/'));
            for (Class<?> clazz3 : classArray = clazz2.getInterfaces()) {
                String string = clazz3.getName().replace('.', '/');
                hashSet.add(string);
            }
        }
        instrumentationContext.interfaces = hashSet.toArray(Empty.STRING_ARRAY);
        instrumentationContext.ancestors.addAll(hashSet);
        instrumentationContext.loader = clazz.getClassLoader();
        instrumentationContext.codeSource = clazz.getProtectionDomain().getCodeSource();
        return instrumentationContext;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public Class<?> getClassBeingRedefined() {
        return this.classBeingRedefined;
    }

    public void setClassBeingRedefined(Class<?> clazz) {
        this.classBeingRedefined = clazz;
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public void setCodeSource(CodeSource codeSource) {
        this.codeSource = codeSource;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public Set<String> getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(Set<String> set) {
        this.ancestors = set;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String string) {
        this.superClassName = string;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(String[] stringArray) {
        this.interfaces = stringArray;
    }

    public void setInternalClassName(String string) {
        this.internalClassName = string;
    }

    public String getInternalClassName() {
        return this.internalClassName;
    }

    public void setBytecode(byte[] byArray) {
        this.bytecode = byArray;
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n2) {
        this.flags = n2;
    }

    public boolean isLambda() {
        return this.lambda;
    }

    public void setLambda(boolean bl2) {
        this.lambda = bl2;
    }

    public Class<?> getLambdaTargetClass() {
        return this.lambdaTargetClass;
    }

    public void setLambdaTargetClass(Class<?> clazz) {
        this.lambdaTargetClass = clazz;
    }

    public String getLambdaImplMethodName() {
        return this.lambdaImplMethodName;
    }

    public void setLambdaImplMethodName(String string) {
        this.lambdaImplMethodName = string;
    }

    public boolean requiresTransforming() {
        return this.requiresTransforming;
    }

    public void markRequiresTransforming() {
        this.requiresTransforming = true;
    }

    public boolean didChange() {
        return this.changed;
    }

    public void markChanged() {
        this.changed = true;
    }

    public void addAdapter(String string) {
        this.adapters.add(string);
    }

    public Collection<String> getAdapters() {
        return this.adapters;
    }

    public String toString() {
        return "InstrumentationContext{className='" + this.className + '\'' + ", changed=" + this.changed + ", adapters=" + this.adapters + '}';
    }
}

