/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.activity.protect.details;

import com.contrastsecurity.agent.commons.Sets;
import java.util.Set;

public final class UserInputDTM {
    private final Set<String> filters;
    private final String name;
    private final String value;
    private final long time;
    private final InputType type;
    private final InputDocumentType documentType;
    private final String documentPath;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UserInputDTM userInputDTM) {
        return new Builder(userInputDTM);
    }

    public static UserInputDTM copy(UserInputDTM userInputDTM) {
        return UserInputDTM.builder().documentPath(userInputDTM.documentPath).documentType(userInputDTM.documentType).filters(userInputDTM.filters).name(userInputDTM.name).time(userInputDTM.time).type(userInputDTM.type).value(userInputDTM.value).build();
    }

    private UserInputDTM(Builder builder) {
        this.filters = builder.filters != null ? Sets.copy(builder.filters) : null;
        this.name = builder.name;
        this.value = builder.value;
        this.time = builder.time;
        this.type = builder.type;
        this.documentType = builder.documentType;
        this.documentPath = builder.documentPath;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public long getTime() {
        return this.time;
    }

    public InputType getType() {
        return this.type;
    }

    public Set<String> getFilters() {
        return this.filters;
    }

    public String getVector() {
        return this.type != null && this.type.isNameBased() ? this.name : this.value;
    }

    public InputDocumentType getDocumentType() {
        return this.documentType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UserInputDTM userInputDTM = (UserInputDTM)object;
        if (this.time != userInputDTM.time) {
            return false;
        }
        if (this.filters != null ? !this.filters.equals(userInputDTM.filters) : userInputDTM.filters != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(userInputDTM.name) : userInputDTM.name != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(userInputDTM.value) : userInputDTM.value != null) {
            return false;
        }
        if (this.type != userInputDTM.type) {
            return false;
        }
        if (this.documentType != userInputDTM.documentType) {
            return false;
        }
        return this.documentPath != null ? this.documentPath.equals(userInputDTM.documentPath) : userInputDTM.documentPath == null;
    }

    public int hashCode() {
        int n2 = this.filters != null ? this.filters.hashCode() : 0;
        n2 = 31 * n2 + (this.filters != null ? this.filters.hashCode() : 0);
        n2 = 31 * n2 + (this.name != null ? this.name.hashCode() : 0);
        n2 = 31 * n2 + (this.value != null ? this.value.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.time ^ this.time >>> 32);
        n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
        n2 = 31 * n2 + (this.documentType != null ? this.documentType.hashCode() : 0);
        n2 = 31 * n2 + (this.documentPath != null ? this.documentPath.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "UserInputDTM{filters=" + this.filters + ", name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", time=" + this.time + ", type=" + (Object)((Object)this.type) + ", documentType=" + (Object)((Object)this.documentType) + ", documentPath='" + this.documentPath + '\'' + '}';
    }

    public static final class Builder {
        private Set<String> filters;
        private String name;
        private String value;
        private long time = System.currentTimeMillis();
        private InputType type;
        private InputDocumentType documentType;
        private String documentPath;

        private Builder() {
        }

        private Builder(UserInputDTM userInputDTM) {
            this.filters = userInputDTM.filters;
            this.name = userInputDTM.name;
            this.value = userInputDTM.value;
            this.time = userInputDTM.time;
            this.type = userInputDTM.type;
            this.documentType = userInputDTM.documentType;
            this.documentPath = userInputDTM.documentPath;
        }

        public UserInputDTM build() {
            return new UserInputDTM(this);
        }

        public Builder filters(Set<String> set) {
            this.filters = set;
            return this;
        }

        public Builder name(String string) {
            this.name = string;
            return this;
        }

        public Builder value(String string) {
            this.value = string;
            return this;
        }

        public Builder time(long l2) {
            this.time = l2;
            return this;
        }

        public Builder type(InputType inputType) {
            this.type = inputType;
            return this;
        }

        public Builder documentType(InputDocumentType inputDocumentType) {
            this.documentType = inputDocumentType;
            return this;
        }

        public Builder documentPath(String string) {
            this.documentPath = string;
            return this;
        }
    }

    public static enum InputType {
        BODY("HTTP Request Body"),
        COOKIE_NAME("HTTP Request Cookie Name"),
        COOKIE_VALUE("HTTP Request Cookie Value"),
        HEADER("HTTP Request Header"),
        PARAMETER_NAME("HTTP Request Parameter"),
        PARAMETER_VALUE("HTTP Request Parameter"),
        QUERYSTRING("HTTP Request Query String"),
        URI("URI"),
        SOCKET("Socket"),
        JSON_VALUE("JSON Value"),
        JSON_ARRAYED_VALUE("JSON Array Value"),
        MULTIPART_CONTENT_TYPE("Multipart Content Type"),
        MULTIPART_VALUE("Multipart Body"),
        MULTIPART_FIELD_NAME("Multipart Field Name"),
        MULTIPART_NAME("Multipart File Name"),
        XML_VALUE("XML Value"),
        DWR_VALUE("DWR Parameter"),
        UNKNOWN("(unknown)"),
        METHOD("Method"),
        REQUEST("Request");

        private final String logName;

        private InputType(String string2) {
            this.logName = string2;
        }

        public String logName() {
            return this.logName;
        }

        public boolean isNameBased() {
            return PARAMETER_NAME == this || COOKIE_NAME == this;
        }
    }

    public static enum InputDocumentType {
        JSON,
        XML,
        NORMAL;

    }
}

