/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.routes;

import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.thirdparty.com.google.gson.JsonDeserializationContext;
import com.contrastsecurity.thirdparty.com.google.gson.JsonDeserializer;
import com.contrastsecurity.thirdparty.com.google.gson.JsonElement;
import com.contrastsecurity.thirdparty.com.google.gson.JsonNull;
import com.contrastsecurity.thirdparty.com.google.gson.JsonParseException;
import com.contrastsecurity.thirdparty.com.google.gson.JsonPrimitive;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializationContext;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializer;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.JsonAdapter;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class DiscoveredRoute {
    @SerializedName(value="verb")
    private final RequestMethod requestMethod;
    private final String url;
    private final String signature;
    private final String applicationContextPath;
    @JsonAdapter(value=FrameworkSerializerDeserializer.class)
    private final Framework framework;

    private DiscoveredRoute(Builder builder) {
        this.requestMethod = Objects.requireNonNull(builder.requestMethod);
        this.url = Objects.requireNonNull(builder.url).startsWith("/") ? builder.url : "/" + builder.url;
        this.signature = Objects.requireNonNull(builder.signature);
        this.framework = Objects.requireNonNull(builder.framework);
        this.applicationContextPath = builder.applicationContextPath;
    }

    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    public RequestMethod requestMethod() {
        return this.requestMethod;
    }

    public String url() {
        return this.url;
    }

    public String signature() {
        return this.signature;
    }

    public Framework framework() {
        return this.framework;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DiscoveredRoute discoveredRoute = (DiscoveredRoute)object;
        return this.requestMethod == discoveredRoute.requestMethod && Objects.equals(this.url, discoveredRoute.url) && Objects.equals(this.signature, discoveredRoute.signature) && this.framework == discoveredRoute.framework;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestMethod, this.url, this.signature, this.framework});
    }

    public String toString() {
        return "DiscoveredRoute{requestMethod=" + (Object)((Object)this.requestMethod) + ", uri='" + this.url + '\'' + ", signature='" + this.signature + '\'' + ", applicationContextPath='" + this.applicationContextPath + '\'' + ", framework=" + (Object)((Object)this.framework) + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class FrameworkSerializerDeserializer
    implements JsonDeserializer<Framework>,
    JsonSerializer<Framework> {
        private FrameworkSerializerDeserializer() {
        }

        @Override
        public Framework deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement == null || !jsonElement.isJsonPrimitive()) {
                return null;
            }
            return Framework.findByDisplayName(jsonElement.getAsString());
        }

        @Override
        public JsonElement serialize(Framework framework, Type type, JsonSerializationContext jsonSerializationContext) {
            if (framework == null) {
                return JsonNull.INSTANCE;
            }
            return new JsonPrimitive(framework.toString());
        }
    }

    public static enum Framework {
        AKKA_HTTP("Akka HTTP"),
        GRPC("gRPC"),
        HTTP4K("http4k"),
        SERVLET("Servlet"),
        JERSEY("Jersey"),
        JSF("Java Server Faces"),
        JSP("Java Server Pages"),
        MULESOFT("Mulesoft"),
        RESTEASY("RESTEasy"),
        SCALA_PLAY("Play/Scala"),
        SPRING_MVC("Spring MVC"),
        SPRING_WEBFLUX("Spring Webflux"),
        STRUTS_1("Struts 1"),
        STRUTS_2("Struts 2");

        private final String displayName;
        private static final Map<String, Framework> MAP;

        private Framework(String string2) {
            this.displayName = string2;
        }

        static Framework findByDisplayName(String string) {
            return MAP.get(string);
        }

        public String toString() {
            return this.displayName;
        }

        static {
            MAP = new HashMap<String, Framework>();
            for (Framework framework : Framework.values()) {
                MAP.put(framework.toString(), framework);
            }
        }
    }

    public static final class Builder {
        private RequestMethod requestMethod;
        private String url;
        private String signature;
        private Framework framework;
        private String applicationContextPath;

        public Builder framework(Framework framework) {
            this.framework = framework;
            return this;
        }

        public Builder requestMethod(RequestMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder url(String string) {
            this.url = string;
            return this;
        }

        public Builder signature(String string) {
            this.signature = string;
            return this;
        }

        public Builder applicationContextPath(String string) {
            this.applicationContextPath = string;
            return this;
        }

        public DiscoveredRoute build() {
            return new DiscoveredRoute(this);
        }
    }
}

