/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.architecture.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.plugins.architecture.ApplicationArchitecture;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.services.a.f;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Optional;
import java.util.function.Supplier;

@DontObfuscate
public final class ArchitectureComponentReporter {
    public static final ExecutionContext.b<ApplicationArchitecture> KEY = ExecutionContext.b.a(ApplicationArchitecture.class);
    private final Optional<f<ArchitectureComponent>> reporter;
    private static final Supplier<ApplicationArchitecture> APPLICATION_ARCHITECTURE_FACTORY = ApplicationArchitecture::create;
    private static final Logger logger = LoggerFactory.getLogger(ArchitectureComponentReporter.class);

    @Inject
    public ArchitectureComponentReporter(Optional<f<ArchitectureComponent>> optional) {
        this.reporter = optional;
    }

    public void report(Application application, ArchitectureComponent architectureComponent) {
        ApplicationArchitecture applicationArchitecture = application.context().getOrComputeIfAbsent(KEY, APPLICATION_ARCHITECTURE_FACTORY);
        if (architectureComponent == null) {
            logger.debug("Discovered architecture component was null, not sending report");
            return;
        }
        if (applicationArchitecture.addComponent(architectureComponent)) {
            logger.debug("Sending newly discovered architecture component: {}", (Object)architectureComponent);
            application.getActivity().addArchitecture(architectureComponent);
            application.markDirty();
            this.reporter.ifPresent(f2 -> f2.report(application, architectureComponent));
        }
    }
}

