/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.j2ee;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpRequestFactory;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.J2EEClassCache;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

@DontObfuscate
public final class J2EEHttpRequestFactory
implements HttpRequestFactory {
    private final WeakReference<Object> originalRequest;
    private final String queryString;
    private final String uri;
    private final String method;
    private final String protocol;
    private final String contextPath;
    private final String remoteIP;
    private final boolean isSecure;
    private final int serverPort;
    private final Enumeration<?> headerNames;
    private final boolean isAssessEnabled;
    private final J2EEClassCache classCache;
    private final String serverVersionInfo;
    private static final Map<String, String> HEADER_VALUE_MAP = Maps.builder().add("Keep-Alive", "Keep-Alive").add("keep-alive", "keep-alive").add("$Version=1", "$Version=1").add("gzip,deflate", "gzip,deflate").add("gzip, deflate", "gzip, deflate").add("gzip, deflate, sdch", "gzip, deflate, sdch").add("application/x-www-form-urlencoded", "application/x-www-form-urlencoded").add("*/*", "*/*").add("max-age=0", "max-age=0").add("https", "https").add("close", "close").add("0", "0").add("1", "1").add("443", "443").add("text/json", "text/json").add("text/xml", "text/xml").add("application/json", "application/json").add("application/xml", "application/xml").build();
    private static final Map<String, String> HEADER_NAME_MAP = Maps.builder().add("accept", "accept").add("Accept", "Accept").add("accept-charset", "accept-charset").add("Accept-Charset", "Accept-Charset").add("accept-language", "accept-language").add("Accept-Language", "Accept-Language").add("accept-encoding", "accept-encoding").add("Accept-Encoding", "Accept-Encoding").add("authorization", "authorization").add("Authorization", "Authorization").add("cache-control", "cache-control").add("Cache-Control", "Cache-Control").add("cookie", "cookie").add("Cookie", "Cookie").add("connection", "connection").add("Connection", "Connection").add("content-encoding", "content-encoding").add("Content-Encoding", "Content-Encoding").add("content-length", "content-length").add("Content-Length", "Content-Length").add("content-type", "content-type").add("Content-Type", "Content-Type").add("date", "date").add("Date", "Date").add("expect", "expect").add("Expect", "Expect").add("host", "host").add("Host", "Host").add("if-match", "if-match").add("If-Match", "If-Match").add("if-none-match", "if-none-match").add("If-None-Match", "If-None-Match").add("if-modified-since", "if-modified-since").add("If-Modified-Since", "If-Modified-Since").add("if-unmodified-since", "if-unmodified-since").add("If-Unmodified-Since", "If-Unmodified-Since").add("origin", "origin").add("Origin", "Origin").add("pragma", "pragma").add("Pragma", "Pragma").add("referer", "referer").add("Referer", "Referer").add("user-agent", "User-Agent").add("User-Agent", "User-Agent").add("x-request-with", "x-requested-with").add("X-Requested-With", "X-Requested-With").add("x-forwarded-for", "x-forwarded-for").add("X-Forwarded-For", "X-Forwarded-For").build();
    private static final Map<String, String[]> STUB_PARAMETERS = Collections.singletonMap("=N/A", Empty.STRING_ARRAY);
    private static final Logger logger = LoggerFactory.getLogger(J2EEHttpRequestFactory.class);

    public J2EEHttpRequestFactory(Object object, Object object2, String string, String string2, String string3, String string4, String string5, String string6, boolean bl2, int n2, Enumeration<?> enumeration, boolean bl3, J2EEClassCache j2EEClassCache) {
        this.originalRequest = new WeakReference<Object>(object);
        this.queryString = string;
        this.uri = string2;
        this.method = string3;
        this.protocol = string4;
        this.contextPath = string5;
        this.remoteIP = string6;
        this.isSecure = bl2;
        this.serverPort = n2;
        this.headerNames = enumeration;
        this.isAssessEnabled = bl3;
        this.classCache = j2EEClassCache;
        this.serverVersionInfo = J2EEHttpRequestFactory.getServerInfo(object2, j2EEClassCache);
    }

    public String serverVersionInfo() {
        return this.serverVersionInfo;
    }

    @Override
    public HttpRequest newInstance() {
        HttpRequest httpRequest = new HttpRequest(HttpRequest.HttpRequestType.J2EE);
        httpRequest.setOriginalRequest(this.originalRequest);
        httpRequest.setQueryString(this.queryString);
        httpRequest.setUri(this.uri);
        httpRequest.setMethod(this.method);
        httpRequest.setProtocol(this.protocol);
        httpRequest.setContextPath(this.contextPath);
        httpRequest.setRemoteIp(this.remoteIP);
        httpRequest.setSecure(this.isSecure);
        httpRequest.setPort(this.serverPort);
        httpRequest.setHeaders(J2EEHttpRequestFactory.getHeaders(this.originalRequest.get(), this.headerNames, this.isAssessEnabled, this.classCache));
        httpRequest.setVersion(httpRequest.getHeader("Host") != null ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0);
        httpRequest.setParameters(STUB_PARAMETERS);
        httpRequest.setServerVersionInfo(this.serverVersionInfo);
        return httpRequest;
    }

    private static Map<String, String[]> getHeaders(Object object, Enumeration<?> enumeration, boolean bl2, J2EEClassCache j2EEClassCache) {
        try {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            Class<?> clazz = object.getClass();
            Method method = j2EEClassCache.getGetHeadersMethod(clazz);
            Object[] objectArray = new Object[1];
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                objectArray[0] = string;
                Enumeration enumeration2 = AccessController.doPrivileged(() -> (Enumeration)method.invoke(object, objectArray));
                ArrayList<String> arrayList = new ArrayList<String>();
                while (enumeration2.hasMoreElements()) {
                    String string2 = (String)enumeration2.nextElement();
                    if (bl2) {
                        string2 = J2EEHttpRequestFactory.tryShareHeaderValue(string2);
                    }
                    arrayList.add(string2);
                }
                if (bl2) {
                    string = J2EEHttpRequestFactory.tryShareHeaderName(string);
                }
                hashMap.put(string, arrayList.toArray(new String[0]));
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Error parsing headers from request", throwable2);
            return null;
        }
    }

    private static String tryShareHeaderName(String string) {
        return HEADER_NAME_MAP.getOrDefault(string, new String(string));
    }

    private static String tryShareHeaderValue(String string) {
        return HEADER_VALUE_MAP.getOrDefault(string, new String(string));
    }

    private static String getServerInfo(Object object, J2EEClassCache j2EEClassCache) {
        if (object == null) {
            return null;
        }
        try {
            Class<?> clazz = object.getClass();
            Method method = j2EEClassCache.getGetServerInfoMethod(clazz);
            return AccessController.doPrivileged(() -> (String)method.invoke(object, Empty.OBJ_ARRAY));
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Failed to parse request data into ServletContext", throwable2);
            return null;
        }
    }
}

