/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.ldap;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.g;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.plugins.architecture.controller.ArchitectureComponentReporter;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.architecture.util.ArchitectureScope;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;

@Singleton
@DontObfuscate
public final class ContrastLdapQueryDispatcherImpl
implements ContrastLdapQueryDispatcher {
    private final e config;
    private final ApplicationManager applicationManager;
    private final ArchitectureComponentReporter architectureComponentReporter;
    private static final Logger logger = LoggerFactory.getLogger(ContrastLdapQueryDispatcherImpl.class);

    @Inject
    public ContrastLdapQueryDispatcherImpl(e e2, ApplicationManager applicationManager, ArchitectureComponentReporter architectureComponentReporter) {
        this.config = e2;
        this.applicationManager = applicationManager;
        this.architectureComponentReporter = architectureComponentReporter;
    }

    public void onLdapQuerying(Hashtable<?, ?> hashtable) {
        if (ArchitectureScope.getTrackerScope().inScope() || ArchitectureScope.getSamplerScope().inScope()) {
            return;
        }
        Application application = this.applicationManager.current();
        if (application == null || hashtable == null) {
            return;
        }
        String string = (String)hashtable.get("java.naming.provider.url");
        if (StringUtils.isEmpty(string)) {
            return;
        }
        this.parseProviderUrl(application, string);
    }

    @t
    void parseProviderUrl(Application application, String string) {
        if (!g.a(this.config, ConfigProperty.INVENTORY_MONITOR_LDAP)) {
            return;
        }
        if (string == null) {
            logger.debug("Invalid LDAP URL: NULL");
            return;
        }
        for (String string2 : StringUtils.split(string, " ,")) {
            try {
                URI uRI = new URI(string2);
                String string3 = uRI.getScheme();
                if (StringUtils.equalsIgnoreCase("ldap", string3) || StringUtils.equalsIgnoreCase("ldaps", string3)) {
                    String string4 = uRI.getHost();
                    String string5 = String.valueOf(uRI.getPort());
                    this.architectureComponentReporter.report(application, ArchitectureComponent.ldapFrom(string2, string4, string5));
                    continue;
                }
                logger.debug("Invalid LDAP URL: {}", (Object)string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.debug("Invalid LDAP URL: {}", (Object)string2, (Object)uRISyntaxException);
            }
        }
    }
}

