/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.sql;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.g;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.plugins.architecture.controller.ArchitectureComponentReporter;
import com.contrastsecurity.agent.plugins.architecture.controller.f;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.frameworks.sql.DbInfo;
import com.contrastsecurity.agent.plugins.frameworks.sql.SqlDatabaseInfoCache;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;

@Singleton
@DontObfuscate
public final class ContrastSqlDispatcherImpl
implements ContrastSqlDispatcher {
    private final ApplicationManager applicationManager;
    private final List<f> statementListeners;
    private final ScopeProvider scopeProvider;
    private final ArchitectureComponentReporter reporter;
    private final e config;
    private final SqlDatabaseInfoCache sqlDatabaseInfoCache;
    private static final Logger logger = LoggerFactory.getLogger(ContrastSqlDispatcherImpl.class);

    @Inject
    ContrastSqlDispatcherImpl(ApplicationManager applicationManager, ScopeProvider scopeProvider, ArchitectureComponentReporter architectureComponentReporter, List<f> list, e e2, SqlDatabaseInfoCache sqlDatabaseInfoCache) {
        this.applicationManager = applicationManager;
        this.statementListeners = list;
        this.scopeProvider = scopeProvider;
        this.reporter = architectureComponentReporter;
        this.config = e2;
        this.sqlDatabaseInfoCache = sqlDatabaseInfoCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSqlStatementExecuting(Object object, Class<?> clazz, Object[] objectArray) {
        Application application = this.applicationManager.current();
        if (application == null) {
            return;
        }
        this.reportArchitectureComponent(application, object);
        ScopeAggregator scopeAggregator = this.scopeProvider.enterScope();
        try {
            for (f f2 : this.statementListeners) {
                f2.a(application, clazz, objectArray);
            }
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Problem issuing SQL event to listener", throwable2);
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    private void reportArchitectureComponent(Application application, Object object) {
        Connection connection;
        if (!g.a(this.config, ConfigProperty.DBINSPECTION) || !(object instanceof Statement)) {
            return;
        }
        try {
            connection = ((Statement)object).getConnection();
        }
        catch (SQLException sQLException) {
            logger.debug("Failed to extract SQL connection from Statement", sQLException);
            return;
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            RuntimeException runtimeException2 = runtimeException;
            logger.debug("Failed to extract SQL connection from Statement", runtimeException2);
            return;
        }
        if (connection == null) {
            logger.debug("Obtained a null connection from java.sql.Statement of type {}", (Object)object.getClass());
            return;
        }
        DbInfo dbInfo = this.sqlDatabaseInfoCache.get(connection);
        if (dbInfo == null) {
            logger.debug("Found undetected DB connection of type {} in use", (Object)connection.getClass());
            return;
        }
        String string = dbInfo.host();
        string = string == null && "mem".equals(dbInfo.subtype()) ? "In Memory (alias): " + dbInfo.name() : "In Memory (alias): localhost";
        String string2 = dbInfo.port() == null ? "(unknown)" : String.valueOf(dbInfo.port());
        String string3 = dbInfo.url();
        ArchitectureComponent architectureComponent = ArchitectureComponent.databaseFrom(string3, string, string2);
        if (architectureComponent == null) {
            logger.debug("Cannot profile the database because we were unable to identify the architecture component: {}", (Object)string3);
            return;
        }
        this.reporter.report(application, architectureComponent);
    }

    public void connect(Object object, String string, Object object2) {
        if (g.a(this.config, ConfigProperty.DBINSPECTION) || this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            this.sqlDatabaseInfoCache.computeIfAbsent((Connection)object, string, (Properties)object2);
        }
    }
}

