/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.sql;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.plugins.frameworks.sql.DbInfo;
import com.contrastsecurity.agent.plugins.frameworks.sql.c;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;

@Singleton
@DontObfuscate
public class SqlDatabaseInfoCache {
    private final Map<Connection, DbInfo> cache = new ConcurrentReferenceHashMap<Connection, DbInfo>();
    private static final Logger logger = LoggerFactory.getLogger(SqlDatabaseInfoCache.class);

    @Inject
    public SqlDatabaseInfoCache() {
    }

    public DbInfo get(Connection connection) {
        DbInfo dbInfo = this.cache.get(connection);
        if (dbInfo != null) {
            return dbInfo;
        }
        try {
            if (connection.isWrapperFor(Connection.class)) {
                connection = connection.unwrap(Connection.class);
            }
            dbInfo = this.cache.get(connection);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Error unwrapping SQL connection", throwable2);
        }
        return dbInfo;
    }

    DbInfo computeIfAbsent(Connection connection2, String string, Properties properties) {
        DbInfo dbInfo = this.cache.computeIfAbsent(connection2, connection -> c.a(string, properties));
        if (dbInfo == null) {
            logger.debug("Could not parse database url {}", (Object)string);
        }
        return dbInfo;
    }
}

