/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.xenon;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpRequestFactory;
import com.contrastsecurity.agent.http.i;
import com.contrastsecurity.agent.http.o;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Protocol;
import com.contrastsecurity.agent.reflection.a;
import com.contrastsecurity.agent.util.D;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@DontObfuscate
final class XenonHttpRequestFactory
implements HttpRequestFactory {
    private final WeakReference<Object> originalRequest;
    private final String methodName;
    private final i frameworkInfo;
    private static final Map<String, String> METHOD_NAME_MAP = new HashMap<String, String>();
    private static final String PROBLEM_REGENERATING_BODY_INPUT = "xenonProbBodyRegen";
    private static final String PROBLEM_REFLECTING_BODY = "xenonProbRefBody";
    private static final String PROBLEM_REFLECTING_URI = "xenonProbRefUri";
    private static final String PROBLEM_REFLECTING_HEADERS = "xenonProbRefHeaders";
    private static final Logger logger;

    XenonHttpRequestFactory(Object object, String string, i i2) {
        this.originalRequest = new WeakReference<Object>(object);
        this.methodName = string;
        this.frameworkInfo = i2;
    }

    @Override
    public HttpRequest newInstance() {
        Object t2 = Objects.requireNonNull(this.originalRequest.get());
        HttpRequest httpRequest = new HttpRequest(HttpRequest.HttpRequestType.XENON);
        httpRequest.setOriginalRequest(this.originalRequest);
        Class<?> clazz = t2.getClass();
        URI uRI = XenonHttpRequestFactory.reflectUri(t2, clazz);
        Map<String, String[]> map = XenonHttpRequestFactory.reflectHeaders(t2, clazz);
        httpRequest.setUri(uRI.getPath());
        httpRequest.setQueryString(uRI.getRawQuery());
        httpRequest.setPort(uRI.getPort());
        httpRequest.setServerVersionInfo("Xenon/Unknown");
        httpRequest.setProtocol(Protocol.HTTP);
        httpRequest.setContextPath("/");
        httpRequest.setHeaders(map);
        httpRequest.setMethod(XenonHttpRequestFactory.parseMethod(this.methodName));
        httpRequest.setVersion(HttpVersion.HTTP_1_1);
        httpRequest.setFrameworkInfo(this.frameworkInfo);
        httpRequest.setCachedBody(XenonHttpRequestFactory.handleRequestBody(t2, clazz, httpRequest.getCharset()));
        String string = httpRequest.getQueryString();
        Map<String, String[]> map2 = !StringUtils.isEmpty(string) ? o.a(string) : new HashMap<String, String[]>();
        httpRequest.setParameters(map2);
        httpRequest.resolvedParameters();
        return httpRequest;
    }

    private static URI reflectUri(Object object, Class<?> clazz) {
        URI uRI = null;
        try {
            Method method = a.f(clazz, "getUri");
            uRI = (URI)method.invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            com.contrastsecurity.agent.logging.a.a(PROBLEM_REFLECTING_URI, logger, "Problem reflecting URI", throwable2);
            try {
                uRI = new URI("");
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.error("Problem creating default uri", throwable2);
            }
        }
        return uRI;
    }

    private static Map<String, String[]> reflectHeaders(Object object, Class<?> clazz) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        try {
            Method method = a.f(clazz, "getRequestHeaders");
            Map map = (Map)method.invoke(object, new Object[0]);
            for (String string : map.keySet()) {
                String string2 = (String)map.get(string);
                hashMap.put(string, new String[]{string2});
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            com.contrastsecurity.agent.logging.a.a(PROBLEM_REFLECTING_HEADERS, logger, "Problem reflecting headers", throwable2);
        }
        return hashMap;
    }

    private static String parseMethod(String string) {
        String string2 = METHOD_NAME_MAP.get(string);
        if (string2 == null) {
            string2 = "GET";
        }
        return string2;
    }

    private static D handleRequestBody(Object object, Class<?> clazz, Charset charset) {
        Object object2;
        Object object3;
        block8: {
            object3 = a.f(clazz, "getBodyRaw");
            object2 = ((Method)object3).invoke(object, Empty.OBJ_ARRAY);
            if (object2 == null) {
                logger.debug("Body was null");
                return null;
            }
            logger.debug("Body of type {}", (Object)object2.getClass().getName());
            if (object2 instanceof String) {
                byte[] byArray = ((String)object2).getBytes();
                return new D(byArray, byArray.length, charset);
            }
            if (object2 instanceof byte[]) {
                byte[] byArray = (byte[])object2;
                return new D(byArray, byArray.length, charset);
            }
            if (!(object2 instanceof D)) break block8;
            return (D)object2;
        }
        try {
            byte[] byArray = ObjectShare.PRETTY_GSON.toJson(object2).getBytes();
            return new D(byArray, byArray.length, charset);
        }
        catch (Throwable throwable) {
            try {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                com.contrastsecurity.agent.logging.a.a(PROBLEM_REGENERATING_BODY_INPUT, logger, "Problem regenerating body input", throwable2);
            }
            catch (Throwable throwable3) {
                Throwables.throwIfCritical(throwable3);
                object3 = throwable3;
                com.contrastsecurity.agent.logging.a.a(PROBLEM_REFLECTING_BODY, logger, "Problem reflecting body", (Throwable)object3);
            }
        }
        return null;
    }

    static {
        METHOD_NAME_MAP.put("handlePut", "PUT");
        METHOD_NAME_MAP.put("handlePost", "POST");
        METHOD_NAME_MAP.put("handleStart", "POST");
        METHOD_NAME_MAP.put("handlePatch", "PATCH");
        METHOD_NAME_MAP.put("handleDelete", "DELETE");
        METHOD_NAME_MAP.put("handleHead", "HEAD");
        METHOD_NAME_MAP.put("handleGet", "GET");
        logger = LoggerFactory.getLogger(XenonHttpRequestFactory.class);
    }
}

