/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.commons.b;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.deadzone.g;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;

@Singleton
@DontObfuscate
public class ObserveRootSpanManager
implements Purgeable {
    public static final long OBSERVE_CONTEXT_TTL_MS = 15000L;
    private static final ThreadLocal<RootSpan> CURRENT_ROOT_SPAN = ThreadLocal.withInitial(() -> null);
    private final b clock;
    private final ApplicationManager applicationManager;
    private final e config;
    private final g deadzoneManager;

    @Inject
    public ObserveRootSpanManager(b b2, ApplicationManager applicationManager, e e2, g g2) {
        this.clock = b2;
        this.applicationManager = applicationManager;
        this.config = e2;
        this.deadzoneManager = g2;
    }

    public RootSpan createNewRootSpan(HttpRequest httpRequest) {
        Application application = this.applicationManager.current();
        if (application == null) {
            return null;
        }
        RootSpan rootSpan = new RootSpan(application.otel().b(), this.clock, httpRequest, this.config, this.deadzoneManager, this.applicationManager.current().otel().a());
        CURRENT_ROOT_SPAN.set(rootSpan);
        return rootSpan;
    }

    public RootSpan currentRootSpan() {
        return CURRENT_ROOT_SPAN.get();
    }

    public void currentRootSpan(RootSpan rootSpan) {
        CURRENT_ROOT_SPAN.set(rootSpan);
    }

    @Override
    public void purgeStale() {
        if (this.isStale(CURRENT_ROOT_SPAN.get())) {
            CURRENT_ROOT_SPAN.set(null);
        }
    }

    @Override
    public int purgeableCount() {
        return this.isStale(CURRENT_ROOT_SPAN.get()) ? 1 : 0;
    }

    private boolean isStale(RootSpan rootSpan) {
        if (rootSpan == null) {
            return false;
        }
        return this.clock.now() - rootSpan.getStartTimeMs() > 15000L;
    }
}

