/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.java.j2ee;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.i;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.com.contrastsecurity.secobs.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;

@Singleton
@DontObfuscate
public class ContrastObserveJ2EEAuthDispatcherImpl
implements ContrastObserveJ2EEAuthDispatcher {
    final e config;
    final HttpManager httpManager;
    final ApplicationManager applicationManager;
    final ScopeProvider scopeProvider;
    final ObserveRootSpanManager rootSpanManager;

    @Inject
    ContrastObserveJ2EEAuthDispatcherImpl(e e2, HttpManager httpManager, ApplicationManager applicationManager, ScopeProvider scopeProvider, ObserveRootSpanManager observeRootSpanManager) {
        this.config = e2;
        this.httpManager = httpManager;
        this.applicationManager = applicationManager;
        this.scopeProvider = scopeProvider;
        this.rootSpanManager = observeRootSpanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAuthentication(String string) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return;
        }
        try {
            RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
            if (rootSpan == null || !rootSpan.isRecording()) {
                return;
            }
            Application application = this.applicationManager.current();
            if (application == null) {
                return;
            }
            Span span = rootSpan.startChildSpan("authn-request", string);
            if (span == null) {
                return;
            }
            span.end();
            application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authn-request", ContrastSemanticAttributes.HTTP_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.root()));
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRoleBasedAuthorization(String string, String string2) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return;
        }
        try {
            RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
            if (rootSpan == null || !rootSpan.isRecording()) {
                return;
            }
            Application application = this.applicationManager.current();
            if (application == null) {
                return;
            }
            Span span = rootSpan.startChildSpan("authz-request", string2);
            if (span == null) {
                return;
            }
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_MECHANISM, "rbac");
            span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_RBAC_ROLE, string);
            span.end();
            application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authz-request", ContrastSemanticAttributes.HTTP_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.root()));
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }
}

