/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.observe.spring;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.f;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.observe.a.a;
import com.contrastsecurity.agent.plugins.observe.i;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.com.contrastsecurity.secobs.semconv.ContrastSemanticAttributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import java.util.Collection;

@Singleton
@DontObfuscate
public class ContrastObserveSpringAuthzDispatcherImpl
implements ContrastObserveSpringAuthzDispatcher {
    final e config;
    final HttpManager httpManager;
    final ApplicationManager applicationManager;
    final ScopeProvider scopeProvider;
    final ObserveRootSpanManager rootSpanManager;
    private String ROLE_PREFIX = "ROLE_";

    @Inject
    ContrastObserveSpringAuthzDispatcherImpl(e e2, HttpManager httpManager, ApplicationManager applicationManager, ScopeProvider scopeProvider, ObserveRootSpanManager observeRootSpanManager) {
        this.config = e2;
        this.httpManager = httpManager;
        this.applicationManager = applicationManager;
        this.scopeProvider = scopeProvider;
        this.rootSpanManager = observeRootSpanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAuthorizationCheck(String string) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return;
        }
        try {
            if (this.httpManager.getCurrentRequest() == null || this.applicationManager.current() == null) {
                return;
            }
            f f2 = this.httpManager.getCurrentRequest().context();
            if (f2.get(RootSpan.AUTHZ_CONTEXT_KEY) != null) {
                return;
            }
            a a2 = a.a().a(string).b("authz-request").a(this.applicationManager.current()).a();
            f2.put(RootSpan.AUTHZ_CONTEXT_KEY, a2);
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRouteAuthorization(Collection<String> collection, String string) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return;
        }
        try {
            if (this.httpManager.getCurrentRequest() == null || this.applicationManager.current() == null) {
                return;
            }
            a.a a2 = a.a().a(string).b("authz-request").a(this.applicationManager.current());
            if (collection != null && !collection.isEmpty()) {
                a2.a(collection);
            }
            this.httpManager.getCurrentRequest().context().put(RootSpan.AUTHZ_CONTEXT_KEY, a2.a());
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHasAnyAuthorityName(String string, String[] stringArray, String string2) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return;
        }
        try {
            Application application = this.applicationManager.current();
            if (application == null) {
                return;
            }
            RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
            if (rootSpan != null && rootSpan.isRecording()) {
                Span span = rootSpan.startChildSpan("authz-request", string2);
                if (span == null) {
                    return;
                }
                if (string.equals(this.ROLE_PREFIX) && stringArray != null && stringArray.length > 0) {
                    span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_MECHANISM, "rbac");
                    span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_RBAC_ROLE, String.join((CharSequence)", ", stringArray));
                }
                span.end();
                application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authz-request", ContrastSemanticAttributes.HTTP_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.root()));
            }
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPermissionsCheck(Object object, String string) {
        if (!this.config.c(ConfigProperty.OBSERVE_ENABLE)) {
            return;
        }
        ScopeAggregator scopeAggregator = i.a(this.scopeProvider);
        if (scopeAggregator == null) {
            return;
        }
        try {
            Application application = this.applicationManager.current();
            if (application == null) {
                return;
            }
            RootSpan rootSpan = this.rootSpanManager.currentRootSpan();
            if (rootSpan != null && rootSpan.isRecording()) {
                Span span = rootSpan.startChildSpan("authz-request", string);
                if (span == null) {
                    return;
                }
                if (object instanceof String) {
                    span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_MECHANISM, "dac");
                    span.setAttribute(ContrastSemanticAttributes.CONTRAST_AUTHORIZATION_DAC_PERMISSION, (String)object);
                }
                span.end();
                application.otel().c().add(1L, Attributes.of(ContrastSemanticAttributes.ACTION, "authz-request", ContrastSemanticAttributes.HTTP_METHOD, rootSpan.getHttpMethod(), ContrastSemanticAttributes.HTTP_ROUTE, rootSpan.getHttpRoute()), span.storeInContext(Context.root()));
            }
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }
}

