/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.commons.Iterators;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsProtectDTM;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.messages.app.settings.protect.CommonConfigProtectionMode;
import com.contrastsecurity.agent.messages.app.settings.protect.ProtectionModeDTM;
import com.contrastsecurity.agent.messages.server.features.protect.LogEnhancerDTM;
import com.contrastsecurity.agent.plugins.apps.a.a.g;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.protect.H;
import com.contrastsecurity.agent.plugins.protect.I;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.agent.plugins.protect.c.e;
import com.contrastsecurity.agent.plugins.protect.rules.n;
import com.contrastsecurity.agent.plugins.protect.rules.o;
import com.contrastsecurity.agent.plugins.protect.rules.s;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.b.b;
import com.contrastsecurity.agent.telemetry.metrics.c.a;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.agent.telemetry.metrics.i;
import com.contrastsecurity.agent.util.EnumUtils;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

@Singleton
@DontObfuscate
public class ProtectManager
implements I {
    private final CommonConfigProtectionMode globalOverrideMode;
    private final com.contrastsecurity.agent.config.e config;
    private final com.contrastsecurity.agent.plugins.protect.b.c canonicalizer;
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final TelemetryMetrics metrics;
    private final a.a reportCardFactory;
    private final d.c<i> requestTimer;
    private e deadzoneManager;
    private Collection<s> rules;
    private Map<ProtectRuleId, s> ruleById;
    private List<n> inputAwareRules;
    private Map<Long, LogEnhancerDTM> logEnhancers;
    private List<com.contrastsecurity.agent.plugins.protect.a> logEnhancerList;
    private Set<String> userTargetedClasses;
    private volatile boolean activated;
    private final ThreadLocal<H> protectContext = new ThreadLocal<H>(){

        protected H a() {
            return new H(ProtectManager.this.canonicalizer, ProtectManager.this.reportCardFactory.a(ProtectManager.this.requestTimer));
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.a();
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(ProtectManager.class);

    @Inject
    public ProtectManager(com.contrastsecurity.agent.config.e e2, ApplicationManager applicationManager, HttpManager httpManager, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.telemetry.metrics.b.b b2, com.contrastsecurity.agent.commons.b b3) {
        this.config = Objects.requireNonNull(e2);
        this.applicationManager = Objects.requireNonNull(applicationManager);
        this.httpManager = Objects.requireNonNull(httpManager);
        this.metrics = Objects.requireNonNull(telemetryMetrics);
        i.a a2 = telemetryMetrics.newTimer("requestTime", TelemetryMetrics.TelemetryCategory.PERFORMANCE_PROTECT).a("Records time taken to handle requests end-to-end, split by constituent parts (e.g. source analysis, sink analysis, etc.)").a(Duration.ofNanos(10000L), Duration.ofNanos(100000L), Duration.ofNanos(500000L), Duration.ofMillis(1L), Duration.ofMillis(5L), Duration.ofMillis(10L), Duration.ofMillis(50L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(10L), Duration.ofMinutes(1L));
        this.requestTimer = telemetryMetrics.newGrouped(a2).a("aspect").a(com.contrastsecurity.agent.telemetry.metrics.a.c.a());
        this.reportCardFactory = new a.a(telemetryMetrics, b3, b2);
        this.canonicalizer = new com.contrastsecurity.agent.plugins.protect.b.c(telemetryMetrics, b3);
        if (!e2.c(ConfigProperty.PROTECT_SINKS)) {
            PreConfigUtil.out("Disabling defensive instrumentation sensors. No attacks can be blocked or confirmed exploited.");
        }
        this.globalOverrideMode = ProtectManager.calcGlobalModeOverride(e2);
    }

    @t
    public ProtectManager(com.contrastsecurity.agent.config.e e2, ApplicationManager applicationManager, HttpManager httpManager, TelemetryMetrics telemetryMetrics, e e3, b.a a2, Collection<s> collection, com.contrastsecurity.agent.commons.b b2) {
        this(e2, applicationManager, httpManager, telemetryMetrics, a2, b2);
        this.initializeDeadzoneManager(e3);
        this.setRules(collection);
    }

    void initializeDeadzoneManager(e e2) {
        Objects.requireNonNull(e2);
        if (this.deadzoneManager != null) {
            throw new IllegalStateException("DeadzoneManager has already been initialized");
        }
        this.deadzoneManager = e2;
    }

    void setRules(Collection<s> collection) {
        Objects.requireNonNull(collection);
        if (this.rules != null) {
            throw new IllegalStateException("rules have already been set");
        }
        if (this.deadzoneManager == null) {
            throw new IllegalStateException("DeadzoneManager has not yet been initialized");
        }
        Lists.Builder<s> builder = Lists.builder();
        this.inputAwareRules = new LinkedList<n>();
        this.ruleById = new EnumMap<ProtectRuleId, s>(ProtectRuleId.class);
        for (s s2 : collection) {
            this.ruleById.put(s2.getRuleId(), s2);
            if (s2 instanceof n) {
                if (s2.g() && this.metrics.isEnabled()) {
                    s2 = new o((n)s2, this.metrics);
                }
                this.inputAwareRules.add((n)s2);
            }
            builder.add(s2);
        }
        this.rules = builder.build();
    }

    public Set<String> getUserTargetedClasses() {
        if (this.userTargetedClasses == null && this.logEnhancerList != null) {
            this.userTargetedClasses = new HashSet<String>();
            for (com.contrastsecurity.agent.plugins.protect.a a2 : this.logEnhancerList) {
                if (a2 == null) continue;
                this.userTargetedClasses.add(a2.b());
            }
        }
        return this.userTargetedClasses;
    }

    public void onServerFeatureUpdate(ServerSettingsProtectDTM serverSettingsProtectDTM) {
        if (serverSettingsProtectDTM != null) {
            List<LogEnhancerDTM> list = serverSettingsProtectDTM.getLogEnhancers();
            if (list != null) {
                this.logEnhancers = this.toLogEnhancerMap(list);
                this.logEnhancerList = this.toList(list);
                logger.info("Enabling log enhancers of size={}", (Object)this.logEnhancerList.size());
            } else {
                this.logEnhancers = Collections.emptyMap();
                this.logEnhancerList = Collections.emptyList();
                logger.info("No log enhancers provided");
            }
        }
    }

    private List<com.contrastsecurity.agent.plugins.protect.a> toList(List<LogEnhancerDTM> list) {
        ArrayList<com.contrastsecurity.agent.plugins.protect.a> arrayList = new ArrayList<com.contrastsecurity.agent.plugins.protect.a>();
        if (list != null) {
            for (LogEnhancerDTM logEnhancerDTM : list) {
                arrayList.add(new com.contrastsecurity.agent.plugins.protect.a(logEnhancerDTM));
            }
        }
        return arrayList;
    }

    private Map<Long, LogEnhancerDTM> toLogEnhancerMap(List<LogEnhancerDTM> list) {
        HashMap<Long, LogEnhancerDTM> hashMap = new HashMap<Long, LogEnhancerDTM>();
        for (LogEnhancerDTM logEnhancerDTM : list) {
            hashMap.put(logEnhancerDTM.getId(), logEnhancerDTM);
        }
        return hashMap;
    }

    Collection<s> getRules() {
        return this.rules;
    }

    public Iterable<s> getEnabledRules(HttpRequest httpRequest, H h2, Application application) {
        return this.filterEnabled(this.rules, httpRequest, h2, application);
    }

    public List<n> getEnabledInputRulesCalculated(HttpRequest httpRequest, H h2, Application application) {
        ArrayList<n> arrayList = new ArrayList<n>();
        for (n n2 : this.getEnabledInputAwareRules(httpRequest, h2, application)) {
            arrayList.add(n2);
        }
        return arrayList;
    }

    public Iterable<n> getEnabledInputAwareRules(HttpRequest httpRequest, H h2, Application application) {
        return this.filterEnabled(this.inputAwareRules, httpRequest, h2, application);
    }

    public Iterable<n> getInputAwareRules(H h2, UserInputDTM.InputType inputType, ExceptionInputTypeDTM exceptionInputTypeDTM, String string) {
        Application application = this.applicationManager.current();
        return this.getInputAwareRules(new b<n>(h2, inputType, exceptionInputTypeDTM, string, this, application));
    }

    public Iterable<n> getInputAwareRules(Predicate<n> predicate) {
        a<n> a2 = new a<n>(predicate, this, this.httpManager.getCurrentRequest(), this.currentContext(), this.applicationManager.current());
        return () -> Iterators.filterIterator(this.inputAwareRules, a2);
    }

    public <T extends s> Iterable<T> filterEnabled(Collection<T> collection, H h2) {
        return () -> {
            if (collection == null || collection.isEmpty()) {
                return Collections.emptyIterator();
            }
            return Iterators.filterIterator(collection, new c(this, this.httpManager.getCurrentRequest(), h2, this.applicationManager.current()));
        };
    }

    public <T extends s> Iterable<T> filterEnabled(Collection<T> collection, HttpRequest httpRequest, H h2, Application application) {
        return () -> {
            if (collection == null || collection.isEmpty()) {
                return Collections.emptyIterator();
            }
            return Iterators.filterIterator(collection, new c(this, httpRequest, h2, application));
        };
    }

    private <T extends s> Iterator<T> filterEnabledIterator(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyIterator();
        }
        return Iterators.filterIterator(collection, new c(this, this.httpManager.getCurrentRequest(), this.currentContext(), this.applicationManager.current()));
    }

    public boolean isDisabledByInputExclusion(s s2, ExceptionInputTypeDTM exceptionInputTypeDTM, String string, Application application) {
        Objects.requireNonNull(s2);
        Objects.requireNonNull(exceptionInputTypeDTM);
        com.contrastsecurity.agent.apps.exclusions.g g2 = this.getApplicationExclusionProcessor(application);
        if (g2 == null) {
            return false;
        }
        return g2.isInputExclusion(c.a.b, s2.getRuleId().id(), string, exceptionInputTypeDTM);
    }

    public com.contrastsecurity.agent.apps.exclusions.g getApplicationExclusionProcessor(Application application) {
        if (application == null) {
            return null;
        }
        return application.getExclusionProcessor();
    }

    public s getRuleById(ProtectRuleId protectRuleId) {
        return this.ruleById.get((Object)protectRuleId);
    }

    @t
    public <T extends s> T getRuleById(ProtectRuleId protectRuleId, Class<T> clazz) {
        return (T)((s)clazz.cast(this.ruleById.get((Object)protectRuleId)));
    }

    public boolean isSinksDisabled() {
        return !this.config.c(ConfigProperty.PROTECT_SINKS);
    }

    public boolean shouldProcessSink() {
        return this.activated && this.config.c(ConfigProperty.PROTECT_SINKS);
    }

    public H newContext() {
        H h2 = new H(this.canonicalizer, this.reportCardFactory.a(this.requestTimer));
        this.protectContext.set(h2);
        return h2;
    }

    @Override
    public H currentContext() {
        return this.protectContext.get();
    }

    public void currentContext(H h2) {
        this.protectContext.set(Objects.requireNonNull(h2));
    }

    public LogEnhancerDTM getLogEnhancerById(long l2) {
        return this.logEnhancers.get(l2);
    }

    public List<com.contrastsecurity.agent.plugins.protect.a> getLogEnhancers() {
        return this.logEnhancerList;
    }

    private CommonConfigProtectionMode getAppRuleMode(s s2) {
        if (this.globalOverrideMode != null) {
            return this.globalOverrideMode;
        }
        return s2.getProtectRuleMode().a();
    }

    public CommonConfigProtectionMode getGlobalModeOverride() {
        return this.globalOverrideMode;
    }

    static CommonConfigProtectionMode calcGlobalModeOverride(com.contrastsecurity.agent.config.e e2) {
        CommonConfigProtectionMode commonConfigProtectionMode = null;
        String string = e2.b(ConfigProperty.PROTECT_RULE_MODE_OVERRIDE);
        if (!StringUtils.isEmpty(string)) {
            ProtectionModeDTM protectionModeDTM = EnumUtils.getEnumIgnoreCase(ProtectionModeDTM.class, string);
            if (protectionModeDTM == null) {
                logger.error("Invalid global override setting, will use defaults -- must be off,blocking or monitoring, was: {}", (Object)string);
            } else {
                commonConfigProtectionMode = CommonConfigProtectionMode.fromString(protectionModeDTM.toString());
            }
        }
        return commonConfigProtectionMode;
    }

    public boolean isRuleDisabled(ProtectRuleId protectRuleId) {
        s s2 = this.ruleById.get((Object)protectRuleId);
        if (s2 == null) {
            return true;
        }
        return this.isRuleDisabled(s2, this.httpManager.getCurrentRequest(), this.currentContext(), this.applicationManager.current());
    }

    @t
    public boolean isRuleDisabled(s s2) {
        return this.isRuleDisabled(s2, this.httpManager.getCurrentRequest(), this.currentContext(), this.applicationManager.current());
    }

    public boolean isRuleDisabled(s s2, HttpRequest httpRequest, H h2, Application application) {
        Object object;
        Application application2;
        H h3;
        if (s2.a()) {
            return false;
        }
        if (!this.ruleById.containsKey((Object)s2.getRuleId().baseRuleId())) {
            return true;
        }
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(s2);
        if (CommonConfigProtectionMode.OFF == commonConfigProtectionMode) {
            return true;
        }
        if (!this.shouldProcessSink()) {
            return true;
        }
        H h4 = h3 = h2 == null ? this.currentContext() : h2;
        if (h3 != null && h3.b(s2.getRuleId())) {
            return true;
        }
        String string = s2.getRuleId().baseRuleId().id();
        if (this.deadzoneManager.a(string)) {
            return true;
        }
        Application application3 = application2 = application == null ? this.applicationManager.current() : application;
        if (application2 == null) {
            return false;
        }
        com.contrastsecurity.agent.apps.exclusions.g g2 = application2.getExclusionProcessor();
        if (g2.hasUrlExclusions(c.a.b)) {
            Object object2 = object = httpRequest == null ? this.httpManager.getCurrentRequest() : httpRequest;
            if (object != null && application2.getExclusionProcessor().isDisabledByUrl(c.a.b, string, ((HttpRequest)object).getUri())) {
                return true;
            }
        }
        if ((object = application2.context().get(g.a)) == null) {
            return false;
        }
        return ((g)object).a(string, c.a.b);
    }

    public boolean canBlock(s s2) {
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(s2);
        return CommonConfigProtectionMode.BLOCK.equals((Object)commonConfigProtectionMode) || CommonConfigProtectionMode.BLOCK_AT_PERIMETER.equals((Object)commonConfigProtectionMode);
    }

    boolean shouldBlockAtPerimeter(n n2, UserInputDTM.InputType inputType) {
        CommonConfigProtectionMode commonConfigProtectionMode = this.getAppRuleMode(n2);
        return commonConfigProtectionMode == CommonConfigProtectionMode.BLOCK_AT_PERIMETER || commonConfigProtectionMode == CommonConfigProtectionMode.BLOCK && n2.a(inputType);
    }

    public boolean hasContextAndSinksAllowed() {
        return this.currentContext() != null && this.shouldProcessSink();
    }

    public boolean isScanParameterAsAnything() {
        return this.config.c(ConfigProperty.INSPECT_PARAMETERS_AS_JSON) || this.config.c(ConfigProperty.INSPECT_PARAMETERS_AS_XML);
    }

    public void checkParameterAccess() {
        H h2 = this.currentContext();
        if (h2.g()) {
            throw new AttackBlockedException("Attack already detected in parameters");
        }
    }

    public void activate() {
        this.activated = true;
    }

    public void deactivate() {
        this.activated = false;
    }

    static final class c<T extends s>
    implements Predicate<T> {
        private final ProtectManager a;
        private final HttpRequest b;
        private final H c;
        private final Application d;

        c(ProtectManager protectManager, HttpRequest httpRequest, H h2, Application application) {
            this.a = protectManager;
            this.b = httpRequest;
            this.c = h2;
            this.d = application;
        }

        public boolean a(T t2) {
            return !this.a.isRuleDisabled((s)t2, this.b, this.c, this.d);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((s)object);
        }
    }

    static final class a<T extends s>
    implements Predicate<T> {
        private final Predicate<T> a;
        private final Predicate<T> b;

        a(Predicate<T> predicate, ProtectManager protectManager, HttpRequest httpRequest, H h2, Application application) {
            this.a = predicate;
            this.b = new c(protectManager, httpRequest, h2, application);
        }

        public boolean a(T t2) {
            return this.a.test(t2) && this.b.test(t2);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((s)object);
        }
    }

    static final class b<T extends n>
    implements Predicate<T> {
        private final H a;
        private final UserInputDTM.InputType b;
        private final ExceptionInputTypeDTM c;
        private final String d;
        private final ProtectManager e;
        private final Application f;

        b(H h2, UserInputDTM.InputType inputType, ExceptionInputTypeDTM exceptionInputTypeDTM, String string, ProtectManager protectManager, Application application) {
            this.a = h2;
            this.b = inputType;
            this.c = exceptionInputTypeDTM;
            this.d = string;
            this.e = protectManager;
            this.f = application;
        }

        public boolean a(T t2) {
            boolean bl2;
            ProtectRuleId protectRuleId = t2.getRuleId();
            boolean bl3 = bl2 = t2.appliesToInputType(this.b) && !this.a.b(protectRuleId) && !this.e.isDisabledByInputExclusion((s)t2, this.c, this.d, this.f);
            if (!bl2 && logger.isTraceEnabled()) {
                logger.trace("Skipping {} input scanning for {} for {} due to exception", this.b.logName(), protectRuleId.id(), this.d);
            }
            return bl2;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((n)object);
        }
    }
}

