/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.trace.snapshot.c;
import com.contrastsecurity.agent.weakmap.WeakIdentityHashMap;
import java.util.Collections;
import java.util.Map;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public final class AssessContextSnapshotCache
implements c {
    @HeapUsage.Deep
    private final Map<Object, char[]> snapshotMap = Collections.synchronizedMap(new WeakIdentityHashMap());
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final Counter snapshotCacheHit;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    private final Counter snapshotCacheMiss;

    public AssessContextSnapshotCache(Counter counter, Counter counter2) {
        this.snapshotCacheHit = counter;
        this.snapshotCacheMiss = counter2;
    }

    @Override
    public char[] getSnapshot(Object object) {
        char[] cArray = this.snapshotMap.get(object);
        if (cArray == null && object == null) {
            return null;
        }
        if (cArray != null) {
            this.snapshotCacheHit.increment();
        } else {
            this.snapshotCacheMiss.increment();
        }
        return cArray;
    }

    @Override
    public void putSnapshot(Object object, char[] cArray) {
        this.snapshotMap.put(object, cArray);
    }

    @Override
    public int cacheEntries() {
        return this.snapshotMap.size();
    }
}

