/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.b;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.telemetry.HeapProfiler;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.a.a;
import com.contrastsecurity.agent.telemetry.metrics.c.a;
import com.contrastsecurity.agent.telemetry.metrics.d;
import com.contrastsecurity.agent.telemetry.metrics.i;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.time.Duration;
import java.util.Objects;

@Singleton
@DontObfuscate
public class AssessmentManager {
    private final b clock;
    private final e config;
    private final HeapProfiler heapProfiler;
    @DontObfuscate
    private final ThreadLocal<AssessmentContext> assessmentContext = ThreadLocal.withInitial(() -> null);
    @DontObfuscate
    private final long maxContextTtl;
    private int contextsCreated;
    private long totalMapSize;
    private final a.a reportCardFactory;
    private final d.c<i> requestTimer;
    private final Counter snapshotCacheHit;
    private final Counter snapshotCacheMiss;
    private volatile boolean enableCaptureRecentFindings;
    private static final int DEFAULT_TRACEMAP_SIZE = 75;
    private static final int MINIMUM_CONTEXTS_BEFORE_PREDICTING_TRACEMAP_SIZE = 5;
    private static final Logger logger = LoggerFactory.getLogger(AssessmentManager.class);

    @Inject
    public AssessmentManager(b b2, e e2, TelemetryMetrics telemetryMetrics, com.contrastsecurity.agent.telemetry.metrics.b.b b3, HeapProfiler heapProfiler) {
        this.clock = b2;
        this.config = e2;
        this.heapProfiler = heapProfiler;
        this.maxContextTtl = e2.e(ConfigProperty.MAX_TRACE_TTL);
        Objects.requireNonNull(telemetryMetrics);
        i.a a2 = telemetryMetrics.newTimer("requestTime", TelemetryMetrics.TelemetryCategory.ASSESS).a("Records total time taken to handle requests").a(Duration.ofNanos(10000L), Duration.ofNanos(100000L), Duration.ofNanos(500000L), Duration.ofMillis(1L), Duration.ofMillis(5L), Duration.ofMillis(10L), Duration.ofMillis(50L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(10L), Duration.ofMinutes(1L));
        this.requestTimer = telemetryMetrics.newGrouped(a2).a("aspect").a(a.a());
        this.reportCardFactory = new a.a(telemetryMetrics, b2, b3);
        this.snapshotCacheHit = telemetryMetrics.newCounter("snapshotCacheHitCount", TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("The number snapshot cache hits in Assess").register();
        this.snapshotCacheMiss = telemetryMetrics.newCounter("snapshotCacheMissCount", TelemetryMetrics.TelemetryCategory.ASSESS).withDescription("The number snapshot cache misses in Assess").register();
    }

    public AssessmentContext newContext() {
        int n2;
        AssessmentContext assessmentContext = this.currentContext();
        if (assessmentContext != null && !assessmentContext.isJumpedContexts()) {
            assessmentContext.clear();
        }
        if (this.contextsCreated > 5) {
            n2 = (int)Math.min(this.totalMapSize / (long)this.contextsCreated, 250L);
            n2 = Math.max(n2, 20);
        } else {
            n2 = 75;
        }
        AssessmentContext assessmentContext2 = this.heapProfiler.saveForProfiling(new AssessmentContext(this.config, this.clock, n2, this.snapshotCacheHit, this.snapshotCacheMiss, this.reportCardFactory.a(this.requestTimer)));
        if (this.enableCaptureRecentFindings) {
            assessmentContext2.enableCaptureRecentFindings();
        }
        this.assessmentContext.set(assessmentContext2);
        return assessmentContext2;
    }

    @t
    void clearContext() {
        AssessmentContext assessmentContext = this.assessmentContext.get();
        if (assessmentContext != null) {
            assessmentContext.clear();
        }
        this.assessmentContext.set(null);
    }

    public void currentContext(AssessmentContext assessmentContext) {
        this.assessmentContext.set(assessmentContext);
    }

    public AssessmentContext currentContext() {
        AssessmentContext assessmentContext = this.assessmentContext.get();
        if (assessmentContext != null) {
            long l2 = assessmentContext.lastUpdatedMillis();
            long l3 = this.clock.now() - l2;
            if (l3 > this.maxContextTtl) {
                assessmentContext.clear();
                logger.debug("Cleared expired assessment context {} in ({}ms)", (Object)assessmentContext, (Object)l3);
                assessmentContext.refresh();
            }
        }
        return assessmentContext;
    }

    public void onContextClearing(int n2) {
        ++this.contextsCreated;
        this.totalMapSize += (long)n2;
    }

    @Deprecated
    @t
    public void enableCaptureRecentFindings() {
        this.enableCaptureRecentFindings = true;
    }
}

