/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.commons.Purgeable;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.config.enums.TraceMapStrategy;
import com.contrastsecurity.agent.plugins.security.AssessContextSnapshotCache;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.reloadable.ChannelSubscriber;
import com.contrastsecurity.agent.telemetry.HeapProfiler;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

@Singleton
@DontObfuscate
public class EventContext
implements Purgeable,
ChannelSubscriber {
    private final AssessmentManager assessmentManager;
    private boolean enabled;
    private final TraceMapStrategy traceMapStrategy;
    private final com.contrastsecurity.agent.commons.b clock;
    private final Map<Object, Trace> globalTraceMap;
    private final long maxStronglyReachableTraceTtl;
    private static final Logger logger = LoggerFactory.getLogger(EventContext.class);

    @Inject
    public EventContext(e e2, com.contrastsecurity.agent.commons.b b2, AssessmentManager assessmentManager, HeapProfiler heapProfiler) {
        this.clock = b2;
        this.assessmentManager = assessmentManager;
        this.maxStronglyReachableTraceTtl = e2.e(ConfigProperty.MAX_TRACE_TTL);
        this.traceMapStrategy = EventContext.traceMapStrategyFromConfig(e2);
        @HeapUsage.SupportsHeapProfiling(implicitOuterReference=HeapUsage.SHALLOW, ownedCaches={AssessContextSnapshotCache.class, AssessmentContext.a.class})
        final class A
        extends b {
            A(int n2) {
                super(n2);
            }
        }
        this.globalTraceMap = heapProfiler.saveForProfiling(new A(10000));
    }

    static TraceMapStrategy traceMapStrategyFromConfig(e e2) {
        String string = e2.a(ConfigProperty.TRACE_MAP_STRATEGY);
        TraceMapStrategy traceMapStrategy = TraceMapStrategy.valueOfIgnoreCase(string);
        if (traceMapStrategy == null) {
            throw new com.contrastsecurity.agent.config.c.b("Invalid value [" + string + "] set for " + (Object)((Object)ConfigProperty.TRACE_MAP_STRATEGY) + ". Valid values are GLOBAL, CONTEXT, BOTH.");
        }
        return traceMapStrategy;
    }

    @Override
    public void onMessageReceived(Map<String, Object> map) {
        this.globalTraceMap.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public Map<Object, Trace> getTraceMap() {
        return this.getTraceMap(this.traceMapStrategy == TraceMapStrategy.GLOBAL ? null : this.assessmentManager.currentContext());
    }

    public Map<Object, Trace> getTraceMap(AssessmentContext assessmentContext) {
        switch (this.traceMapStrategy) {
            case GLOBAL: {
                return this.globalTraceMap;
            }
            case CONTEXT: {
                return assessmentContext == null ? null : assessmentContext.getTraceMap();
            }
            case BOTH: {
                Map<Object, Trace> map = assessmentContext == null ? null : assessmentContext.getTraceMap();
                return map == null ? this.globalTraceMap : map;
            }
        }
        throw new IllegalStateException("Unknown Trace Map Strategy: " + (Object)((Object)this.traceMapStrategy));
    }

    @Override
    public void purgeStale() {
        AssessmentContext assessmentContext;
        Map<Object, Trace> map = this.getTraceMap();
        if (map != null) {
            this.removeDeadTraces(map);
            this.removeExpiredTraces(map);
        }
        if ((assessmentContext = this.assessmentManager.currentContext()) != null) {
            assessmentContext.clearLastMethodEvent();
        }
    }

    private void removeDeadTraces(Map<Object, Trace> map) {
        ConcurrentReferenceHashMap concurrentReferenceHashMap = (ConcurrentReferenceHashMap)map;
        concurrentReferenceHashMap.dumpStats();
        concurrentReferenceHashMap.purgeStaleEntries();
    }

    private void removeExpiredTraces(Map<Object, Trace> map) {
        Iterator<Map.Entry<Object, Trace>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Trace> entry;
            Trace trace = null;
            try {
                entry = iterator.next();
                trace = (Trace)entry.getValue();
                if (!this.shouldRemoveTrace(trace)) continue;
                Object k2 = entry.getKey();
                if (logger.isTraceEnabled()) {
                    logger.trace("Removing expired key=[{}] with identity=[{}] and value=[{}] from trace map=[{}].", k2, JVMUtils.getSafeToString(k2, true), JVMUtils.getSafeToString(trace, true), JVMUtils.getSafeToString(map, true));
                }
                iterator.remove();
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                entry = throwable;
                logger.error("Problem pruning old trace {}", trace != null ? Long.valueOf(trace.getId()) : "null", (Object)entry);
            }
        }
    }

    private boolean shouldRemoveTrace(Trace trace) {
        CodeEvent codeEvent = trace.getFirstEvent();
        if (codeEvent == null) {
            return true;
        }
        long l2 = codeEvent.getTimestamp();
        long l3 = this.clock.now() - l2;
        return l3 > this.maxStronglyReachableTraceTtl;
    }

    @Override
    public int purgeableCount() {
        Map<Object, Trace> map = this.getTraceMap();
        return map != null ? map.size() : 0;
    }

    public Integer getTrackedItemHash(Object[] objectArray) {
        Map<Object, Trace> map = this.getTraceMap();
        if (map == null) {
            return null;
        }
        Trace trace = map.get(objectArray);
        if (trace != null) {
            return Arrays.hashCode(objectArray);
        }
        for (Object object : objectArray) {
            Integer n2;
            if (object == null) continue;
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz != null && !clazz.isPrimitive() && (n2 = this.getTrackedItemHash((Object[])object)) != null) {
                return n2;
            }
            trace = map.get(object);
            if (trace == null) continue;
            return object.hashCode();
        }
        return null;
    }

    @HeapUsage.SupportsHeapProfiling
    public static class b
    extends ConcurrentReferenceHashMap<Object, Trace> {
        private b(int n2) {
            super(n2, 0.75f, 32, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG, EnumSet.range(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS, ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
        }

        public static Map<Object, Trace> a(int n2) {
            return new b(n2);
        }
    }
}

