/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;

@Singleton
@DontObfuscate
public class EventHelper {
    private final AssessmentManager assessmentManager;

    @Inject
    public EventHelper(AssessmentManager assessmentManager) {
        this.assessmentManager = assessmentManager;
    }

    public int getLength(String string) {
        return string == null ? 0 : string.length();
    }

    public int getLength(Object object) {
        int n2 = 0;
        if (object != null) {
            AssessmentContext assessmentContext = this.assessmentManager.currentContext();
            if (assessmentContext != null && this.shouldSaveLength(object)) {
                Integer n3 = assessmentContext.getLength(object);
                if (n3 != null) {
                    n2 = n3;
                } else {
                    n2 = this._getLength(object);
                    assessmentContext.saveLength(object, n2);
                }
            } else {
                n2 = this._getLength(object);
            }
        }
        return n2;
    }

    private boolean shouldSaveLength(Object object) {
        return object instanceof Map || object instanceof Collection || object instanceof Object[];
    }

    private int _getLength(Object object) {
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length();
        }
        if (object instanceof StringWriter) {
            return ((StringWriter)object).getBuffer().length();
        }
        if (object instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)object).size();
        }
        if (object instanceof Character) {
            return 1;
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).length;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length;
        }
        if (object instanceof char[]) {
            return ((char[])object).length;
        }
        if (object instanceof short[]) {
            return ((short[])object).length;
        }
        if (object instanceof int[]) {
            return ((int[])object).length;
        }
        if (object instanceof float[]) {
            return ((float[])object).length;
        }
        if (object instanceof long[]) {
            return ((long[])object).length;
        }
        if (object instanceof double[]) {
            return ((double[])object).length;
        }
        return JVMUtils.getSafeToString(object).length();
    }
}

