/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.trigger;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.f.c;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.logging.a;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.controller.o;
import com.contrastsecurity.agent.plugins.security.controller.trigger.p;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.n;
import com.contrastsecurity.agent.plugins.security.policy.SourceNode;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.y;
import com.contrastsecurity.agent.reloadable.AgentChannelHub;
import com.contrastsecurity.agent.services.ngreporting.h;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public final class QueueFindingListener
implements p {
    private final AssessmentManager assessmentManager;
    private final HttpManager httpManager;
    private final Finding.d findingFactory;
    private final e config;
    private final h legacyReportingService;
    private final y.c cryptographicHasher;
    private final y.d dataflowHasher;
    private final n disabledRulesFilter;
    private static final String INVALID_DATA_FLOW_ERROR = "dataflow.invalid.notenough";
    private static final String RULE_HASH_CHANNEL = "assess.rule-and-hash";
    private static final Logger logger = LoggerFactory.getLogger(QueueFindingListener.class);

    public QueueFindingListener(AssessmentManager assessmentManager, HttpManager httpManager, e e2, Finding.d d2, h h2, y y2, n n2) {
        this.assessmentManager = assessmentManager;
        this.httpManager = httpManager;
        this.findingFactory = d2;
        this.config = e2;
        this.legacyReportingService = h2;
        this.cryptographicHasher = y2.c();
        this.dataflowHasher = y2.e();
        this.disabledRulesFilter = n2;
    }

    @Override
    public boolean onTraceTriggered(Application application, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, o o2) {
        String string = rule.getId();
        if (this.shouldUpdateIdToStoredXSS(string, trace)) {
            string = "stored-xss";
        }
        if (this.disabledRulesFilter.a(application).test(string)) {
            logger.debug("Suppressed trace {} in {} for the disabled rule {}", trace.getId(), application, string);
            return false;
        }
        if (this.isInvalidDataFlow(rule, trace)) {
            a.a(INVALID_DATA_FLOW_ERROR, logger, "Not enough data flow events for trace {}", null, new Object[]{c.a(logger, String.valueOf(trace))});
            logger.debug("Suppressed trace {} w/o enough events {}", (Object)trace.getId(), (Object)trace);
            return false;
        }
        long l2 = "crypto-bad-ciphers".equals(string) || "crypto-bad-mac".equals(string) ? this.cryptographicHasher.a(rule.getId(), this.httpManager.getCurrentRequest(), objectArray.length == 0 ? QueueFindingListener.getCryptoHashArgument(trace) : (String)objectArray[0]) : this.dataflowHasher.a(rule.getId(), this.httpManager.getCurrentRequest(), trace);
        Finding finding = this.findingFactory.a(application, string, trace, l2);
        finding.setRequest(this.httpManager.getCurrentRequest());
        logger.info("Added finding for rule ID: {} (hash={})", (Object)string, (Object)finding.getHash());
        this.broadcastToLegacyChannel(string, finding);
        this.legacyReportingService.a(finding);
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        if (assessmentContext != null && finding.hasEvents()) {
            assessmentContext.onFindingOccurred(string, finding.getHash());
        }
        return true;
    }

    private static String getCryptoHashArgument(Trace trace) {
        if (trace == null) {
            return "";
        }
        CodeEvent codeEvent = trace.getLastEvent();
        if (codeEvent == null) {
            return "";
        }
        MethodDescription methodDescription = codeEvent.getMethod();
        if (methodDescription == null) {
            return "";
        }
        String string = methodDescription.getSignature();
        return string == null ? "" : string;
    }

    private void broadcastToLegacyChannel(String string, Finding finding) {
        AgentChannelHub agentChannelHub = AgentChannelHub.getOrNull(this.config);
        if (agentChannelHub == null) {
            return;
        }
        if (agentChannelHub.hasSubscribers(RULE_HASH_CHANNEL)) {
            agentChannelHub.broadcast(RULE_HASH_CHANNEL, Maps.builder().add(string, finding.getHash()).build());
        }
    }

    private boolean isInvalidDataFlow(Rule rule, Trace trace) {
        if (rule.requiresDataFlow() && trace != null) {
            List<CodeEvent> list = trace.getEvents();
            return list != null && list.size() <= 1;
        }
        return false;
    }

    private boolean shouldUpdateIdToStoredXSS(String string, Trace trace) {
        List<CodeEvent> list;
        if ("reflected-xss".equals(string) && trace != null && (list = trace.getEvents()) != null && !list.isEmpty()) {
            for (CodeEvent codeEvent : list) {
                SourceNode sourceNode;
                if (!(codeEvent instanceof SourceEvent) || (sourceNode = ((SourceEvent)codeEvent).getSource()) == null || !sourceNode.hasSourceTypes() || !sourceNode.isSourceType(com.contrastsecurity.agent.plugins.security.policy.y.i) && !sourceNode.isSourceType(com.contrastsecurity.agent.plugins.security.policy.y.b)) continue;
                return true;
            }
        }
        return false;
    }
}

