/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.pattern;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.EventHelper;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.model.TagEvent;
import com.contrastsecurity.agent.plugins.security.model.c;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.d;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.reflection.a;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.agent.v.m;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
@DontObfuscate
public final class ContrastPatternDispatcherImpl
implements ContrastPatternDispatcher {
    private final EventHelper eventHelper;
    private final TraceController traceController;
    private final c codeEventFactory;
    private final AssessmentManager assessmentManager;
    private final m stackCaptureFactory;
    private final com.contrastsecurity.agent.trace.a methodDescriptionCache;
    private final d policyManager;
    private final ScopeProviderAssess scopeProvider;
    private static final Logger logger = LoggerFactory.getLogger(ContrastPatternDispatcherImpl.class);

    @Inject
    public ContrastPatternDispatcherImpl(EventHelper eventHelper, TraceController traceController, c c2, AssessmentManager assessmentManager, m m2, com.contrastsecurity.agent.trace.a a2, d d2, ScopeProviderAssess scopeProviderAssess) {
        this.eventHelper = eventHelper;
        this.codeEventFactory = c2;
        this.traceController = traceController;
        this.assessmentManager = assessmentManager;
        this.stackCaptureFactory = m2;
        this.methodDescriptionCache = a2;
        this.policyManager = d2;
        this.scopeProvider = scopeProviderAssess;
    }

    @ScopedSensor
    public void onJavaPatternUsed(Object object, Object object2, Matcher matcher) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            Object object3;
            block7: {
                if (object == null || !this.scopeProvider.inValidatorScope()) {
                    scopeAggregator.leaveScope();
                    return;
                }
                object3 = this.traceController.getTrace(object);
                if (object3 != null) break block7;
                scopeAggregator.leaveScope();
                return;
            }
            try {
                Pattern pattern = (Pattern)object2;
                String string = pattern.pattern();
                String string2 = this.getValidatorTag(string);
                if (string2 != null) {
                    com.contrastsecurity.agent.plugins.security.model.m m2 = this.createTagEventBuilder((Trace)object3, "matcher", "(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;", pattern, new Object[]{object}, matcher);
                    this.addTaggingEvent((Trace)object3, m2, string2, object);
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                object3 = throwable;
                logger.error("Problem checking if pattern used was good", (Throwable)object3);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    private void addTaggingEvent(Trace trace, com.contrastsecurity.agent.plugins.security.model.m m2, String string, Object object) throws InvalidTagRangeException {
        m2.d(trace.getLastEvent());
        m2.b(N.a(string, this.eventHelper.getLength(object)));
        TagEvent tagEvent = m2.g();
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        if (assessmentContext != null && assessmentContext.isIdentityTaggingEnabled()) {
            int n2 = assessmentContext.getIdentity(object.hashCode(), trace.getIdentitySourceHash());
            assessmentContext.applyTags(n2, string, this.eventHelper.getLength(object));
        }
        trace.addEvent(tagEvent);
        if (logger.isDebugEnabled()) {
            logger.debug("TRACE {}", (Object)tagEvent);
        }
    }

    @t
    public String getValidatorTag(String string) {
        Set<String> set;
        ContrastPolicy contrastPolicy = this.policyManager.e();
        Map<String, Set<String>> map = contrastPolicy.getAcceptedRegex();
        for (String string2 : map.keySet()) {
            set = map.get(string2);
            for (String string3 : set) {
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        map = contrastPolicy.getRejectedRegex();
        for (String string2 : map.keySet()) {
            set = map.get(string2);
            for (String string3 : set) {
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    private com.contrastsecurity.agent.plugins.security.model.m createTagEventBuilder(Trace trace, String string, String string2, Object object, Object[] objectArray, Object object2) {
        MethodDescription methodDescription = MethodDescription.getMethod(this.methodDescriptionCache, object.getClass().getName(), string, string2, 0);
        return (com.contrastsecurity.agent.plugins.security.model.m)((com.contrastsecurity.agent.plugins.security.model.m)((com.contrastsecurity.agent.plugins.security.model.m)((com.contrastsecurity.agent.plugins.security.model.m)((com.contrastsecurity.agent.plugins.security.model.m)((com.contrastsecurity.agent.plugins.security.model.m)((com.contrastsecurity.agent.plugins.security.model.m)this.codeEventFactory.a((Propagator)null).a(methodDescription)).a(objectArray)).f("P0")).a(object)).b(object2)).c(trace.getLastEvent())).a(this.stackCaptureFactory.a(m.a.c));
    }

    @ScopedSensor
    public void onPerl5PatternUsed(Object object, Object object2, Object object3, boolean bl2) {
        ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
        try {
            Object object4;
            block7: {
                if (object2 == null || object3 == null || !this.scopeProvider.inValidatorScope()) {
                    scopeAggregator.leaveScope();
                    return;
                }
                object4 = this.traceController.getTrace(object2);
                if (object4 != null) break block7;
                scopeAggregator.leaveScope();
                return;
            }
            try {
                Method method = a.f(object3.getClass(), "getPattern");
                String string = (String)method.invoke(object3, Empty.OBJ_ARRAY);
                String string2 = this.getValidatorTag(string);
                if (string2 != null) {
                    com.contrastsecurity.agent.plugins.security.model.m m2 = this.createTagEventBuilder((Trace)object4, "matches", "(Ljava/lang/String;Lorg/apache/oro/text/regex/Perl5Matcher;)Z", object, new Object[]{object2, object3}, bl2);
                    this.addTaggingEvent((Trace)object4, m2, string2, object2);
                }
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                object4 = throwable;
                logger.error("Problem checking if pattern used was good", (Throwable)object4);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }
}

