/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.f;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.messages.finding.trace.PropertyKey;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.DoNothingHttpWatcher;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.plugins.security.y;
import com.contrastsecurity.agent.util.q;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ArrayUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.EnumMap;
import java.util.zip.CRC32;

@DontObfuscate
public abstract class HeaderHttpWatcher
extends DoNothingHttpWatcher {
    protected final ProviderUtil providerUtil;
    private final y.e requestHasher;
    private static final int[] UNDESIRED_RESPONSE_CODES = new int[]{301, 302, 307, 404, 410, 500};
    protected static final Logger logger = LoggerFactory.getLogger(HeaderHttpWatcher.class);

    public HeaderHttpWatcher(ProviderUtil providerUtil, y y2) {
        this.providerUtil = providerUtil;
        this.requestHasher = y2.g();
    }

    @Override
    public boolean supports(HttpRequest httpRequest) {
        return !q.b(httpRequest);
    }

    @Override
    public void onResponseEnd(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpResponse == null || this.isSafe(httpRequest.context())) {
            return;
        }
        if (this.undesiredResponseCode(httpResponse)) {
            if (logger.isDebugEnabled()) {
                logger.debug("suppressing finding for {} rule, response code is: {}", (Object)this.getRuleName(), (Object)httpResponse.getStatus());
            }
            return;
        }
        String string = httpResponse.getContentType();
        if (this.isUndesiredContentType(string)) {
            return;
        }
        long l2 = this.requestHasher.a(this.getRuleName(), httpRequest);
        EnumMap<PropertyKey, String> enumMap = new EnumMap<PropertyKey, String>(PropertyKey.class);
        enumMap.put(PropertyKey.DATA, this.getData(httpRequest.context()));
        this.providerUtil.reportFinding(this.getRuleName(), null, l2, enumMap);
    }

    @Override
    public long getRuleRequestHash(HttpRequest httpRequest, CRC32 cRC32) {
        return this.requestHasher.a(cRC32, this.getRuleName(), httpRequest);
    }

    protected abstract boolean isSafe(f var1);

    protected abstract String getRuleName();

    protected abstract String getData(f var1);

    protected boolean isUndesiredContentType(String string) {
        return false;
    }

    private boolean undesiredResponseCode(HttpResponse httpResponse) {
        boolean bl2 = false;
        try {
            int n2 = httpResponse.getStatus();
            if (ArrayUtils.contains(UNDESIRED_RESPONSE_CODES, n2)) {
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.debug("Problem catching response code for HTTP Header check", throwable2);
        }
        return bl2;
    }
}

