/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services.ngreporting;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.config.c.b;
import com.contrastsecurity.agent.config.enums.SaveReportMode;
import com.contrastsecurity.agent.e.g;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.reloadable.AgentChannelHub;
import com.contrastsecurity.agent.scope.c;
import com.contrastsecurity.agent.services.a;
import com.contrastsecurity.agent.services.ngreporting.LegacyReport;
import com.contrastsecurity.agent.services.ngreporting.e;
import com.contrastsecurity.agent.services.ngreporting.f;
import com.contrastsecurity.agent.services.ngreporting.h;
import com.contrastsecurity.agent.services.ngreporting.k;
import com.contrastsecurity.agent.services.ngreporting.o;
import com.contrastsecurity.agent.services.ngreporting.q;
import com.contrastsecurity.agent.services.ngreporting.s;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Provider;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

@Singleton
public final class i
implements h {
    private final Map<Long, Long> a = new ConcurrentHashMap<Long, Long>();
    private final Queue<LegacyReport> b = new ConcurrentLinkedQueue<LegacyReport>();
    private volatile boolean c;
    private Thread d;
    private final e e;
    private final long f;
    private final boolean g;
    private final com.contrastsecurity.agent.config.e h;
    private final q i;
    private final com.contrastsecurity.agent.commons.b j;
    private final com.contrastsecurity.agent.d.g k;
    private final long l;
    private final com.contrastsecurity.agent.telemetry.errors.o m;
    private static final String n = "clearReportingQueues";
    private static final Logger o = LoggerFactory.getLogger(i.class);

    @Inject
    public i(com.contrastsecurity.agent.config.e e2, com.contrastsecurity.agent.commons.b b2, Provider<f> provider, com.contrastsecurity.agent.d.g g2, WorkingDirectories workingDirectories, com.contrastsecurity.agent.telemetry.errors.o o2) {
        this(e2, b2, !StringUtils.isEmpty(e2.b(ConfigProperty.TEAMSERVER_URL)) ? (q)provider.get() : null, g2, workingDirectories, o2);
    }

    public i(com.contrastsecurity.agent.config.e e2, com.contrastsecurity.agent.commons.b b2, q q2, com.contrastsecurity.agent.d.g g2, WorkingDirectories workingDirectories, com.contrastsecurity.agent.telemetry.errors.o o2) {
        this.h = Objects.requireNonNull(e2);
        this.j = Objects.requireNonNull(b2);
        this.k = Objects.requireNonNull(g2);
        this.i = q2;
        this.m = Objects.requireNonNull(o2);
        this.l = e2.e(ConfigProperty.DUP_DELAY);
        this.e = new e(e2, workingDirectories);
        this.f = e2.e(ConfigProperty.LEGACY_REPORTING_PERIOD);
        this.g = e2.c(ConfigProperty.PREFLIGHT_FAIL_OPEN);
        this.d();
        this.c = true;
    }

    void d() {
        AgentChannelHub agentChannelHub = AgentChannelHub.getOrNull(this.h);
        if (agentChannelHub == null) {
            return;
        }
        agentChannelHub.listenForMessage(n, object -> {
            o.debug("Received request to clear reporting queues");
            Object object2 = this.a;
            synchronized (object2) {
                if (o.isDebugEnabled()) {
                    o.debug("Clearing {} events from trace cache {}", (Object)this.a.size(), (Object)this.a);
                }
                this.a.clear();
            }
            object2 = this.b;
            synchronized (object2) {
                o.debug("Clearing {} events from report queue", (Object)this.b.size());
                this.b.clear();
            }
            return null;
        });
    }

    Queue<LegacyReport> e() {
        return this.b;
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    public String c() {
        return "LegacyReporting";
    }

    @Override
    public synchronized void a(Instrumentation instrumentation, List<? extends ContrastPlugin> list) {
        if (this.d != null) {
            return;
        }
        this.c = true;
        this.d = com.contrastsecurity.agent.scope.c.a("Contrast Reporting", this.m).newThread(() -> {
            while (this.c) {
                try {
                    this.f();
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    o.error("Problem sending reports to Contrast TeamServer", throwable2);
                    this.m.a(throwable2);
                }
                try {
                    Thread.sleep(this.f);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.f();
        });
        o.info("Starting reporting thread...");
        this.d.start();
    }

    @Override
    public synchronized void a() {
        if (this.d == null) {
            return;
        }
        this.c = false;
        Thread thread = this.d;
        this.d = null;
        thread.interrupt();
        o.debug("Processing remaining elements in the reporting queue");
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            o.debug("Processing remaining elements in the queue - interrupted");
            return;
        }
        o.debug("Processing remaining elements in the queue - done");
    }

    @Override
    public a.a i() {
        return a.a.b;
    }

    private boolean c(LegacyReport legacyReport) {
        long l2 = legacyReport.getHash();
        if (this.a(legacyReport.getApplication(), l2)) {
            legacyReport.onIgnoredAsAlreadyReported();
            if (o.isDebugEnabled()) {
                o.debug("LegacyReport {} already reported to server: {}", (Object)l2, (Object)legacyReport.getShortDescription());
            }
            return false;
        }
        if (this.b.offer(legacyReport)) {
            this.a.put(com.contrastsecurity.agent.services.ngreporting.i.b(legacyReport.getApplication(), l2), this.j.now());
            legacyReport.onAcceptedIntoReportingQueue();
            if (o.isDebugEnabled()) {
                o.debug("Trace {} added to reporting queue: {}", (Object)l2, (Object)legacyReport.getShortDescription());
            }
            return true;
        }
        if (o.isDebugEnabled()) {
            o.debug("Trace {} was skipped as reporting queue was full: {}", (Object)l2, (Object)legacyReport.getShortDescription());
        }
        return false;
    }

    @Override
    public boolean a(Application application, long l2) {
        if (l2 == 0L) {
            return false;
        }
        long l3 = this.j.now();
        Long l4 = this.a.get(com.contrastsecurity.agent.services.ngreporting.i.b(application, l2));
        return l4 != null && l3 - l4 <= this.l;
    }

    private static long b(Application application, long l2) {
        return (long)(application == null ? 0 : application.hashCode()) + l2;
    }

    @t
    void f() {
        int n2;
        ArrayList<LegacyReport> arrayList;
        SaveReportMode saveReportMode;
        boolean bl2;
        block20: {
            LegacyReport legacyReport;
            ArrayList<LegacyReport> arrayList2 = new ArrayList<LegacyReport>();
            ArrayList<LegacyReport> arrayList3 = new ArrayList<LegacyReport>();
            bl2 = false;
            saveReportMode = com.contrastsecurity.agent.services.ngreporting.i.a(this.h);
            boolean bl3 = SaveReportMode.Always.equals((Object)saveReportMode);
            while ((legacyReport = this.b.poll()) != null) {
                Application application = legacyReport.getApplication();
                if (application == null) {
                    arrayList3.add(legacyReport);
                } else if (!application.isUnwanted()) {
                    if (!application.getState().c()) {
                        arrayList2.add(legacyReport);
                    } else {
                        arrayList3.add(legacyReport);
                    }
                }
                if (!bl3) continue;
                this.e.a(legacyReport);
                bl2 = true;
            }
            int n3 = arrayList2.size();
            if (n3 > 0) {
                this.b.addAll(arrayList2);
                o.debug("Held back {} reports until app created.", (Object)n3);
            }
            if (arrayList3.size() == 0) {
                return;
            }
            if (this.i == null) {
                return;
            }
            arrayList = new ArrayList<LegacyReport>();
            HashMap<Integer, LegacyReport> hashMap = new HashMap<Integer, LegacyReport>();
            n2 = 0;
            for (LegacyReport object2 : arrayList3) {
                if (object2.requiresPreflight()) {
                    hashMap.put(n2++, object2);
                    if (!(object2 instanceof k)) continue;
                    this.a((k)object2);
                    continue;
                }
                o.debug("Adding {} to preflight approved reports", (Object)object2.getHash());
                arrayList.add(object2);
            }
            if (!hashMap.isEmpty()) {
                try {
                    arrayList.addAll(this.i.a(hashMap));
                }
                catch (IOException iOException) {
                    if (saveReportMode.equals((Object)SaveReportMode.OnError)) {
                        for (Object object : hashMap.values()) {
                            this.e.a((LegacyReport)object);
                        }
                        bl2 = true;
                    }
                    if (o.isDebugEnabled()) {
                        String string = this.g ? "adding all" : "not adding any";
                        o.debug("Problem asking for preflight acceptance of reports - {} to approved list", (Object)string, (Object)iOException);
                    }
                    if (!this.g) break block20;
                    arrayList.addAll(hashMap.values());
                }
            }
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            int n3;
            Object object;
            LegacyReport legacyReport = (LegacyReport)arrayList.get(i2);
            if (legacyReport instanceof k) {
                this.b((k)legacyReport);
            }
            int n4 = n3 = (object = this.i.a(legacyReport)) != null ? ((g)object).a() : -1;
            if (saveReportMode.equals((Object)SaveReportMode.OnError) && n3 == -1 && !bl2) {
                this.e.a(legacyReport);
            }
            ++n2;
            if (!this.h()) continue;
            o.warn("Received bad response after sending {} of {} approved reports. Dumping the queue and pausing service.", (Object)n2, (Object)arrayList.size());
            this.j();
            break;
        }
        o.trace("Sent out {} reports to server", (Object)n2);
    }

    private void a(k k2) {
        s s2 = k2.getListener();
        if (s2 != null) {
            s2.a(k2);
        }
    }

    private void b(k k2) {
        s s2 = k2.getListener();
        if (s2 != null) {
            s2.b(k2);
        }
    }

    @Override
    public g<String> b(LegacyReport legacyReport) {
        g<String> g2 = null;
        if (this.g()) {
            o.debug("Not sending report because reporting service is still paused");
        } else if (!this.c) {
            o.debug("Not sending report because reporting service is stopped");
        } else if (this.i != null) {
            g2 = this.i.a(legacyReport);
            int n2 = g2 != null ? g2.a() : -1;
            SaveReportMode saveReportMode = com.contrastsecurity.agent.services.ngreporting.i.a(this.h);
            if (SaveReportMode.OnError.equals((Object)saveReportMode) && n2 == -1 || SaveReportMode.Always.equals((Object)saveReportMode)) {
                this.e.a(legacyReport);
            }
        }
        if (this.h()) {
            this.j();
        }
        return g2;
    }

    @Override
    public boolean a(LegacyReport legacyReport) {
        if (this.g()) {
            o.debug("Not queuing report because reporting service is still paused by an earlier 401 or 412");
            return false;
        }
        if (!this.c) {
            o.debug("Not queueing report because reporting service is stopped");
            return false;
        }
        String string = this.h.a(ConfigProperty.VM_ID);
        if (legacyReport.getApplication() != null) {
            string = legacyReport.getApplication().getName();
        }
        if (o.isDebugEnabled()) {
            o o2 = null;
            String string2 = "Unable to generate report JSON";
            try {
                string2 = legacyReport.getPayload();
            }
            catch (o o3) {
                o2 = o3;
            }
            o.debug("\n\tApplication: {}\n\tReportMethod: {}\n\tReportURL(): {}\n\tReportLevel(): {}\n\tReportType(): {}\n\tReportJSON():\n{}\n", new Object[]{string, legacyReport.getMethod(), legacyReport.getURL(), legacyReport.getLevel(), legacyReport.getClass().getSimpleName(), string2, o2});
        }
        return this.c(legacyReport);
    }

    boolean g() {
        return this.k.b();
    }

    boolean h() {
        return this.k.b();
    }

    void j() {
        this.b.clear();
        o.warn("Clearing reporting service queue and pausing reports because of paused TeamServer channel");
    }

    void k() {
        this.a.clear();
    }

    void l() {
        this.b.clear();
    }

    static SaveReportMode a(com.contrastsecurity.agent.config.e e2) {
        String string = e2.a(ConfigProperty.SAVERESULTS);
        SaveReportMode saveReportMode = SaveReportMode.valueOfIgnoreCase(string);
        if (saveReportMode == null) {
            throw new b("Invalid value [" + string + "] set for " + (Object)((Object)ConfigProperty.SAVERESULTS) + ". Valid values are Always, Never, OnError.");
        }
        return saveReportMode;
    }
}

