/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.test.integration;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.messages.routes.DiscoveredRoute;
import com.contrastsecurity.agent.messages.routes.ObservedRoute;
import com.contrastsecurity.agent.opentelemetry.OtelGlobalConfig;
import com.contrastsecurity.agent.plugins.apps.ApplicationSettingsUpdateEventBus;
import com.contrastsecurity.agent.plugins.j;
import com.contrastsecurity.agent.plugins.observe.ObserveRootSpanManager;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.L;
import com.contrastsecurity.agent.startup.P;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Provider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@DontObfuscate
public final class IntegrationTestServices {
    public final e config;
    public final WorkingDirectories workingDirectories;
    public final Instrumentation instrumentation;
    public final ThreadLocal<Long> threadContextId = new ThreadLocal();
    private final Map<String, Set<DiscoveredRoute>> appDiscoveredRoutesMap = new ConcurrentHashMap<String, Set<DiscoveredRoute>>();
    private final Map<String, ObservedRoute> observedRoutes = new ConcurrentHashMap<String, ObservedRoute>();
    public final ScopeProvider scopeProvider;
    public final ScopeProviderAssess scopeProviderAssess;
    public final ApplicationManager applicationManager;
    public final HttpManager httpManager;
    public final ObserveRootSpanManager rootSpanManager;
    public final AssessmentManager assessmentManager;
    public final EventContext eventContext;
    public final OtelGlobalConfig otelGlobalConfig;
    public final ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus;
    public final j pluginManager;
    private static IntegrationTestServices instance;
    private static final AtomicLong THREAD_ID_GENERATOR;

    @Inject
    public IntegrationTestServices(e e2, Instrumentation instrumentation, ApplicationManager applicationManager, AssessmentManager assessmentManager, ScopeProviderAssess scopeProviderAssess, EventContext eventContext, HttpManager httpManager, ObserveRootSpanManager observeRootSpanManager, ScopeProvider scopeProvider, OtelGlobalConfig otelGlobalConfig, ApplicationSettingsUpdateEventBus applicationSettingsUpdateEventBus, j j2) {
        this.config = e2;
        try {
            this.workingDirectories = WorkingDirectories.fromConfig(e2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        this.instrumentation = instrumentation;
        this.scopeProvider = scopeProvider;
        this.scopeProviderAssess = scopeProviderAssess;
        this.applicationManager = applicationManager;
        this.httpManager = httpManager;
        this.rootSpanManager = observeRootSpanManager;
        this.assessmentManager = assessmentManager;
        this.eventContext = eventContext;
        this.otelGlobalConfig = otelGlobalConfig;
        this.applicationSettingsUpdateEventBus = applicationSettingsUpdateEventBus;
        this.pluginManager = j2;
    }

    public static boolean isEnabled() {
        return instance != null;
    }

    public AssessmentManager assess() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.assessmentManager;
    }

    public ApplicationManager getApplicationManager() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.applicationManager;
    }

    public HttpManager getHttpManager() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.httpManager;
    }

    public ScopeProviderAssess getScopeProviderAssess() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        return this.scopeProviderAssess;
    }

    public static long newThreadContextId() {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        long l2 = THREAD_ID_GENERATOR.incrementAndGet();
        IntegrationTestServices.instance.threadContextId.set(l2);
        return l2;
    }

    public static long currentThreadContextId() {
        if (instance == null) {
            return Long.MIN_VALUE;
        }
        Long l2 = IntegrationTestServices.instance.threadContextId.get();
        return l2 == null ? Long.MIN_VALUE : l2;
    }

    public void addDiscoveredRoutes(Collection<DiscoveredRoute> collection, Application application) {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        this.appDiscoveredRoutesMap.compute(application.getName(), (string, set) -> {
            HashSet hashSet = new HashSet(collection);
            if (set == null) {
                return hashSet;
            }
            hashSet.addAll(set);
            return hashSet;
        });
    }

    public void addObservedRoute(ObservedRoute observedRoute) {
        this.observedRoutes.put(observedRoute.url(), observedRoute);
    }

    public Set<DiscoveredRoute> getAllDiscoveredRoutesForApp(Application application, long l2) throws InterruptedException {
        return this.getFromMapWithTimeout(this.appDiscoveredRoutesMap, application.getName(), l2);
    }

    public ObservedRoute getObservedRoute(String string, long l2) throws InterruptedException {
        return this.getFromMapWithTimeout(this.observedRoutes, string, l2);
    }

    private <A> A getFromMapWithTimeout(Map<String, A> map, String string, long l2) throws InterruptedException {
        if (instance == null) {
            throw new IllegalStateException("Integration test services are not enabled");
        }
        int n2 = 0;
        while ((long)n2 < l2) {
            A a2 = map.get(string);
            if (a2 != null) {
                return a2;
            }
            Thread.sleep(1000L);
            n2 += 1000;
        }
        return map.get(string);
    }

    public static IntegrationTestServices getInstance() {
        if (instance == null) {
            throw new IllegalStateException(IntegrationTestServices.class.getSimpleName() + " is not available in production.");
        }
        return instance;
    }

    static {
        THREAD_ID_GENERATOR = new AtomicLong(Long.MIN_VALUE);
    }

    @DontObfuscate
    public static final class StartupTask
    implements P {
        private final e config;
        private final Provider<IntegrationTestServices> integrationTestServicesProvider;

        @Inject
        public StartupTask(e e2, Provider<IntegrationTestServices> provider) {
            this.config = e2;
            this.integrationTestServicesProvider = provider;
        }

        @Override
        public void onStartupBegin(L l2) throws FatalStartupException {
            if (!this.config.c(ConfigProperty.ENABLE_INTEGRATION_TEST_SERVICES)) {
                return;
            }
            instance = this.integrationTestServicesProvider.get();
        }

        @Override
        public void onStartupEnd(L l2) {
        }

        @Override
        public String getTaskName() {
            return "integrationTestServices";
        }
    }
}

