/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.http.f;
import com.contrastsecurity.agent.i;
import com.contrastsecurity.agent.messages.finding.trace.EventActionDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventSignatureDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTagTypeDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTaintRangeDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTypeDTM;
import com.contrastsecurity.agent.messages.finding.trace.ObjectDTM;
import com.contrastsecurity.agent.messages.finding.trace.ParentObjectIdDTM;
import com.contrastsecurity.agent.messages.finding.trace.StackDTM;
import com.contrastsecurity.agent.plugins.security.AssessContextSnapshotCache;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.services.ngreporting.o;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.MethodDescription;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.d;
import com.contrastsecurity.agent.v.l;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.binary.Base64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
public class CodeEvent {
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    protected final EventTypeDTM eventTypeDTM;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    protected final EventActionDTM eventActionDTM;
    protected final long id;
    @HeapUsage.Deep
    protected final Set<Long> parentIds;
    @HeapUsage.Deep
    protected l stack;
    @HeapUsage.Deep
    protected TagRanges tagRanges;
    @HeapUsage.Deep
    protected final TagRanges displayTagRanges;
    @HeapUsage.Deep
    protected final d object;
    @HeapUsage.Deep
    protected final d returnValue;
    @HeapUsage.Cacheable(cache=AssessContextSnapshotCache.class)
    protected final char[][] parameterStrings;
    @HeapUsage.Deep
    protected final boolean[] parameterTracked;
    @HeapUsage.Deep
    protected final int[] parameterHash;
    @HeapUsage.Deep
    protected final char[][] parameterIds;
    protected final long timestamp;
    @HeapUsage.Cacheable(cache=AssessmentContext.a.class)
    protected final String threadDesc;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.AGENT_GLOBAL)
    protected final MethodDescription method;
    @HeapUsage.Deep
    protected final String sourceType;
    @HeapUsage.Deep
    protected final String targetType;
    protected static final String TRACE_NEWLINE_INDENT = "\n\t\t\t\t\t\t\t";
    private static final int SHORT_STRING_MAX_TRACE_SIZE = 15;

    protected CodeEvent(a a2) {
        this.id = a2.e();
        this.parentIds = a2.f();
        this.timestamp = a2.g();
        this.threadDesc = a2.h();
        this.method = Objects.requireNonNull(a2.i());
        this.eventTypeDTM = a2.j();
        this.eventActionDTM = a2.k();
        this.object = a2.t();
        this.returnValue = a2.u();
        this.parameterStrings = a2.n();
        this.parameterTracked = a2.m();
        this.parameterHash = a2.p();
        this.parameterIds = Objects.requireNonNull(a2.o());
        this.tagRanges = a2.q();
        this.displayTagRanges = a2.r();
        this.stack = a2.s();
        this.sourceType = a2.c();
        this.targetType = a2.d();
    }

    public void prepareForReporting(List<CodeEvent> list, int n2) {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public l getStack() {
        return this.stack;
    }

    public void setStack(l l2) {
        this.stack = l2;
    }

    public d getObject() {
        return this.object;
    }

    public d getReturnValue() {
        return this.returnValue;
    }

    public char[] getObj() {
        return this.getObject().c();
    }

    public char[] getRet() {
        return this.getReturnValue().c();
    }

    public char[][] getParameters() {
        return this.parameterStrings;
    }

    public String getThreadDesc() {
        return this.threadDesc;
    }

    public MethodDescription getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.method.getSignature());
        stringBuilder.append("\n         ");
        stringBuilder.append(this.getObj());
        stringBuilder.append(".");
        stringBuilder.append(this.method.getName());
        char[][] cArray = this.getParameters();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            stringBuilder.append(cArray[i2].toString());
            if (i2 == cArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(" => ");
        stringBuilder.append(this.getRet());
        stringBuilder.append(" ");
        stringBuilder.append(this.getTagRanges());
        return stringBuilder.toString();
    }

    public final EventDTM toDtm() throws o {
        this.ensureValid();
        return this.getCommonDtm();
    }

    public final EventDTM getCommonDtm() {
        return this.getCommonDtmBuilder().build();
    }

    protected EventDTM.Builder getCommonDtmBuilder() {
        List<EventTaintRangeDTM> list = this.buildTaintRangeDTMs();
        return EventDTM.builder().type(this.eventTypeDTM).action(this.eventActionDTM).time(this.timestamp).thread(f.a(this.threadDesc)).objectId(this.id).parentObjectIds(this.buildParentIdDtms()).source(this.sourceType).target(this.targetType).signature(EventSignatureDTM.builder().setClassName(this.method.getDeclaringClassType()).setMethodName(this.method.getName()).setConstructor("<init>".equalsIgnoreCase(this.method.getName())).setArgTypes(Arrays.asList(this.method.getParameterTypeNames())).setReturnType(this.method.getReturnTypeName()).setFlags(this.method.getModifiers()).build()).taintRanges(list).object(this.object.a(list)).ret(this.returnValue.a(list)).args(this.buildArgumentDTMs(list)).tags(EventDTM.Builder.buildTagsString(this.eventTypeDTM, this.buildEventTagTypeDTMs())).stack(this.buildStackDTM());
    }

    private List<EventTaintRangeDTM> buildTaintRangeDTMs() {
        List<EventTaintRangeDTM> list = this.tagRanges != null ? this.tagRanges.getDtm() : (this.displayTagRanges != null ? this.displayTagRanges.getDtm() : Collections.singletonList(new EventTaintRangeDTM(EventTagTypeDTM.UNTRUSTED, "")));
        return list;
    }

    private Set<ParentObjectIdDTM> buildParentIdDtms() {
        HashSet<ParentObjectIdDTM> hashSet;
        if (this.parentIds != null && !this.parentIds.isEmpty()) {
            hashSet = new HashSet<ParentObjectIdDTM>(this.parentIds.size());
            for (Long l2 : this.parentIds) {
                hashSet.add(new ParentObjectIdDTM(l2));
            }
        } else {
            hashSet = null;
        }
        return hashSet;
    }

    private List<ObjectDTM> buildArgumentDTMs(List<EventTaintRangeDTM> list) {
        boolean bl2 = !this.object.d() && !this.returnValue.d();
        ArrayList<ObjectDTM> arrayList = new ArrayList<ObjectDTM>(this.parameterStrings.length);
        for (int i2 = 0; i2 < this.parameterStrings.length; ++i2) {
            ObjectDTM objectDTM = new ObjectDTM(Base64.encodeBase64String(new String(this.parameterStrings[i2]).getBytes()), this.parameterHash[i2], this.parameterTracked[i2], bl2 && this.parameterTracked[i2] ? list : null);
            arrayList.add(objectDTM);
        }
        return arrayList;
    }

    private EventTagTypeDTM[] buildEventTagTypeDTMs() {
        EventTagTypeDTM[] eventTagTypeDTMArray = new EventTagTypeDTM[]{};
        Set<String> set = this.getTags();
        if (set != null && set.size() > 0) {
            ArrayList<EventTagTypeDTM> arrayList = new ArrayList<EventTagTypeDTM>(set.size());
            for (String string : set) {
                arrayList.add(EventTagTypeDTM.fromString(string));
            }
            eventTagTypeDTMArray = arrayList.toArray(eventTagTypeDTMArray);
        }
        return eventTagTypeDTMArray;
    }

    @t
    protected List<StackDTM> buildStackDTM() {
        ArrayList<StackDTM> arrayList = null;
        if (this.stack != null) {
            List<StackTraceElement> list = this.stack.a();
            arrayList = new ArrayList<StackDTM>(list.size());
            for (StackTraceElement stackTraceElement : list) {
                StackDTM stackDTM = StackDTM.of(stackTraceElement);
                arrayList.add(stackDTM);
            }
        }
        return arrayList;
    }

    @t
    public List<StackTraceElement> getStackWithoutContrastCode() {
        return this.stack.a();
    }

    @i
    public StringBuilder toShortString(StringBuilder stringBuilder) {
        int n2;
        String[] stringArray;
        stringBuilder.append("PLUG");
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("CALLEE: ").append(this.method.getReturnTypeName()).append(' ').append(this.method.getDeclaringClassType()).append('.').append(this.method.getName()).append('(');
        CodeEvent.joinWithSeparator(stringBuilder, this.method.getParameterTypeNames());
        stringBuilder.append(')');
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        if (this.stack != null) {
            stringArray = this.stack.a();
            for (n2 = 0; n2 < 15 && n2 < stringArray.size(); ++n2) {
                stringBuilder.append("CALLER: ").append(stringArray.get(n2)).append(TRACE_NEWLINE_INDENT);
            }
        }
        stringBuilder.append("OBJ:");
        CodeEvent.formatValueForShortString(stringBuilder, this.method.getDeclaringClassType(), this.object.c(), this.object.e(), this.object.d());
        stringBuilder.append(".");
        stringBuilder.append(this.method.getName());
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("LENGTH: ").append(this.object.c().length);
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("TAGS: ").append(this.getTagRanges());
        stringArray = this.method.getParameterTypeNames();
        for (n2 = 0; n2 < this.parameterStrings.length; ++n2) {
            stringBuilder.append(TRACE_NEWLINE_INDENT);
            stringBuilder.append("P-").append(n2).append(":");
            CodeEvent.formatValueForShortString(stringBuilder, stringArray[n2], this.parameterStrings[n2], this.parameterHash[n2], this.parameterTracked[n2]);
            stringBuilder.append(TRACE_NEWLINE_INDENT);
            stringBuilder.append("LENGTH: ").append(this.parameterStrings[n2].length);
        }
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("RET:");
        CodeEvent.formatValueForShortString(stringBuilder, this.method.getReturnTypeName(), this.returnValue.c(), this.returnValue.e(), this.returnValue.d());
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("LENGTH: ").append(this.returnValue.c().length);
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("OBJ_ID:").append(this.object.b());
        for (n2 = 0; n2 < this.parameterIds.length; ++n2) {
            stringBuilder.append(TRACE_NEWLINE_INDENT);
            stringBuilder.append("P-").append(n2).append("_ID:").append(this.parameterIds[n2]);
        }
        stringBuilder.append(TRACE_NEWLINE_INDENT);
        stringBuilder.append("RET_ID:").append(this.returnValue.b());
        return stringBuilder;
    }

    @i
    private static void formatValueForShortString(StringBuilder stringBuilder, String string, char[] cArray, int n2, boolean bl2) {
        stringBuilder.append(string).append('[').append(cArray).append(']');
        if (bl2) {
            stringBuilder.append('*').append(n2);
        }
    }

    @i
    private static void joinWithSeparator(StringBuilder stringBuilder, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(stringArray[i2]);
        }
    }

    public String getMethodName() {
        return this.method.getDeclaringClassType() + "." + this.method.getName();
    }

    public TagRanges getTagRanges() {
        return this.tagRanges;
    }

    public TagRanges getDisplayTagRanges() {
        return this.displayTagRanges;
    }

    public void addTags(String[] stringArray, int n2) throws InvalidTagRangeException {
        if (n2 <= 0) {
            return;
        }
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>(this.tagRanges.size() + stringArray.length);
        arrayList.addAll(this.tagRanges.getTagRanges());
        for (String string : stringArray) {
            arrayList.add(new TagRange(0, n2, string));
        }
        this.tagRanges = new TagRanges(arrayList);
    }

    public List<TagRange> getUntrustedRanges() {
        return this.tagRanges != null ? this.tagRanges.getUntrustedRanges() : null;
    }

    public Set<String> getTags() {
        return this.tagRanges != null ? this.tagRanges.getTags() : null;
    }

    public int getObjHash() {
        return this.getObject().e();
    }

    public int[] getParameterHashes() {
        return this.parameterHash;
    }

    public int getRetHash() {
        return this.getReturnValue().e();
    }

    public long getId() {
        return this.id;
    }

    public Set<Long> getParentIds() {
        return this.parentIds;
    }

    public boolean[] getParamsTracked() {
        return this.parameterTracked;
    }

    public boolean isAnyParamTracked() {
        boolean bl2 = false;
        if (this.parameterTracked != null) {
            for (int i2 = 0; i2 < this.parameterTracked.length && !bl2; ++i2) {
                bl2 = this.parameterTracked[i2];
            }
        }
        return bl2;
    }

    public boolean isObjectTracked() {
        return this.getObject().d();
    }

    public boolean isReturnTracked() {
        return this.getReturnValue().d();
    }

    protected void ensureValid() throws o {
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public EventTypeDTM getEventTypeDTM() {
        return this.eventTypeDTM;
    }

    public EventActionDTM getEventActionDTM() {
        return this.eventActionDTM;
    }

    public static interface a {
        public long e();

        public Set<Long> f();

        public long g();

        public String h();

        public MethodDescription i();

        public EventTypeDTM j();

        public EventActionDTM k();

        public boolean[] m();

        public char[][] n();

        public char[][] o();

        public int[] p();

        public TagRanges q();

        public TagRanges r();

        public l s();

        public String c();

        public String d();

        public d t();

        public d u();
    }
}

