/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace.snapshot;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsAssessDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventActionDTM;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.snapshot.DataSnapshot;
import com.contrastsecurity.agent.trace.snapshot.c;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.ArrayList;

@DontObfuscate
public final class SnapshotFactory {
    private final e config;
    private final int maxAssessSnapshotCacheSize;
    private final int maxSnapshotToStringLength;
    @t
    public static final a NOOP_SNAPSHOT_CACHE = new a();
    private static final DataSnapshot NULL_DATA_SNAPSHOT = new DataSnapshot(Empty.NULL, null);
    private static final String LM_CACHE = "AssessContextCache";
    private static final Logger logger = LoggerFactory.getLogger(SnapshotFactory.class);

    @Inject
    public SnapshotFactory(e e2) {
        this.config = e2;
        this.maxAssessSnapshotCacheSize = e2.d(ConfigProperty.MAX_CONTEXT_SNAPSHOT_CACHE_SIZE);
        this.maxSnapshotToStringLength = e2.d(ConfigProperty.MAX_SNAPSHOT_TOSTRING_LENGTH);
    }

    public char[] snapshot(AssessmentContext assessmentContext, Object object, EventActionDTM eventActionDTM) {
        return this.snapshot(assessmentContext != null ? assessmentContext.getSnapshotCache() : NOOP_SNAPSHOT_CACHE, object, eventActionDTM);
    }

    @t
    public char[] snapshot(c c2, Object object, EventActionDTM eventActionDTM) {
        if (object == null) {
            return Empty.NULL;
        }
        if (this.useMinimalSnapshot(eventActionDTM)) {
            return this.safeSnapshot(object);
        }
        char[] cArray = this.calculateToStringSnapshot(object, c2);
        if (cArray != null) {
            return cArray;
        }
        return this.safeSnapshot(object);
    }

    public DataSnapshot snapshot(AssessmentContext assessmentContext, Object object, TagRanges tagRanges, EventActionDTM eventActionDTM) {
        return this.snapshot(assessmentContext != null ? assessmentContext.getSnapshotCache() : NOOP_SNAPSHOT_CACHE, object, tagRanges, eventActionDTM);
    }

    @t
    public DataSnapshot snapshot(c c2, Object object, TagRanges tagRanges, EventActionDTM eventActionDTM) {
        if (object == null) {
            return NULL_DATA_SNAPSHOT;
        }
        if (this.useMinimalSnapshot(eventActionDTM)) {
            return this.safeDataSnapshot(object, tagRanges);
        }
        char[] cArray = this.calculateToStringSnapshot(object, c2);
        if (cArray != null) {
            return new DataSnapshot(cArray, tagRanges);
        }
        return this.safeDataSnapshot(object, tagRanges);
    }

    private boolean useMinimalSnapshot(EventActionDTM eventActionDTM) {
        if (eventActionDTM == null) {
            return false;
        }
        ServerSettingsAssessDTM.EventDetailEnum eventDetailEnum = ServerSettingsAssessDTM.EventDetailEnum.findByName(this.config.a(ConfigProperty.EVENT_DETAIL));
        switch (eventActionDTM) {
            case CREATION: {
                return eventDetailEnum == ServerSettingsAssessDTM.EventDetailEnum.SINK || eventDetailEnum == ServerSettingsAssessDTM.EventDetailEnum.OFF;
            }
            case TRIGGER: {
                return eventDetailEnum == ServerSettingsAssessDTM.EventDetailEnum.OFF;
            }
        }
        return eventDetailEnum != ServerSettingsAssessDTM.EventDetailEnum.FULL;
    }

    private char[] calculateToStringSnapshot(Object object, c c2) {
        if (!SnapshotFactory.shouldUseToString(object)) {
            return null;
        }
        char[] cArray = c2.getSnapshot(object);
        if (cArray != null) {
            this.logCacheHit(object);
            return cArray;
        }
        this.logCacheMiss(object);
        int n2 = this.estimateLength(object);
        if (n2 >= this.maxSnapshotToStringLength || n2 == 0) {
            return null;
        }
        if (object instanceof char[]) {
            return (char[])object;
        }
        String string = object.toString();
        int n3 = string.length();
        if (n3 <= this.maxSnapshotToStringLength && n3 > 0) {
            cArray = string.toCharArray();
            if (SnapshotFactory.shouldCache(object) && c2.cacheEntries() < this.maxAssessSnapshotCacheSize) {
                c2.putSnapshot(object, cArray);
            }
            return cArray;
        }
        return null;
    }

    private int estimateLength(Object object) {
        int n2 = -1;
        if (object instanceof String) {
            n2 = ((String)object).length();
        } else if (object instanceof StringBuilder) {
            n2 = ((StringBuilder)object).length();
        } else if (object instanceof StringBuffer) {
            n2 = ((StringBuffer)object).length();
        } else if (object instanceof CharBuffer) {
            n2 = ((CharBuffer)object).length();
        } else if (object instanceof char[]) {
            n2 = ((char[])object).length;
        }
        return n2;
    }

    private char[] safeSnapshot(Object object) {
        return JVMUtils.getSafeToString(object).toCharArray();
    }

    private DataSnapshot safeDataSnapshot(Object object, TagRanges tagRanges) {
        char[] cArray = this.safeSnapshot(object);
        int n2 = cArray.length;
        if (tagRanges == null) {
            return new DataSnapshot(cArray, null);
        }
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>();
        for (TagRange tagRange : tagRanges) {
            arrayList.add(new TagRange(0, n2, tagRange.getTag()));
        }
        return new DataSnapshot(cArray, new TagRanges(arrayList));
    }

    static boolean shouldUseToString(Object object) {
        return SnapshotFactory.shouldCache(object) || object instanceof StringBuilder || object instanceof StringBuffer || object instanceof CharBuffer || object instanceof char[];
    }

    static boolean shouldCache(Object object) {
        return object instanceof String || object instanceof URI || object instanceof URL || object instanceof Character || object instanceof Number && StringUtils.startsWith(object.getClass().getName(), "java") || object.getClass() == File.class;
    }

    private void logCacheHit(Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}|{}|operation={}&value={}", LM_CACHE, "Hit", "Snapshot", JVMUtils.getSafeToString(object));
        }
    }

    private void logCacheMiss(Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}|{}|operation={}&type={}&value={}", LM_CACHE, "Miss", "Snapshot", object.getClass().getName(), JVMUtils.getSafeToString(object));
        }
    }

    private static class a
    implements c {
        private a() {
        }

        @Override
        public char[] getSnapshot(Object object) {
            return null;
        }

        @Override
        public void putSnapshot(Object object, char[] cArray) {
        }

        @Override
        public int cacheEntries() {
            return Integer.MAX_VALUE;
        }
    }
}

