/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.r;
import com.contrastsecurity.agent.t;
import com.contrastsecurity.agent.telemetry.h;
import com.contrastsecurity.agent.util.I;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.org.apache.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.time.DurationFormatUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

@DontObfuscate
public class PerfUtil {
    private static final boolean PROFILING_STARTUP = K.b(r.b(ConfigProperty.PROFILE_STARTUP.legacySystemPropertyName()));
    private static final String PREMAIN_DURATION_HEADER = "Premain Duration";
    private static final String REQUEST_COMPLETE_HEADER = "Uptime to First Request Complete";
    private static final String REQUEST_DURATION_HEADER = "First Request Duration";
    @t
    static final String STARTUP_STATS_HEADER_ROW = "Premain Duration (ms),Uptime to First Request Complete (ms),First Request Duration (ms)";
    @t
    static final String STARTUP_STATS_FILE_NAME = "startup-stats.csv";
    private static final Logger logger = LoggerFactory.getLogger(PerfUtil.class);

    private static boolean notProfilingStartup() {
        return !PROFILING_STARTUP && !logger.isDebugEnabled();
    }

    public static void printStartupTimingMessage(a a2, String string, I i2) {
        if (PerfUtil.notProfilingStartup()) {
            return;
        }
        String string2 = PerfUtil.createMessage(a2, string, i2.toString());
        PerfUtil.printStartupTimingMessage(string2);
    }

    public static void printStartupTimingMessage(a a2, String string, long l2) {
        if (PerfUtil.notProfilingStartup()) {
            return;
        }
        String string2 = PerfUtil.createMessage(a2, string, DurationFormatUtils.formatDurationHMS(l2));
        PerfUtil.printStartupTimingMessage(string2);
    }

    public static void printStartupTimingMessage(String string) {
        logger.debug(string);
        if (PROFILING_STARTUP) {
            PreConfigUtil.out(string);
        }
    }

    private static String createMessage(a a2, String string, String string2) {
        return "[startup] " + StringUtils.repeat("\t", a2.ordinal()) + string + " " + string2;
    }

    public static com.contrastsecurity.agent.http.h newStartupReportingFirstRequestEndListener(StartupTiming startupTiming, h h2, e e2) {
        return PerfUtil.newStartupReportingFirstRequestEndListener(PROFILING_STARTUP, startupTiming, h2, e2);
    }

    @t
    static com.contrastsecurity.agent.http.h newStartupReportingFirstRequestEndListener(boolean bl2, StartupTiming startupTiming, h h2, e e2) {
        return l2 -> {
            PerfUtil.writeStartupStats(bl2, startupTiming, l2, e2);
            h2.a("uptime-first-request-complete", startupTiming.currentJvmUptimeMs());
            h2.a("first-request-duration", l2);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @t
    static void writeStartupStats(boolean bl2, StartupTiming startupTiming, long l2, e e2) {
        long l3 = startupTiming.currentJvmUptimeMs();
        PerfUtil.printStartupTimingMessage(a.f, PREMAIN_DURATION_HEADER, startupTiming.premainElapsedTimeMs());
        PerfUtil.printStartupTimingMessage(a.f, REQUEST_COMPLETE_HEADER, l3);
        PerfUtil.printStartupTimingMessage(a.f, REQUEST_DURATION_HEADER, l2);
        if (!bl2) {
            return;
        }
        File file = null;
        PrintWriter printWriter = null;
        try {
            file = new File(WorkingDirectories.fromConfig(e2).workingDirectory(), STARTUP_STATS_FILE_NAME);
            printWriter = new PrintWriter(file, "UTF-8");
            printWriter.append(STARTUP_STATS_HEADER_ROW).append("\n").append(Long.toString(startupTiming.premainElapsedTimeMs())).append(",").append(Long.toString(l3)).append(",").append(Long.toString(l2)).append("\n");
        }
        catch (IOException iOException) {
            try {
                PreConfigUtil.err("Failed to write startup stats to " + (file != null ? file : STARTUP_STATS_FILE_NAME) + ".");
                iOException.printStackTrace(System.err);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(printWriter);
                throw throwable;
            }
            IOUtils.closeQuietly(printWriter);
        }
        IOUtils.closeQuietly(printWriter);
    }

    public static enum a {
        a(true, null),
        b(true, "sub"),
        c(false, "subs"),
        d(false, "subss"),
        e(false, "subsss"),
        f(true, null);

        private final boolean g;
        private final String h;

        private a(boolean bl2, String string2) {
            this.g = bl2;
            this.h = string2;
        }

        public boolean a() {
            return this.g;
        }

        public String b() {
            return this.h;
        }
    }
}

