/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.weakmap;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.locks.ReentrantLock;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
final class ReentrantSegment<K, V>
extends ReentrantLock
implements ConcurrentReferenceHashMap.Segment<K, V> {
    volatile transient int count;
    transient int modCount;
    transient int threshold;
    @HeapUsage.Deep
    volatile transient ConcurrentReferenceHashMap.HashEntry<K, V>[] table;
    final float loadFactor;
    @HeapUsage.Deep
    volatile transient ReferenceQueue<Object> refQueue;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    final ConcurrentReferenceHashMap.ReferenceType keyType;
    @HeapUsage.Shallow(reason=HeapUsage.Shallow.Reason.JVM_GLOBAL)
    final ConcurrentReferenceHashMap.ReferenceType valueType;
    final boolean identityComparisons;

    ReentrantSegment(int n2, float f2, ConcurrentReferenceHashMap.ReferenceType referenceType, ConcurrentReferenceHashMap.ReferenceType referenceType2, boolean bl2) {
        this.loadFactor = f2;
        this.keyType = referenceType;
        this.valueType = referenceType2;
        this.identityComparisons = bl2;
        this.setTable(ConcurrentReferenceHashMap.HashEntry.newArray(n2));
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public int modCount() {
        return this.modCount;
    }

    @Override
    public ConcurrentReferenceHashMap.HashEntry<K, V>[] table() {
        return this.table;
    }

    private boolean keyEq(Object object, Object object2) {
        return object == object2;
    }

    void setTable(ConcurrentReferenceHashMap.HashEntry<K, V>[] hashEntryArray) {
        this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
        this.table = hashEntryArray;
        this.refQueue = new ReferenceQueue();
    }

    ConcurrentReferenceHashMap.HashEntry<K, V> getFirst(int n2) {
        ConcurrentReferenceHashMap.HashEntry<K, V>[] hashEntryArray = this.table;
        return hashEntryArray[n2 & hashEntryArray.length - 1];
    }

    ConcurrentReferenceHashMap.HashEntry<K, V> newHashEntry(K k2, int n2, ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry, V v2) {
        return new ConcurrentReferenceHashMap.HashEntry<K, V>(k2, n2, hashEntry, v2, this.keyType, this.valueType, this.refQueue);
    }

    V readValueUnderLock(ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry) {
        this.lock();
        try {
            this.removeStale();
            V v2 = hashEntry.value();
            return v2;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public V get(Object object, int n2) {
        if (this.count != 0) {
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry = this.getFirst(n2);
            while (hashEntry != null) {
                if (hashEntry.hash == n2 && this.keyEq(object, hashEntry.key())) {
                    Object object2 = hashEntry.valueRef;
                    if (object2 != null) {
                        return hashEntry.dereferenceValue(object2);
                    }
                    return this.readValueUnderLock(hashEntry);
                }
                hashEntry = hashEntry.next;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object, int n2) {
        if (this.count != 0) {
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry = this.getFirst(n2);
            while (hashEntry != null) {
                if (hashEntry.hash == n2 && this.keyEq(object, hashEntry.key())) {
                    return true;
                }
                hashEntry = hashEntry.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K k2, int n2, V v2, V v3) {
        this.lock();
        try {
            this.removeStale();
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry = this.getFirst(n2);
            while (!(hashEntry == null || hashEntry.hash == n2 && this.keyEq(k2, hashEntry.key()))) {
                hashEntry = hashEntry.next;
            }
            boolean bl2 = false;
            if (hashEntry != null && v2.equals(hashEntry.value())) {
                bl2 = true;
                hashEntry.setValue(v3, this.valueType, this.refQueue);
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K k2, int n2, V v2) {
        this.lock();
        try {
            this.removeStale();
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry = this.getFirst(n2);
            while (!(hashEntry == null || hashEntry.hash == n2 && this.keyEq(k2, hashEntry.key()))) {
                hashEntry = hashEntry.next;
            }
            V v3 = null;
            if (hashEntry != null) {
                v3 = hashEntry.value();
                hashEntry.setValue(v2, this.valueType, this.refQueue);
            }
            V v4 = v3;
            return v4;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k2, int n2, V v2, boolean bl2) {
        this.lock();
        try {
            V v3;
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry;
            int n3;
            this.removeStale();
            int n4 = this.count;
            if (n4++ > this.threshold && (n3 = this.rehash()) > 0) {
                this.count = (n4 -= n3) - 1;
            }
            ConcurrentReferenceHashMap.HashEntry<K, V>[] hashEntryArray = this.table;
            int n5 = n2 & hashEntryArray.length - 1;
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n5];
            while (!(hashEntry2 == null || hashEntry2.hash == n2 && this.keyEq(k2, hashEntry2.key()))) {
                hashEntry2 = hashEntry2.next;
            }
            if (hashEntry2 != null) {
                v3 = hashEntry2.value();
                if (!bl2) {
                    hashEntry2.setValue(v2, this.valueType, this.refQueue);
                }
            } else {
                v3 = null;
                ++this.modCount;
                hashEntryArray[n5] = this.newHashEntry(k2, n2, hashEntry, v2);
                this.count = n4;
            }
            V v4 = v3;
            return v4;
        }
        finally {
            this.unlock();
        }
    }

    int rehash() {
        ConcurrentReferenceHashMap.HashEntry<K, V>[] hashEntryArray = this.table;
        int n2 = hashEntryArray.length;
        if (n2 >= 0x40000000) {
            return 0;
        }
        ConcurrentReferenceHashMap.HashEntry<K, V>[] hashEntryArray2 = ConcurrentReferenceHashMap.HashEntry.newArray(n2 << 1);
        this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
        int n3 = hashEntryArray2.length - 1;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry = hashEntryArray[i2];
            if (hashEntry == null) continue;
            ConcurrentReferenceHashMap.HashEntry hashEntry2 = hashEntry.next;
            int n5 = hashEntry.hash & n3;
            if (hashEntry2 == null) {
                hashEntryArray2[n5] = hashEntry;
                continue;
            }
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry3 = hashEntry;
            int n6 = n5;
            ConcurrentReferenceHashMap.HashEntry hashEntry4 = hashEntry2;
            while (hashEntry4 != null) {
                int n7 = hashEntry4.hash & n3;
                if (n7 != n6) {
                    n6 = n7;
                    hashEntry3 = hashEntry4;
                }
                hashEntry4 = hashEntry4.next;
            }
            hashEntryArray2[n6] = hashEntry3;
            hashEntry4 = hashEntry;
            while (hashEntry4 != hashEntry3) {
                Object k2 = hashEntry4.key();
                if (k2 == null) {
                    ++n4;
                } else {
                    int n8 = hashEntry4.hash & n3;
                    ConcurrentReferenceHashMap.HashEntry hashEntry5 = hashEntryArray2[n8];
                    hashEntryArray2[n8] = this.newHashEntry(k2, hashEntry4.hash, hashEntry5, hashEntry4.value());
                }
                hashEntry4 = hashEntry4.next;
            }
        }
        this.table = hashEntryArray2;
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object, int n2, Object object2, boolean bl2) {
        this.lock();
        try {
            V v2;
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry;
            if (!bl2) {
                this.removeStale();
            }
            int n3 = this.count - 1;
            ConcurrentReferenceHashMap.HashEntry<K, V>[] hashEntryArray = this.table;
            int n4 = n2 & hashEntryArray.length - 1;
            ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry2 = hashEntry = hashEntryArray[n4];
            while (hashEntry2 != null && object != hashEntry2.keyRef && (bl2 || n2 != hashEntry2.hash || !this.keyEq(object, hashEntry2.key()))) {
                hashEntry2 = hashEntry2.next;
            }
            V v3 = null;
            if (hashEntry2 != null) {
                v2 = hashEntry2.value();
                if (object2 == null || object2.equals(v2)) {
                    v3 = v2;
                    ++this.modCount;
                    ConcurrentReferenceHashMap.HashEntry hashEntry3 = hashEntry2.next;
                    ConcurrentReferenceHashMap.HashEntry<K, V> hashEntry4 = hashEntry;
                    while (hashEntry4 != hashEntry2) {
                        K k2 = hashEntry4.key();
                        if (k2 == null) {
                            --n3;
                        } else {
                            hashEntry3 = this.newHashEntry(k2, hashEntry4.hash, hashEntry3, hashEntry4.value());
                        }
                        hashEntry4 = hashEntry4.next;
                    }
                    hashEntryArray[n4] = hashEntry3;
                    this.count = n3;
                }
            }
            v2 = v3;
            return v2;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void removeStale() {
        ConcurrentReferenceHashMap.a a2;
        while ((a2 = (ConcurrentReferenceHashMap.a)((Object)this.refQueue.poll())) != null) {
            this.remove(a2.keyRef(), a2.keyHash(), null, true);
        }
    }

    @Override
    public void clear() {
        if (this.count != 0) {
            this.lock();
            try {
                ConcurrentReferenceHashMap.HashEntry<K, V>[] hashEntryArray = this.table;
                for (int i2 = 0; i2 < hashEntryArray.length; ++i2) {
                    hashEntryArray[i2] = null;
                }
                ++this.modCount;
                this.refQueue = new ReferenceQueue();
                this.count = 0;
            }
            finally {
                this.unlock();
            }
        }
    }
}

