/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.protobuf;

import com.contrastsecurity.thirdparty.com.google.protobuf.ByteString;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedOutputStream;
import com.contrastsecurity.thirdparty.com.google.protobuf.Internal;
import com.contrastsecurity.thirdparty.com.google.protobuf.LazyStringList;
import com.contrastsecurity.thirdparty.com.google.protobuf.MapEntryLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.MessageLite;
import com.contrastsecurity.thirdparty.com.google.protobuf.Schema;
import com.contrastsecurity.thirdparty.com.google.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class CodedOutputStreamWriter
implements Writer {
    private final CodedOutputStream output;

    public static CodedOutputStreamWriter forCodedOutput(CodedOutputStream codedOutputStream) {
        if (codedOutputStream.wrapper != null) {
            return codedOutputStream.wrapper;
        }
        return new CodedOutputStreamWriter(codedOutputStream);
    }

    private CodedOutputStreamWriter(CodedOutputStream codedOutputStream) {
        this.output = Internal.checkNotNull(codedOutputStream, "output");
        this.output.wrapper = this;
    }

    @Override
    public Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.ASCENDING;
    }

    public int getTotalBytesWritten() {
        return this.output.getTotalBytesWritten();
    }

    @Override
    public void writeSFixed32(int n2, int n3) throws IOException {
        this.output.writeSFixed32(n2, n3);
    }

    @Override
    public void writeInt64(int n2, long l2) throws IOException {
        this.output.writeInt64(n2, l2);
    }

    @Override
    public void writeSFixed64(int n2, long l2) throws IOException {
        this.output.writeSFixed64(n2, l2);
    }

    @Override
    public void writeFloat(int n2, float f2) throws IOException {
        this.output.writeFloat(n2, f2);
    }

    @Override
    public void writeDouble(int n2, double d2) throws IOException {
        this.output.writeDouble(n2, d2);
    }

    @Override
    public void writeEnum(int n2, int n3) throws IOException {
        this.output.writeEnum(n2, n3);
    }

    @Override
    public void writeUInt64(int n2, long l2) throws IOException {
        this.output.writeUInt64(n2, l2);
    }

    @Override
    public void writeInt32(int n2, int n3) throws IOException {
        this.output.writeInt32(n2, n3);
    }

    @Override
    public void writeFixed64(int n2, long l2) throws IOException {
        this.output.writeFixed64(n2, l2);
    }

    @Override
    public void writeFixed32(int n2, int n3) throws IOException {
        this.output.writeFixed32(n2, n3);
    }

    @Override
    public void writeBool(int n2, boolean bl2) throws IOException {
        this.output.writeBool(n2, bl2);
    }

    @Override
    public void writeString(int n2, String string) throws IOException {
        this.output.writeString(n2, string);
    }

    @Override
    public void writeBytes(int n2, ByteString byteString) throws IOException {
        this.output.writeBytes(n2, byteString);
    }

    @Override
    public void writeUInt32(int n2, int n3) throws IOException {
        this.output.writeUInt32(n2, n3);
    }

    @Override
    public void writeSInt32(int n2, int n3) throws IOException {
        this.output.writeSInt32(n2, n3);
    }

    @Override
    public void writeSInt64(int n2, long l2) throws IOException {
        this.output.writeSInt64(n2, l2);
    }

    @Override
    public void writeMessage(int n2, Object object) throws IOException {
        this.output.writeMessage(n2, (MessageLite)object);
    }

    @Override
    public void writeMessage(int n2, Object object, Schema schema) throws IOException {
        this.output.writeMessage(n2, (MessageLite)object, schema);
    }

    @Override
    public void writeGroup(int n2, Object object) throws IOException {
        this.output.writeGroup(n2, (MessageLite)object);
    }

    @Override
    public void writeGroup(int n2, Object object, Schema schema) throws IOException {
        this.output.writeGroup(n2, (MessageLite)object, schema);
    }

    @Override
    public void writeStartGroup(int n2) throws IOException {
        this.output.writeTag(n2, 3);
    }

    @Override
    public void writeEndGroup(int n2) throws IOException {
        this.output.writeTag(n2, 4);
    }

    @Override
    public final void writeMessageSetItem(int n2, Object object) throws IOException {
        if (object instanceof ByteString) {
            this.output.writeRawMessageSetExtension(n2, (ByteString)object);
        } else {
            this.output.writeMessageSetExtension(n2, (MessageLite)object);
        }
    }

    @Override
    public void writeInt32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeInt32SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeInt32NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeInt32(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeFixed32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeFixed32SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeFixed32NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeFixed32(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeInt64List(int n2, List<Long> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeInt64SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeInt64NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeInt64(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeUInt64List(int n2, List<Long> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeUInt64SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeUInt64NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeUInt64(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeFixed64List(int n2, List<Long> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeFixed64SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeFixed64NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeFixed64(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeFloatList(int n2, List<Float> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeFloatSizeNoTag(list.get(n3).floatValue());
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeFloatNoTag(list.get(n3).floatValue());
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeFloat(n2, list.get(i2).floatValue());
            }
        }
    }

    @Override
    public void writeDoubleList(int n2, List<Double> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeDoubleSizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeDoubleNoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeDouble(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeEnumList(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeEnumSizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeEnumNoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeEnum(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeBoolList(int n2, List<Boolean> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeBoolSizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeBoolNoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeBool(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeStringList(int n2, List<String> list) throws IOException {
        if (list instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)list;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.writeLazyString(n2, lazyStringList.getRaw(i2));
            }
        } else {
            for (int i3 = 0; i3 < list.size(); ++i3) {
                this.output.writeString(n2, list.get(i3));
            }
        }
    }

    private void writeLazyString(int n2, Object object) throws IOException {
        if (object instanceof String) {
            this.output.writeString(n2, (String)object);
        } else {
            this.output.writeBytes(n2, (ByteString)object);
        }
    }

    @Override
    public void writeBytesList(int n2, List<ByteString> list) throws IOException {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.output.writeBytes(n2, list.get(i2));
        }
    }

    @Override
    public void writeUInt32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeUInt32SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeUInt32NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeUInt32(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeSFixed32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeSFixed32SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeSFixed32NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeSFixed32(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeSFixed64List(int n2, List<Long> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeSFixed64SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeSFixed64NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeSFixed64(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeSInt32List(int n2, List<Integer> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeSInt32SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeSInt32NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeSInt32(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeSInt64List(int n2, List<Long> list, boolean bl2) throws IOException {
        if (bl2) {
            int n3;
            this.output.writeTag(n2, 2);
            int n4 = 0;
            for (n3 = 0; n3 < list.size(); ++n3) {
                n4 += CodedOutputStream.computeSInt64SizeNoTag(list.get(n3));
            }
            this.output.writeUInt32NoTag(n4);
            for (n3 = 0; n3 < list.size(); ++n3) {
                this.output.writeSInt64NoTag(list.get(n3));
            }
        } else {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.output.writeSInt64(n2, list.get(i2));
            }
        }
    }

    @Override
    public void writeMessageList(int n2, List<?> list) throws IOException {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.writeMessage(n2, list.get(i2));
        }
    }

    @Override
    public void writeMessageList(int n2, List<?> list, Schema schema) throws IOException {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.writeMessage(n2, list.get(i2), schema);
        }
    }

    @Override
    public void writeGroupList(int n2, List<?> list) throws IOException {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.writeGroup(n2, list.get(i2));
        }
    }

    @Override
    public void writeGroupList(int n2, List<?> list, Schema schema) throws IOException {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.writeGroup(n2, list.get(i2), schema);
        }
    }

    @Override
    public <K, V> void writeMap(int n2, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        if (this.output.isSerializationDeterministic()) {
            this.writeDeterministicMap(n2, metadata, map);
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.output.writeTag(n2, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue()));
            MapEntryLite.writeTo(this.output, metadata, entry.getKey(), entry.getValue());
        }
    }

    private <K, V> void writeDeterministicMap(int n2, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        switch (metadata.keyType) {
            case BOOL: {
                V v2 = map.get(Boolean.FALSE);
                if (v2 != null) {
                    this.writeDeterministicBooleanMapEntry(n2, false, v2, metadata);
                }
                if ((v2 = map.get(Boolean.TRUE)) == null) break;
                this.writeDeterministicBooleanMapEntry(n2, true, v2, metadata);
                break;
            }
            case FIXED32: 
            case INT32: 
            case SFIXED32: 
            case SINT32: 
            case UINT32: {
                this.writeDeterministicIntegerMap(n2, metadata, map);
                break;
            }
            case FIXED64: 
            case INT64: 
            case SFIXED64: 
            case SINT64: 
            case UINT64: {
                this.writeDeterministicLongMap(n2, metadata, map);
                break;
            }
            case STRING: {
                this.writeDeterministicStringMap(n2, metadata, map);
                break;
            }
            default: {
                throw new IllegalArgumentException("does not support key type: " + (Object)((Object)metadata.keyType));
            }
        }
    }

    private <V> void writeDeterministicBooleanMapEntry(int n2, boolean bl2, V v2, MapEntryLite.Metadata<Boolean, V> metadata) throws IOException {
        this.output.writeTag(n2, 2);
        this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, bl2, v2));
        MapEntryLite.writeTo(this.output, metadata, bl2, v2);
    }

    private <V> void writeDeterministicIntegerMap(int n2, MapEntryLite.Metadata<Integer, V> metadata, Map<Integer, V> map) throws IOException {
        int[] nArray = new int[map.size()];
        int n3 = 0;
        Iterator<Integer> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int n4 = iterator.next();
            nArray[n3++] = n4;
        }
        Arrays.sort(nArray);
        for (Object object : (Iterator<Integer>)nArray) {
            V v2 = map.get((int)object);
            this.output.writeTag(n2, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (int)object, v2));
            MapEntryLite.writeTo(this.output, metadata, (int)object, v2);
        }
    }

    private <V> void writeDeterministicLongMap(int n2, MapEntryLite.Metadata<Long, V> metadata, Map<Long, V> map) throws IOException {
        long[] lArray = new long[map.size()];
        int n3 = 0;
        Iterator<Long> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            long l2 = iterator.next();
            lArray[n3++] = l2;
        }
        Arrays.sort(lArray);
        for (Object object : (Iterator<Long>)lArray) {
            V v2 = map.get((long)object);
            this.output.writeTag(n2, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (long)object, v2));
            MapEntryLite.writeTo(this.output, metadata, (long)object, v2);
        }
    }

    private <V> void writeDeterministicStringMap(int n2, MapEntryLite.Metadata<String, V> metadata, Map<String, V> map) throws IOException {
        Object[] objectArray = new String[map.size()];
        int n3 = 0;
        for (String string : map.keySet()) {
            objectArray[n3++] = string;
        }
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            V v2 = map.get(object);
            this.output.writeTag(n2, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, object, v2));
            MapEntryLite.writeTo(this.output, metadata, object, v2);
        }
    }
}

